/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bootgraph.spring;

import com.atlassian.bootgraph.api.mapper.NodeFactory;
import com.atlassian.bootgraph.api.model.Edge;
import com.atlassian.bootgraph.api.model.InternalNode;
import com.atlassian.bootgraph.api.model.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.env.Environment;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0003\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/bootgraph/spring/SpelEvaluator;", "", "()V", "evaluateSpel", "Lcom/atlassian/bootgraph/api/model/Node;", "model", "factory", "Lcom/atlassian/bootgraph/api/mapper/NodeFactory;", "environment", "Lorg/springframework/core/env/Environment;", "", "string", "evaluateSpelOptionally", "evaluateSpringExpressions", "originalModel", "bootgraph-core"})
public final class SpelEvaluator {
    @NotNull
    public final Node evaluateSpringExpressions(@NotNull Node originalModel, @NotNull NodeFactory factory, @NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)originalModel, (String)"originalModel");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Node newModel = this.evaluateSpel(originalModel, factory, environment);
        for (Edge inputConnection : originalModel.incomingEdges()) {
            Node newInputNode = this.evaluateSpel(inputConnection.getFrom(), factory, environment);
            newModel.addEdgeFrom(newInputNode, this.evaluateSpelOptionally(inputConnection.getLabel(), environment));
        }
        for (Edge outputConnection : originalModel.outgoingEdges()) {
            Node newOutputNode = this.evaluateSpel(outputConnection.getTo(), factory, environment);
            newModel.addEdgeTo(newOutputNode, this.evaluateSpelOptionally(outputConnection.getLabel(), environment));
        }
        return newModel;
    }

    private final Node evaluateSpel(Node model, NodeFactory factory, Environment environment) {
        return model instanceof InternalNode ? factory.internalNode(this.evaluateSpel(model.getName(), environment)) : factory.externalNode(this.evaluateSpel(model.getName(), environment));
    }

    private final String evaluateSpelOptionally(String string, Environment environment) {
        if (string == null) {
            return null;
        }
        return this.evaluateSpel(string, environment);
    }

    @NotNull
    public final String evaluateSpel(@NotNull String string, @NotNull Environment environment) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        try {
            String string3 = environment.resolvePlaceholders(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"environment.resolvePlaceholders(string)");
            string2 = string3;
        }
        catch (Exception e) {
            string2 = string;
        }
        return string2;
    }
}

