/*
 * Decompiled with CFR 0.152.
 */
package reliza.java.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reliza.java.client.Flags;
import reliza.java.client.RHService;
import reliza.java.client.interceptors.BasicAuthInterceptor;
import reliza.java.client.responses.ArtifactData;
import reliza.java.client.responses.FullRelease;
import reliza.java.client.responses.GraphQLResponse;
import reliza.java.client.responses.ProjectVersion;
import reliza.java.client.responses.ReleaseData;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class Library {
    private static final Logger log = LoggerFactory.getLogger(Library.class);
    Flags flags;
    RHService rhs;
    ObjectMapper OM = new ObjectMapper();
    String RELEASE_GQL_DATA;
    String FULL_RELEASE_GQL_DATA;

    public Library(Flags flags) {
        this.flags = flags;
        this.OM.registerModule((Module)new JavaTimeModule());
        this.OM.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new BasicAuthInterceptor(flags.getApiKeyId(), flags.getApiKey())).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(flags.getBaseUrl()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.OM)).client(client).build();
        this.rhs = (RHService)retrofit.create(RHService.class);
        this.RELEASE_GQL_DATA = "uuid \ncreatedType \nlastUpdatedBy \ncreatedDate \nversion \nstatus \norg \nproject \nbranch \nparentReleases { \ntimeSent \nrelease \nartifact \ntype \nnamespace \nproperties \nstate \nreplicas { \nid \nstate \n} \nisInError \n} \noptionalReleases { \ntimeSent \nrelease \nartifact \ntype \nnamespace \nproperties \nstate \nreplicas { \nid \nstate \n} \nisInError \n} \nsourceCodeEntry \ncommits \ncommitTime \nartifacts \ntype \nnotes \napprovals \ntiming { \nlifecycle \ndateFrom \ndateTo \ninstanceUuid \nenvironment \nevent \nduration \n} \ndecoratedVersionString \nendpoint";
        this.FULL_RELEASE_GQL_DATA = this.RELEASE_GQL_DATA + "\nsourceCodeEntryDetails { \nuuid \nbranchUuid\nvcsUuid\nvcsBranch\ncommit\ncommits\ncommitMessage\nvcsTag\nnotes\norg\ndateActual \n} \nvcsRepository { \nuuid \nname \norg \nuri \ntype \n} \nartifactDetails { \nuuid \nidentifier \norg \nbranch \nbuildId \nbuildUri \ncicdMeta \ndigests \nisInternal \nartifactType { \nname \naliases \n} \nnotes \ntagRecords {\nkey \nvalue \n} \ndateFrom \ndateTo \nbuildDuration \npackageType \nversion \npublisher \ngroup \ndependencies \n} \nprojectName \nnamespace";
    }

    public ProjectVersion getVersion() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("branch", this.flags.getBranch());
        variables.put("versionSchema", this.flags.getVersionSchema());
        variables.put("project", this.flags.getProjectId());
        variables.put("onlyVersion", this.flags.getOnlyVersion());
        variables.put("modifier", this.flags.getModifier());
        variables.put("metadata", this.flags.getMetadata());
        variables.put("action", this.flags.getAction());
        if (StringUtils.isNotEmpty((CharSequence)this.flags.getCommitHash()) || StringUtils.isNotEmpty((CharSequence)this.flags.getCommitMessage())) {
            HashMap<String, String> commitMap = new HashMap<String, String>();
            commitMap.put("commit", this.flags.getCommitHash());
            commitMap.put("commitMessage", this.flags.getCommitMessage());
            commitMap.put("uri", this.flags.getVcsUri());
            commitMap.put("type", this.flags.getVcsType());
            commitMap.put("vcsTag", this.flags.getVcsTag());
            commitMap.put("dateActual", this.flags.getDateActual());
            variables.put("sourceCodeEntry", commitMap);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.flags.getCommitList())) {
            String commits = new String(Base64.getDecoder().decode(this.flags.getCommitList()));
            List<String> commitList = Arrays.asList(StringUtils.split((String)commits, (String)System.lineSeparator()));
            ArrayList commitsInBody = new ArrayList();
            for (int i = 0; i < commitList.size(); ++i) {
                HashMap<String, String> singleCommit = new HashMap<String, String>();
                List<String> commitParts = Arrays.asList(StringUtils.split((String)commitList.get(i), (String)"|||"));
                singleCommit.put("commit", commitParts.get(0));
                singleCommit.put("dateActual", commitParts.get(1));
                singleCommit.put("commitMessage", commitParts.get(2));
                if (commitParts.size() > 3) {
                    singleCommit.put("commitAuthor", commitParts.get(3));
                    singleCommit.put("commitEmail", commitParts.get(4));
                }
                commitsInBody.add(singleCommit);
                if (i != 0 || StringUtils.isNotEmpty((CharSequence)this.flags.getCommitHash())) continue;
                HashMap<String, String> commitMap = new HashMap<String, String>();
                commitMap.put("commit", commitParts.get(0));
                commitMap.put("dateActual", commitParts.get(1));
                commitMap.put("commitMessage", commitParts.get(2));
                if (commitParts.size() > 3) {
                    commitMap.put("commitAuthor", commitParts.get(3));
                    commitMap.put("commitEmail", commitParts.get(4));
                }
                commitMap.put("vcsTag", this.flags.getVcsTag());
                commitMap.put("uri", this.flags.getVcsUri());
                commitMap.put("type", this.flags.getVcsType());
                variables.put("sourceCodeEntry", commitMap);
            }
            variables.put("commits", commitsInBody);
        }
        if (this.flags.getManual().booleanValue()) {
            variables.put("status", "DRAFT");
        }
        String query = "mutation ($GetNewVersionInput: GetNewVersionInput) { \ngetNewVersion(project:$GetNewVersionInput) \n}";
        HashMap<String, HashMap<String, Object>> input = new HashMap<String, HashMap<String, Object>>();
        input.put("GetNewVersionInput", variables);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("variables", input);
        Call<GraphQLResponse> call = this.rhs.getVersion(body);
        Map<String, Object> response = Library.execute(call);
        return response == null ? null : (ProjectVersion)this.OM.convertValue(response.get("getNewVersion"), ProjectVersion.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReleaseData addRelease() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("branch", this.flags.getBranch());
        variables.put("version", this.flags.getVersion());
        variables.put("status", StringUtils.isNotEmpty((CharSequence)this.flags.getStatus()) ? this.flags.getStatus().toUpperCase() : null);
        variables.put("endpoint", this.flags.getEndPoint());
        variables.put("project", this.flags.getProjectId());
        if (StringUtils.isNotEmpty((CharSequence)this.flags.getCommitHash())) {
            HashMap<String, String> commitMap = new HashMap<String, String>();
            commitMap.put("commit", this.flags.getCommitHash());
            commitMap.put("commitMessage", this.flags.getCommitMessage());
            commitMap.put("uri", this.flags.getVcsUri());
            commitMap.put("type", this.flags.getVcsType());
            commitMap.put("vcsTag", this.flags.getVcsTag());
            commitMap.put("dateActual", this.flags.getDateActual());
            variables.put("sourceCodeEntry", commitMap);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.flags.getCommitList())) {
            String commits = new String(Base64.getDecoder().decode(this.flags.getCommitList()));
            List<String> commitList = Arrays.asList(StringUtils.split((String)commits, (String)System.lineSeparator()));
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < commitList.size(); ++i) {
                HashMap<String, String> singleCommit = new HashMap<String, String>();
                List<String> commitParts = Arrays.asList(StringUtils.split((String)((String)commitList.get(i)), (String)"|||"));
                singleCommit.put("commit", commitParts.get(0));
                singleCommit.put("dateActual", commitParts.get(1));
                singleCommit.put("commitMessage", commitParts.get(2));
                if (commitParts.size() > 3) {
                    singleCommit.put("commitAuthor", commitParts.get(3));
                    singleCommit.put("commitEmail", commitParts.get(4));
                }
                arrayList.add(singleCommit);
                if (i != 0 || StringUtils.isNotEmpty((CharSequence)this.flags.getCommitHash())) continue;
                HashMap<String, String> commitMap = new HashMap<String, String>();
                commitMap.put("commit", commitParts.get(0));
                commitMap.put("dateActual", commitParts.get(1));
                commitMap.put("commitMessage", commitParts.get(2));
                if (commitParts.size() > 3) {
                    commitMap.put("commitAuthor", commitParts.get(3));
                    commitMap.put("commitEmail", commitParts.get(4));
                }
                commitMap.put("vcsTag", this.flags.getVcsTag());
                commitMap.put("uri", this.flags.getVcsUri());
                commitMap.put("type", this.flags.getVcsType());
                variables.put("sourceCodeEntry", commitMap);
            }
            variables.put("commits", arrayList);
        }
        if (CollectionUtils.isNotEmpty(this.flags.getArtId())) {
            ArrayList artifacts = new ArrayList();
            for (String string : this.flags.getArtId()) {
                if (StringUtils.isEmpty((CharSequence)string)) {
                    log.error("artid flag cannot be empty");
                    return null;
                }
                HashMap<String, String> artifact = new HashMap<String, String>();
                artifact.put("identifier", string);
                artifacts.add(artifact);
            }
            HashMap<String, List<String>> artFlags = new HashMap<String, List<String>>();
            artFlags.put("buildId", this.flags.getArtBuildId());
            artFlags.put("buildUri", this.flags.getArtBuildUri());
            artFlags.put("cicdMeta", this.flags.getArtCiMeta());
            artFlags.put("type", this.flags.getArtType());
            artFlags.put("artifactVersion", this.flags.getArtVersion());
            artFlags.put("publisher", this.flags.getArtPublisher().stream().map(s -> StringUtils.isNotEmpty((CharSequence)s) ? s.toUpperCase() : s).collect(Collectors.toList()));
            artFlags.put("packageType", this.flags.getArtPackage());
            artFlags.put("group", this.flags.getArtGroup());
            artFlags.put("dateFrom", this.flags.getDateStart());
            artFlags.put("dateTo", this.flags.getDateEnd());
            for (String key : artFlags.keySet()) {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)artFlags.get(key))) && ((List)artFlags.get(key)).size() != this.flags.getArtId().size()) {
                    log.error("number of art" + key.toLowerCase() + " flags must be either zero or match number of artid flags");
                    return null;
                }
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)artFlags.get(key)))) continue;
                for (int j = 0; j < this.flags.getArtId().size(); ++j) {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)((List)artFlags.get(key)).get(j)))) continue;
                    ((Map)artifacts.get(j)).put(key, ((List)artFlags.get(key)).get(j));
                }
            }
            if (CollectionUtils.isNotEmpty(this.flags.getArtDigests()) && this.flags.getArtDigests().size() != this.flags.getArtId().size()) {
                log.error("number of artdigests flags must be either zero or match number of artid flags");
                return null;
            }
            if (CollectionUtils.isNotEmpty(this.flags.getArtDigests())) {
                void var4_9;
                boolean bl = false;
                while (var4_9 < this.flags.getArtId().size()) {
                    if (!StringUtils.isEmpty((CharSequence)this.flags.getArtDigests().get((int)var4_9))) {
                        ((Map)artifacts.get((int)var4_9)).put("digests", Arrays.asList(StringUtils.split((String)this.flags.getArtDigests().get((int)var4_9), (String)",")));
                    }
                    ++var4_9;
                }
            }
            if (CollectionUtils.isNotEmpty(this.flags.getTagKeys()) && this.flags.getTagKeys().size() != this.flags.getArtId().size()) {
                log.error("number of tagkey flags must be either zero or match number of artid flags");
                return null;
            }
            if (CollectionUtils.isNotEmpty(this.flags.getTagVals()) && this.flags.getTagVals().size() != this.flags.getArtId().size()) {
                log.error("number of tagval flags must be either zero or match number of artid flags");
                return null;
            }
            if (CollectionUtils.isNotEmpty(this.flags.getTagKeys()) && CollectionUtils.isEmpty(this.flags.getTagVals())) {
                log.error("number of tagval and tagkey flags must be the same and must match number of artid flags");
                return null;
            }
            if (CollectionUtils.isNotEmpty(this.flags.getTagKeys())) {
                void var4_11;
                boolean bl = false;
                while (var4_11 < this.flags.getTagKeys().size()) {
                    if (!StringUtils.isEmpty((CharSequence)this.flags.getTagKeys().get((int)var4_11)) && !StringUtils.isEmpty((CharSequence)this.flags.getTagVals().get((int)var4_11))) {
                        List<String> keys = Arrays.asList(StringUtils.split((String)this.flags.getTagKeys().get((int)var4_11), (String)","));
                        List<String> vals = Arrays.asList(StringUtils.split((String)this.flags.getTagVals().get((int)var4_11), (String)","));
                        if (CollectionUtils.isNotEmpty(keys) && CollectionUtils.isNotEmpty(vals) && keys.size() != vals.size()) {
                            log.error("number of keys and values per each tagval and tagkey flag must be the same");
                            return null;
                        }
                        ArrayList<ArtifactData.TagRecord> tags = new ArrayList<ArtifactData.TagRecord>();
                        for (int j = 0; j < keys.size(); ++j) {
                            tags.add(new ArtifactData.TagRecord(keys.get(j), vals.get(j)));
                        }
                        ((Map)artifacts.get((int)var4_11)).put("tags", tags);
                    }
                    ++var4_11;
                }
            }
            variables.put("artifacts", artifacts);
        }
        String query = "mutation ($ReleaseInputProg: ReleaseInputProg) { \naddReleaseProg(release:$ReleaseInputProg) { \n" + this.RELEASE_GQL_DATA + "\n} \n}";
        HashMap<String, HashMap<String, Object>> input = new HashMap<String, HashMap<String, Object>>();
        input.put("ReleaseInputProg", variables);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("query", query);
        hashMap.put("variables", input);
        Call<GraphQLResponse> call = this.rhs.addRelease(hashMap);
        Map<String, Object> response = Library.execute(call);
        return response == null ? null : (ReleaseData)this.OM.convertValue(response.get("addReleaseProg"), ReleaseData.class);
    }

    public ReleaseData checkHash() {
        String query = "query ($hash: String!) { \ngetReleaseByHash(hash:$hash) { \n" + this.RELEASE_GQL_DATA + "\n} \n}";
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("hash", this.flags.getHash());
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("variables", input);
        Call<GraphQLResponse> call = this.rhs.checkHash(body);
        Map<String, Object> response = Library.execute(call);
        return response == null ? null : (ReleaseData)this.OM.convertValue(response.get("getReleaseByHash"), ReleaseData.class);
    }

    public Map<String, String> instData() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.flags.getImagesString())) {
            variables.put("images", Arrays.asList(StringUtils.split((String)this.flags.getImagesString(), (String)" ")));
        } else if (this.flags.getImageInputStream() != null) {
            try {
                byte[] imageBytes = IOUtils.toByteArray((InputStream)this.flags.getImageInputStream());
                variables.put("images", Arrays.asList(StringUtils.split((String)new String(imageBytes, StandardCharsets.UTF_8), (String)" ")));
            }
            catch (IOException e) {
                log.error("IO exception", (Throwable)e);
                return null;
            }
            catch (NullPointerException e) {
                log.error("NullPointerException", (Throwable)e);
                return null;
            }
        }
        variables.put("timeSent", Instant.now().toString());
        variables.put("namespace", this.flags.getNamespace());
        variables.put("senderId", this.flags.getSenderId());
        String query = "mutation ($InstanceDataInput: InstanceDataInput) { \ninstData(instance:$InstanceDataInput) \n}";
        HashMap<String, HashMap<String, Object>> input = new HashMap<String, HashMap<String, Object>>();
        input.put("InstanceDataInput", variables);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("variables", input);
        Call<GraphQLResponse> call = this.rhs.checkHash(body);
        Map<String, Object> response = Library.execute(call);
        return response == null ? null : (Map)response.get("instData");
    }

    public Optional<Boolean> prData() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("branch", this.flags.getBranch());
        variables.put("targetBranch", this.flags.getTargetBranch());
        variables.put("project", this.flags.getProjectId());
        variables.put("state", this.flags.getState());
        variables.put("endpoint", this.flags.getEndPoint());
        variables.put("title", this.flags.getTitle());
        variables.put("number", this.flags.getNumber());
        variables.put("createdDate", this.flags.getCreatedDate());
        variables.put("closedDate", this.flags.getClosedDate());
        variables.put("mergedDate", this.flags.getMergedDate());
        if (StringUtils.isNotEmpty((CharSequence)this.flags.getCommits())) {
            String commits = new String(Base64.getDecoder().decode(this.flags.getCommits()));
            List<String> commitList = Arrays.asList(StringUtils.split((String)commits, (String)System.lineSeparator()));
            ArrayList commitsInBody = new ArrayList();
            for (int i = 0; i < commitList.size(); ++i) {
                HashMap<String, String> singleCommit = new HashMap<String, String>();
                List<String> commitParts = Arrays.asList(StringUtils.split((String)commitList.get(i), (String)"|||"));
                singleCommit.put("commit", commitParts.get(0));
                singleCommit.put("dateActual", commitParts.get(1));
                singleCommit.put("commitMessage", commitParts.get(2));
                if (commitParts.size() > 3) {
                    singleCommit.put("commitAuthor", commitParts.get(3));
                    singleCommit.put("commitEmail", commitParts.get(4));
                }
                commitsInBody.add(singleCommit);
                if (i != 0 || StringUtils.isNotEmpty((CharSequence)this.flags.getCommitHash())) continue;
                HashMap<String, String> commitMap = new HashMap<String, String>();
                commitMap.put("commit", commitParts.get(0));
                commitMap.put("dateActual", commitParts.get(1));
                commitMap.put("commitMessage", commitParts.get(2));
                if (commitParts.size() > 3) {
                    commitMap.put("commitAuthor", commitParts.get(3));
                    commitMap.put("commitEmail", commitParts.get(4));
                }
                commitMap.put("vcsTag", this.flags.getVcsTag());
                commitMap.put("uri", this.flags.getVcsUri());
                commitMap.put("type", this.flags.getVcsType());
                variables.put("sourceCodeEntry", commitMap);
            }
            variables.put("commits", commitsInBody);
        }
        String query = "mutation ($PullRequestInput: PullRequestInput) { \nsetPRData(pullRequest:$PullRequestInput) \n}";
        HashMap<String, HashMap<String, Object>> input = new HashMap<String, HashMap<String, Object>>();
        input.put("PullRequestInput", variables);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("variables", input);
        Call<GraphQLResponse> call = this.rhs.prData(body);
        Map<String, Object> response = Library.execute(call);
        Optional<Boolean> returnVal = Optional.empty();
        if (response != null && response.get("setPRData") != null) {
            returnVal = Optional.of((Boolean)response.get("setPRData"));
        }
        return returnVal;
    }

    public List<FullRelease> getMyRelease() {
        String query = "query ($instance: String, $namespace: String) { \ngetMyRelease(instance:$instance, namespace:$namespace) { \n" + this.FULL_RELEASE_GQL_DATA + "\n} \n}";
        HashMap<String, String> variables = new HashMap<String, String>();
        HashMap<String, Object> body = new HashMap<String, Object>();
        variables.put("instance", this.flags.getInstance());
        variables.put("namespace", this.flags.getNamespace());
        body.put("query", query);
        body.put("variables", variables);
        Call<GraphQLResponse> call = this.rhs.addRelease(body);
        Map<String, Object> response = Library.execute(call);
        return response == null ? null : Arrays.asList((FullRelease[])this.OM.convertValue(response.get("getMyRelease"), FullRelease[].class));
    }

    public FullRelease getLatestRelease() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("project", this.flags.getProjectId());
        variables.put("environment", this.flags.getEnvironment());
        variables.put("product", this.flags.getProduct());
        if (CollectionUtils.isNotEmpty(this.flags.getTagKeys()) && CollectionUtils.isNotEmpty(this.flags.getTagVals())) {
            variables.put("tags", this.flags.getTagKeys().get(0) + " " + this.flags.getTagVals().get(0));
        }
        variables.put("branch", this.flags.getBranch());
        variables.put("instance", this.flags.getInstance());
        variables.put("namespace", this.flags.getNamespace());
        String query = "query ($GetLatestReleaseInput: GetLatestReleaseInput) { \ngetLatestRelease(release:$GetLatestReleaseInput) { \n" + this.FULL_RELEASE_GQL_DATA + "\n} \n}";
        HashMap<String, HashMap<String, Object>> input = new HashMap<String, HashMap<String, Object>>();
        input.put("GetLatestReleaseInput", variables);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("variables", input);
        Call<GraphQLResponse> call = this.rhs.addRelease(body);
        Map<String, Object> response = Library.execute(call);
        return response == null ? null : (FullRelease)this.OM.convertValue(response.get("getLatestRelease"), FullRelease.class);
    }

    public ReleaseData approveRelease() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        HashMap<String, Boolean> approvalMap = new HashMap<String, Boolean>();
        approvalMap.put(this.flags.getApprovalType(), this.flags.getDisapprove() == false);
        variables.put("approvals", approvalMap);
        variables.put("uuid", this.flags.getReleaseId());
        variables.put("version", this.flags.getVersion());
        variables.put("project", this.flags.getProjectId());
        variables.put("instance", this.flags.getInstance());
        variables.put("namespace", this.flags.getNamespace());
        String query = "mutation ($ApproveReleaseInput: ApproveReleaseInput) { \napproveReleaseProg(release:$ApproveReleaseInput) { \n" + this.RELEASE_GQL_DATA + "\n} \n}";
        HashMap<String, HashMap<String, Object>> input = new HashMap<String, HashMap<String, Object>>();
        input.put("ApproveReleaseInput", variables);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("variables", input);
        Call<GraphQLResponse> call = this.rhs.addRelease(body);
        Map<String, Object> response = Library.execute(call);
        return response == null ? null : (ReleaseData)this.OM.convertValue(response.get("approveReleaseProg"), ReleaseData.class);
    }

    private static Map<String, Object> execute(Call<GraphQLResponse> call) {
        try {
            Response resp = call.execute();
            if (((GraphQLResponse)resp.body()).getErrors() == null) {
                log.debug(((GraphQLResponse)resp.body()).getData().toString());
                return ((GraphQLResponse)resp.body()).getData();
            }
            log.error(((GraphQLResponse)resp.body()).getErrors().toString());
            return null;
        }
        catch (IOException e) {
            log.error("IO exception", (Throwable)e);
            return null;
        }
    }
}

