/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxRouter;
import restx.StdRestxRequestMatcher;
import restx.factory.Component;
import restx.factory.Factory;
import restx.factory.NamedComponent;
import restx.jackson.StdJsonProducerEntityRoute;

@Component
public class ApiDocsIndexRoute
extends StdJsonProducerEntityRoute {
    private final Factory factory;

    @Inject
    public ApiDocsIndexRoute(@Named(value="FrontObjectMapper") ObjectMapper mapper, Factory factory) {
        super("ApiDocsIndexRoute", mapper, (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/api-docs"));
        this.factory = factory;
    }

    protected Optional<?> doRoute(RestxRequest restxRequest, RestxRequestMatch match, Object i) throws IOException {
        return Optional.of((Object)ImmutableMap.builder().put((Object)"apiVersion", (Object)"0.1").put((Object)"swaggerVersion", (Object)"1.1").put((Object)"basePath", (Object)restxRequest.getBaseNetworkPath()).put((Object)"apis", this.buildApis()).build());
    }

    private List<ImmutableMap<String, String>> buildApis() {
        Set routers = this.factory.queryByClass(RestxRouter.class).find();
        ArrayList apis = Lists.newArrayList();
        for (NamedComponent router : routers) {
            String routerApiPath = ApiDocsIndexRoute.getRouterApiPath(router.getName().getName());
            apis.add(ImmutableMap.of((Object)"path", (Object)("/@/api-docs/" + routerApiPath), (Object)"name", (Object)routerApiPath, (Object)"group", (Object)((RestxRouter)router.getComponent()).getGroupName(), (Object)"description", (Object)""));
        }
        return apis;
    }

    static String getRouterApiPath(String path) {
        path = path.replaceAll("Router$", "").replaceAll("Resource$", "");
        path = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, path);
        return path;
    }
}

