/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.StdRestxRequestMatcher;
import restx.apidocs.SpecsResource;
import restx.common.MorePreconditions;
import restx.common.Types;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.security.Permissions;
import restx.security.RestxSecurityManager;
import restx.specs.RestxSpec;
import restx.specs.ThenHttpResponse;
import restx.validation.Validations;

@Component(priority=0)
public class SpecsResourceRouter
extends RestxRouter {
    public SpecsResourceRouter(final SpecsResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, final MainStringConverter converter, final Validator validator, final RestxSecurityManager securityManager) {
        super("restx-admin", "SpecsResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, Iterable<String>>("restx-admin#SpecsResource#findSpecsForOperation", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class}), Optional.absent()), (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/specs"), HttpStatus.OK, RestxLogLevel.DEFAULT){

            protected Optional<Iterable<String>> doRoute(RestxRequest request, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, Permissions.isAuthenticated());
                return Optional.of(resource.findSpecsForOperation((String)MorePreconditions.checkPresent((Optional)request.getQueryParam("httpMethod"), (String)"query param httpMethod is required", (Object[])new Object[0]), (String)MorePreconditions.checkPresent((Optional)request.getQueryParam("path"), (String)"query param path is required", (Object[])new Object[0])));
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription httpMethod = new OperationParameterDescription();
                httpMethod.name = "httpMethod";
                httpMethod.paramType = OperationParameterDescription.ParamType.query;
                httpMethod.dataType = "string";
                httpMethod.required = true;
                operation.parameters.add(httpMethod);
                OperationParameterDescription path = new OperationParameterDescription();
                path.name = "path";
                path.paramType = OperationParameterDescription.ParamType.query;
                path.dataType = "string";
                path.required = true;
                operation.parameters.add(path);
                operation.responseClass = "LIST[string]";
            }
        }, new StdEntityRoute<Void, RestxSpec>("restx-admin#SpecsResource#getSpecById", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(RestxSpec.class, Optional.absent()), (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/specs/{id}"), HttpStatus.OK, RestxLogLevel.DEFAULT){

            protected Optional<RestxSpec> doRoute(RestxRequest request, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, Permissions.isAuthenticated());
                return resource.getSpecById(match.getPathParam("id"));
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription id = new OperationParameterDescription();
                id.name = "id";
                id.paramType = OperationParameterDescription.ParamType.path;
                id.dataType = "string";
                id.required = true;
                operation.parameters.add(id);
                operation.responseClass = "RestxSpec";
            }
        }, new StdEntityRoute<ThenHttpResponse, ThenHttpResponse>("restx-admin#SpecsResource#updateSpecThenHttp", readerRegistry.build(ThenHttpResponse.class, Optional.absent()), writerRegistry.build(ThenHttpResponse.class, Optional.absent()), (RestxRequestMatcher)new StdRestxRequestMatcher("PUT", "/@/specs/{id}/wts/{wtsIndex}/then"), HttpStatus.OK, RestxLogLevel.DEFAULT){

            protected Optional<ThenHttpResponse> doRoute(RestxRequest request, RestxRequestMatch match, ThenHttpResponse body) throws IOException {
                securityManager.check(request, Permissions.isAuthenticated());
                return resource.updateSpecThenHttp(match.getPathParam("id"), (Integer)converter.convert(match.getPathParam("wtsIndex"), Integer.TYPE), (ThenHttpResponse)Validations.checkValid((Validator)validator, (Object)body));
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription id = new OperationParameterDescription();
                id.name = "id";
                id.paramType = OperationParameterDescription.ParamType.path;
                id.dataType = "string";
                id.required = true;
                operation.parameters.add(id);
                OperationParameterDescription wtsIndex = new OperationParameterDescription();
                wtsIndex.name = "wtsIndex";
                wtsIndex.paramType = OperationParameterDescription.ParamType.path;
                wtsIndex.dataType = "int";
                wtsIndex.required = true;
                operation.parameters.add(wtsIndex);
                OperationParameterDescription response = new OperationParameterDescription();
                response.name = "response";
                response.paramType = OperationParameterDescription.ParamType.body;
                response.dataType = "ThenHttpResponse";
                response.required = true;
                operation.parameters.add(response);
                operation.responseClass = "ThenHttpResponse";
            }
        }});
    }
}

