package restx.apidocs;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.apidocs.ApiDocsIndexRoute;

@Machine
public class ApiDocsIndexRouteFactoryMachine extends SingleNameFactoryMachine<restx.apidocs.ApiDocsIndexRoute> {
    public static final Name<restx.apidocs.ApiDocsIndexRoute> NAME = Name.of(restx.apidocs.ApiDocsIndexRoute.class, "ApiDocsIndexRoute");

    public ApiDocsIndexRouteFactoryMachine() {
        super(0, new StdMachineEngine<restx.apidocs.ApiDocsIndexRoute>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<com.fasterxml.jackson.databind.ObjectWriter> writer = Factory.Query.byName(Name.of(com.fasterxml.jackson.databind.ObjectWriter.class, "FrontObjectWriter")).mandatory();
private final Factory.Query<restx.factory.Factory> factory = Factory.Query.byClass(restx.factory.Factory.class).mandatory();
private final Factory.Query<restx.security.RestxSecurityManager> securityManager = Factory.Query.byClass(restx.security.RestxSecurityManager.class).mandatory();
private final Factory.Query<restx.security.PermissionFactory> permissionFactory = Factory.Query.byClass(restx.security.PermissionFactory.class).mandatory();
private final Factory.Query<restx.endpoint.EndpointParameterMapperRegistry> registry = Factory.Query.byClass(restx.endpoint.EndpointParameterMapperRegistry.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
writer,
factory,
securityManager,
permissionFactory,
registry
                ));
            }

            @Override
            protected restx.apidocs.ApiDocsIndexRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new ApiDocsIndexRoute(
satisfiedBOM.getOne(writer).get().getComponent(),
satisfiedBOM.getOne(factory).get().getComponent(),
satisfiedBOM.getOne(securityManager).get().getComponent(),
satisfiedBOM.getOne(permissionFactory).get().getComponent(),
satisfiedBOM.getOne(registry).get().getComponent()
                );
            }
        });
    }

}
