package restx.apidocs;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.apidocs.ApiDocsModule;


@Machine
public class ApiDocsModuleFactoryMachine extends DefaultFactoryMachine {
    private static final ApiDocsModule module = new ApiDocsModule();

    public ApiDocsModuleFactoryMachine() {
        super(0, new MachineEngine[] {
            new StdMachineEngine<restx.security.CORSAuthorizer>(Name.of(restx.security.CORSAuthorizer.class, "getApiDocsAuthorizer"), 0, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public restx.security.CORSAuthorizer doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.getApiDocsAuthorizer(
	        
	                    );
                }
            },
            new StdMachineEngine<restx.admin.AdminPage>(Name.of(restx.admin.AdminPage.class, "ApiDocs"), 0, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public restx.admin.AdminPage doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.getApiDocsAdminPage(
	        
	                    );
                }
            },

        });
    }
}
