package restx.apidocs;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.apidocs.JsonSchemaResource;

@Machine
public class JsonSchemaResourceFactoryMachine extends SingleNameFactoryMachine<restx.apidocs.JsonSchemaResource> {
    public static final Name<restx.apidocs.JsonSchemaResource> NAME = Name.of(restx.apidocs.JsonSchemaResource.class, "JsonSchemaResource");

    public JsonSchemaResourceFactoryMachine() {
        super(0, new StdMachineEngine<restx.apidocs.JsonSchemaResource>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<com.fasterxml.jackson.databind.ObjectMapper> mapper = Factory.Query.byName(Name.of(com.fasterxml.jackson.databind.ObjectMapper.class, "FrontObjectMapper")).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
mapper
                ));
            }

            @Override
            protected restx.apidocs.JsonSchemaResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new JsonSchemaResource(
satisfiedBOM.getOne(mapper).get().getComponent()
                );
            }
        });
    }

}
