package restx.apidocs;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.apidocs.SpecsResource;

@Machine
public class SpecsResourceFactoryMachine extends SingleNameFactoryMachine<restx.apidocs.SpecsResource> {
    public static final Name<restx.apidocs.SpecsResource> NAME = Name.of(restx.apidocs.SpecsResource.class, "SpecsResource");

    public SpecsResourceFactoryMachine() {
        super(0, new StdMachineEngine<restx.apidocs.SpecsResource>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.specs.RestxSpecRepository> repository = Factory.Query.byClass(restx.specs.RestxSpecRepository.class).mandatory();
private final Factory.Query<restx.specs.RestxSpec.StorageSettings> storageSettings = Factory.Query.byClass(restx.specs.RestxSpec.StorageSettings.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
repository,
storageSettings
                ));
            }

            @Override
            protected restx.apidocs.SpecsResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new SpecsResource(
satisfiedBOM.getOne(repository).get().getComponent(),
satisfiedBOM.getOne(storageSettings).get().getComponent()
                );
            }
        });
    }

}
