package restx.apidocs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import static com.google.common.base.Preconditions.checkNotNull;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableList;
import restx.common.Types;
import restx.common.TypeReference;
import restx.*;
import restx.entity.*;
import restx.http.*;
import restx.endpoint.*;
import restx.exceptions.WrappedCheckedException;
import restx.factory.*;
import restx.security.*;
import restx.security.PermissionFactory;
import restx.description.*;
import restx.converters.MainStringConverter;
import static restx.common.MorePreconditions.checkPresent;

import javax.validation.Validator;
import static restx.validation.Validations.checkValid;

import java.io.IOException;
import java.io.PrintWriter;

import java.util.Arrays;


@Component(priority = 0)

public class SpecsResourceRouter extends RestxRouter {

    public SpecsResourceRouter(
                    final SpecsResource resource,
                    final EntityRequestBodyReaderRegistry readerRegistry,
                    final EntityResponseWriterRegistry writerRegistry,
                    final MainStringConverter converter,
                    final PermissionFactory pf,
                    final Optional<Validator> validator,
                    final RestxSecurityManager securityManager,
                    final EndpointParameterMapperRegistry paramMapperRegistry) {
        super(
            "restx-admin", "SpecsResourceRouter", new RestxRoute[] {
        new StdEntityRoute<Void, java.lang.Iterable<java.lang.String>>("restx-admin#SpecsResource#findSpecsForOperation",
                readerRegistry.<Void>build(Void.class, Optional.<String>absent()),
                writerRegistry.<java.lang.Iterable<java.lang.String>>build(Types.newParameterizedType(java.lang.Iterable.class, java.lang.String.class), Optional.<String>absent()),
                Endpoint.of("GET", "/@/specs"),
                HttpStatus.OK, RestxLogLevel.DEFAULT, pf,
                paramMapperRegistry, new ParamDef[]{
                    ParamDef.of(new TypeReference<java.lang.String>(){}, "httpMethod"),
                    ParamDef.of(new TypeReference<java.lang.String>(){}, "path")
                }) {
            @Override
            protected Optional<java.lang.Iterable<java.lang.String>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, hasRole("restx-admin"));
                try {
                    return Optional.of(resource.findSpecsForOperation(
                        /* [QUERY] httpMethod */ checkValid(validator, checkNotNull(mapQueryObjectFromRequest(java.lang.String.class, "httpMethod", request, match, EndpointParameterKind.QUERY), "QUERY param <httpMethod> is required")),
                        /* [QUERY] path */ checkValid(validator, checkNotNull(mapQueryObjectFromRequest(java.lang.String.class, "path", request, match, EndpointParameterKind.QUERY), "QUERY param <path> is required"))
                    ));
                } catch(RuntimeException e) { throw e; }
                  catch(Exception e) { throw new WrappedCheckedException(e); }
            }

            @Override
            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription httpMethod = new OperationParameterDescription();
                httpMethod.name = "httpMethod";
                httpMethod.paramType = OperationParameterDescription.ParamType.query;
                httpMethod.dataType = "string";
                httpMethod.schemaKey = "";
                httpMethod.required = true;
                operation.parameters.add(httpMethod);

                OperationParameterDescription path = new OperationParameterDescription();
                path.name = "path";
                path.paramType = OperationParameterDescription.ParamType.query;
                path.dataType = "string";
                path.schemaKey = "";
                path.required = true;
                operation.parameters.add(path);


                operation.responseClass = "LIST[string]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Types.newParameterizedType(java.lang.Iterable.class, java.lang.String.class);
                operation.sourceLocation = "restx.apidocs.SpecsResource#findSpecsForOperation(java.lang.String,java.lang.String)";
                operation.annotations = ImmutableList.<java.lang.annotation.Annotation>builder()
                    .add(new restx.security.RolesAllowed() {
                        public Class<restx.security.RolesAllowed> annotationType() { return restx.security.RolesAllowed.class; }
                        public java.lang.String[] value() { return new java.lang.String[]{ "restx-admin" }; }
                    })
                    .add(new restx.annotations.GET() {
                        public Class<restx.annotations.GET> annotationType() { return restx.annotations.GET.class; }
                        public java.lang.String value() { return "/@/specs"; }
                    })
                    .build();
            }
        },
        new StdEntityRoute<Void, restx.specs.RestxSpec>("restx-admin#SpecsResource#getSpecById",
                readerRegistry.<Void>build(Void.class, Optional.<String>absent()),
                writerRegistry.<restx.specs.RestxSpec>build(restx.specs.RestxSpec.class, Optional.<String>absent()),
                Endpoint.of("GET", "/@/specs/{id}"),
                HttpStatus.OK, RestxLogLevel.DEFAULT, pf,
                paramMapperRegistry, new ParamDef[]{
                    ParamDef.of(new TypeReference<java.lang.String>(){}, "id")
                }) {
            @Override
            protected Optional<restx.specs.RestxSpec> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, hasRole("restx-admin"));
                try {
                    return resource.getSpecById(
                        /* [PATH] id */ checkValid(validator, checkNotNull(mapQueryObjectFromRequest(java.lang.String.class, "id", request, match, EndpointParameterKind.PATH), "PATH param <id> is required"))
                    );
                } catch(RuntimeException e) { throw e; }
                  catch(Exception e) { throw new WrappedCheckedException(e); }
            }

            @Override
            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription id = new OperationParameterDescription();
                id.name = "id";
                id.paramType = OperationParameterDescription.ParamType.path;
                id.dataType = "string";
                id.schemaKey = "";
                id.required = true;
                operation.parameters.add(id);


                operation.responseClass = "RestxSpec";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.specs.RestxSpec";
                operation.outEntityType = restx.specs.RestxSpec.class;
                operation.sourceLocation = "restx.apidocs.SpecsResource#getSpecById(java.lang.String)";
                operation.annotations = ImmutableList.<java.lang.annotation.Annotation>builder()
                    .add(new restx.security.RolesAllowed() {
                        public Class<restx.security.RolesAllowed> annotationType() { return restx.security.RolesAllowed.class; }
                        public java.lang.String[] value() { return new java.lang.String[]{ "restx-admin" }; }
                    })
                    .add(new restx.annotations.GET() {
                        public Class<restx.annotations.GET> annotationType() { return restx.annotations.GET.class; }
                        public java.lang.String value() { return "/@/specs/{id}"; }
                    })
                    .build();
            }
        },
        new StdEntityRoute<restx.specs.ThenHttpResponse, restx.specs.ThenHttpResponse>("restx-admin#SpecsResource#updateSpecThenHttp",
                readerRegistry.<restx.specs.ThenHttpResponse>build(restx.specs.ThenHttpResponse.class, Optional.<String>absent()),
                writerRegistry.<restx.specs.ThenHttpResponse>build(restx.specs.ThenHttpResponse.class, Optional.<String>absent()),
                Endpoint.of("PUT", "/@/specs/{id}/wts/{wtsIndex}/then"),
                HttpStatus.OK, RestxLogLevel.DEFAULT, pf,
                paramMapperRegistry, new ParamDef[]{
                    ParamDef.of(new TypeReference<java.lang.String>(){}, "id"),
                    ParamDef.of(int.class, "wtsIndex")
                }) {
            @Override
            protected Optional<restx.specs.ThenHttpResponse> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, restx.specs.ThenHttpResponse body) throws IOException {
                securityManager.check(request, match, hasRole("restx-admin"));
                try {
                    return resource.updateSpecThenHttp(
                        /* [PATH] id */ checkValid(validator, checkNotNull(mapQueryObjectFromRequest(java.lang.String.class, "id", request, match, EndpointParameterKind.PATH), "PATH param <id> is required")),
                        /* [PATH] wtsIndex */ checkValid(validator, checkNotNull(mapQueryObjectFromRequest(int.class, "wtsIndex", request, match, EndpointParameterKind.PATH), "PATH param <wtsIndex> is required")),
                        /* [BODY] response */ checkValid(validator, checkNotNull(body, "body param <response> is required"))
                    );
                } catch(RuntimeException e) { throw e; }
                  catch(IOException e) { throw e; }
                  catch(Exception e) { throw new WrappedCheckedException(e); }
            }

            @Override
            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription id = new OperationParameterDescription();
                id.name = "id";
                id.paramType = OperationParameterDescription.ParamType.path;
                id.dataType = "string";
                id.schemaKey = "";
                id.required = true;
                operation.parameters.add(id);

                OperationParameterDescription wtsIndex = new OperationParameterDescription();
                wtsIndex.name = "wtsIndex";
                wtsIndex.paramType = OperationParameterDescription.ParamType.path;
                wtsIndex.dataType = "int";
                wtsIndex.schemaKey = "int";
                wtsIndex.required = true;
                operation.parameters.add(wtsIndex);

                OperationParameterDescription response = new OperationParameterDescription();
                response.name = "response";
                response.paramType = OperationParameterDescription.ParamType.body;
                response.dataType = "ThenHttpResponse";
                response.schemaKey = "restx.specs.ThenHttpResponse";
                response.required = true;
                operation.parameters.add(response);


                operation.responseClass = "ThenHttpResponse";
                operation.inEntitySchemaKey = "restx.specs.ThenHttpResponse";
                operation.inEntityType = restx.specs.ThenHttpResponse.class;
                operation.outEntitySchemaKey = "restx.specs.ThenHttpResponse";
                operation.outEntityType = restx.specs.ThenHttpResponse.class;
                operation.sourceLocation = "restx.apidocs.SpecsResource#updateSpecThenHttp(java.lang.String,int,restx.specs.ThenHttpResponse)";
                operation.annotations = ImmutableList.<java.lang.annotation.Annotation>builder()
                    .add(new restx.security.RolesAllowed() {
                        public Class<restx.security.RolesAllowed> annotationType() { return restx.security.RolesAllowed.class; }
                        public java.lang.String[] value() { return new java.lang.String[]{ "restx-admin" }; }
                    })
                    .add(new restx.annotations.PUT() {
                        public Class<restx.annotations.PUT> annotationType() { return restx.annotations.PUT.class; }
                        public java.lang.String value() { return "/@/specs/{id}/wts/{wtsIndex}/then"; }
                    })
                    .build();
            }
        },
        });
    }

}
