/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.apidocs.ApiDocsIndexRoute;
import restx.description.DescribableRoute;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.description.OperationReference;
import restx.description.ResourceDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.factory.Component;
import restx.factory.Factory;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.jackson.StdJsonProducerEntityRoute;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;

@Component
public class ApiDeclarationRoute
extends StdJsonProducerEntityRoute {
    private final Factory factory;
    private final RestxSecurityManager securityManager;
    private PermissionFactory permissionFactory;

    @Inject
    public ApiDeclarationRoute(@Named(value="FrontObjectWriter") ObjectWriter writer, Factory factory, RestxSecurityManager securityManager, PermissionFactory permissionFactory, EndpointParameterMapperRegistry registry) {
        super("ApiDeclarationRoute", Map.class, writer, Endpoint.of((String)"GET", (String)"/@/api-docs/{router}"), permissionFactory, registry);
        this.factory = factory;
        this.securityManager = securityManager;
        this.permissionFactory = permissionFactory;
    }

    protected Optional<?> doRoute(RestxRequest restxRequest, RestxResponse response, RestxRequestMatch match, Object body) throws IOException {
        this.securityManager.check(restxRequest, match, this.permissionFactory.hasRole("restx-admin"));
        String routerName = match.getPathParam("router");
        Optional<NamedComponent<RestxRouter>> router = ApiDeclarationRoute.getRouterByName(this.factory, routerName);
        if (!router.isPresent()) {
            return Optional.absent();
        }
        List<ResourceDescription> apis = this.buildApis((NamedComponent<RestxRouter>)((NamedComponent)router.get()));
        return Optional.of((Object)ImmutableMap.builder().put((Object)"apiVersion", (Object)"0.1").put((Object)"swaggerVersion", (Object)"1.1").put((Object)"basePath", (Object)restxRequest.getBaseNetworkPath()).put((Object)"name", (Object)((RestxRouter)((NamedComponent)router.get()).getComponent()).getClass().getName().replaceAll("Router$", "")).put((Object)"apis", apis).build());
    }

    static Optional<NamedComponent<RestxRouter>> getRouterByName(Factory f, String routerName) {
        routerName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, routerName);
        Optional router = Optional.absent();
        ImmutableList suffixes = ImmutableList.of((Object)"ResourceRouter", (Object)"", (Object)"Resource", (Object)"Router");
        for (int i = 0; i < suffixes.size() && !router.isPresent(); ++i) {
            router = f.queryByName(Name.of(RestxRouter.class, (String)(routerName + (String)suffixes.get(i)))).optional().findOne();
        }
        return router;
    }

    private List<ResourceDescription> buildApis(NamedComponent<RestxRouter> router) {
        return this.fillRelatedOperations(router.getName().getName(), this.describeAllRoutes((RestxRouter)router.getComponent()));
    }

    private List<ResourceDescription> fillRelatedOperations(String name, List<ResourceDescription> apis) {
        Multimap<String, OperationReference> operationsByType = this.getOperationReferencesByType();
        Multimap<String, OperationReference> operationsByPath = this.getOperationReferencesByPath();
        String routerApiPath = ApiDocsIndexRoute.getRouterApiPath(name);
        for (ResourceDescription api : apis) {
            for (OperationDescription operation : api.operations) {
                Optional bodyParameter;
                LinkedHashSet<OperationReference> related = new LinkedHashSet<OperationReference>(operation.relatedOperations);
                if (!"string".equals(this.getTargetType(operation.responseClass))) {
                    related.addAll(operationsByType.get((Object)this.getTargetType(operation.responseClass)));
                }
                if ((bodyParameter = operation.findBodyParameter()).isPresent() && !"string".equals(((OperationParameterDescription)bodyParameter.get()).dataType)) {
                    related.addAll(operationsByType.get((Object)this.getTargetType(((OperationParameterDescription)bodyParameter.get()).dataType)));
                }
                for (OperationReference operationReference : operationsByPath.get((Object)api.path)) {
                    related.add(operationReference);
                }
                Iterator iterator = related.iterator();
                while (iterator.hasNext()) {
                    OperationReference operationReference;
                    operationReference = (OperationReference)iterator.next();
                    if (!routerApiPath.equals(operationReference.apiDocName) || !api.path.equals(operationReference.path) || !operation.httpMethod.equals(operationReference.httpMethod)) continue;
                    iterator.remove();
                    break;
                }
                operation.relatedOperations = new ArrayList(related);
            }
        }
        return apis;
    }

    private Multimap<String, OperationReference> getOperationReferencesByType() {
        ArrayListMultimap operationsByType = ArrayListMultimap.create();
        Set routers = this.factory.queryByClass(RestxRouter.class).find();
        for (NamedComponent r : routers) {
            String routerApiPath = ApiDocsIndexRoute.getRouterApiPath(r.getName().getName());
            for (ResourceDescription resourceDescription : this.describeAllRoutes((RestxRouter)r.getComponent())) {
                for (OperationDescription operation : resourceDescription.operations) {
                    OperationReference ref = this.buildReferenceFor(routerApiPath, resourceDescription.path, operation);
                    this.addIfRelevant((Multimap<String, OperationReference>)operationsByType, ref, operation.responseClass);
                    Optional bodyParameter = operation.findBodyParameter();
                    if (!bodyParameter.isPresent()) continue;
                    this.addIfRelevant((Multimap<String, OperationReference>)operationsByType, ref, ((OperationParameterDescription)bodyParameter.get()).dataType);
                }
            }
        }
        return operationsByType;
    }

    private Multimap<String, OperationReference> getOperationReferencesByPath() {
        ArrayListMultimap operationsByPath = ArrayListMultimap.create();
        Set routers = this.factory.queryByClass(RestxRouter.class).find();
        for (NamedComponent r : routers) {
            String routerApiPath = ApiDocsIndexRoute.getRouterApiPath(r.getName().getName());
            for (ResourceDescription resourceDescription : this.describeAllRoutes((RestxRouter)r.getComponent())) {
                for (OperationDescription operation : resourceDescription.operations) {
                    OperationReference ref = this.buildReferenceFor(routerApiPath, resourceDescription.path, operation);
                    operationsByPath.put((Object)resourceDescription.path, (Object)ref);
                }
            }
        }
        return operationsByPath;
    }

    private void addIfRelevant(Multimap<String, OperationReference> operationsByType, OperationReference ref, String dataType) {
        String targetType = this.getTargetType(dataType);
        if (!targetType.equals("void") && !targetType.equals("Status")) {
            operationsByType.put((Object)targetType, (Object)ref);
        }
    }

    private String getTargetType(String dataType) {
        return dataType == null ? "void" : dataType.replaceAll("LIST\\[(.+)\\]", "$1");
    }

    private OperationReference buildReferenceFor(String routerApiPath, String path, OperationDescription operation) {
        OperationReference ref = new OperationReference();
        ref.apiDocName = routerApiPath;
        ref.path = path;
        ref.httpMethod = operation.httpMethod;
        ref.responseClass = operation.responseClass;
        Optional bodyParameter = operation.findBodyParameter();
        ref.requestClass = bodyParameter.isPresent() ? ((OperationParameterDescription)bodyParameter.get()).dataType : "void";
        return ref;
    }

    private List<ResourceDescription> describeAllRoutes(RestxRouter component) {
        ImmutableList routes = component.getRoutes();
        ArrayList apis = Lists.newArrayList();
        for (RestxRoute route : routes) {
            if (!(route instanceof DescribableRoute)) continue;
            DescribableRoute describableRoute = (DescribableRoute)route;
            apis.addAll(describableRoute.describe());
        }
        return apis;
    }
}

