/*
 * Decompiled with CFR 0.152.
 */
package restx.apidocs;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.validation.Validator;
import java.io.IOException;
import java.lang.reflect.Type;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.annotations.PUT;
import restx.apidocs.SpecsResource;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;
import restx.specs.RestxSpec;
import restx.specs.ThenHttpResponse;
import restx.types.TypeReference;
import restx.types.Types;
import restx.validation.Validations;

@Component(priority=0)
public class SpecsResourceRouter
extends RestxRouter {
    public SpecsResourceRouter(final SpecsResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, final Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "SpecsResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, Iterable<String>>("restx-admin#SpecsResource#findSpecsForOperation", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/specs"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"httpMethod"), ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"path")}){

            protected Optional<Iterable<String>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.findSpecsForOperation((String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "httpMethod", request, match, EndpointParameterKind.QUERY)), (Object)"QUERY param <httpMethod> is required")), (Class[])new Class[0]), (String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "path", request, match, EndpointParameterKind.QUERY)), (Object)"QUERY param <path> is required")), (Class[])new Class[0])));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription httpMethod = new OperationParameterDescription();
                httpMethod.name = "httpMethod";
                httpMethod.paramType = OperationParameterDescription.ParamType.query;
                httpMethod.dataType = "string";
                httpMethod.schemaKey = "";
                httpMethod.required = true;
                operation.parameters.add(httpMethod);
                OperationParameterDescription path = new OperationParameterDescription();
                path.name = "path";
                path.paramType = OperationParameterDescription.ParamType.query;
                path.dataType = "string";
                path.schemaKey = "";
                path.required = true;
                operation.parameters.add(path);
                operation.responseClass = "LIST[string]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "";
                operation.outEntityType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{String.class});
                operation.sourceLocation = "restx.apidocs.SpecsResource#findSpecsForOperation(java.lang.String,java.lang.String)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/specs";
                    }
                }).build();
            }
        }, new StdEntityRoute<Void, RestxSpec>("restx-admin#SpecsResource#getSpecById", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(RestxSpec.class, Optional.absent()), Endpoint.of((String)"GET", (String)"/@/specs/{id}"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"id")}){

            protected Optional<RestxSpec> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return resource.getSpecById((String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "id", request, match, EndpointParameterKind.PATH)), (Object)"PATH param <id> is required")), (Class[])new Class[0]));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription id = new OperationParameterDescription();
                id.name = "id";
                id.paramType = OperationParameterDescription.ParamType.path;
                id.dataType = "string";
                id.schemaKey = "";
                id.required = true;
                operation.parameters.add(id);
                operation.responseClass = "RestxSpec";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.specs.RestxSpec";
                operation.outEntityType = RestxSpec.class;
                operation.sourceLocation = "restx.apidocs.SpecsResource#getSpecById(java.lang.String)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/specs/{id}";
                    }
                }).build();
            }
        }, new StdEntityRoute<ThenHttpResponse, ThenHttpResponse>("restx-admin#SpecsResource#updateSpecThenHttp", readerRegistry.build(ThenHttpResponse.class, Optional.absent()), writerRegistry.build(ThenHttpResponse.class, Optional.absent()), Endpoint.of((String)"PUT", (String)"/@/specs/{id}/wts/{wtsIndex}/then"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[]{ParamDef.of((TypeReference)new TypeReference<String>(){}, (String)"id"), ParamDef.of(Integer.TYPE, (String)"wtsIndex")}){

            protected Optional<ThenHttpResponse> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, ThenHttpResponse body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return resource.updateSpecThenHttp((String)Validations.checkValid((Optional)validator, (Object)((String)Preconditions.checkNotNull((Object)((String)this.mapQueryObjectFromRequest(String.class, "id", request, match, EndpointParameterKind.PATH)), (Object)"PATH param <id> is required")), (Class[])new Class[0]), (Integer)Validations.checkValid((Optional)validator, (Object)((Integer)Preconditions.checkNotNull((Object)((Integer)this.mapQueryObjectFromRequest(Integer.TYPE, "wtsIndex", request, match, EndpointParameterKind.PATH)), (Object)"PATH param <wtsIndex> is required")), (Class[])new Class[0]), (ThenHttpResponse)Validations.checkValid((Optional)validator, (Object)((ThenHttpResponse)Preconditions.checkNotNull((Object)body, (Object)"body param <response> is required")), (Class[])new Class[0]));
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription id = new OperationParameterDescription();
                id.name = "id";
                id.paramType = OperationParameterDescription.ParamType.path;
                id.dataType = "string";
                id.schemaKey = "";
                id.required = true;
                operation.parameters.add(id);
                OperationParameterDescription wtsIndex = new OperationParameterDescription();
                wtsIndex.name = "wtsIndex";
                wtsIndex.paramType = OperationParameterDescription.ParamType.path;
                wtsIndex.dataType = "int";
                wtsIndex.schemaKey = "int";
                wtsIndex.required = true;
                operation.parameters.add(wtsIndex);
                OperationParameterDescription response = new OperationParameterDescription();
                response.name = "response";
                response.paramType = OperationParameterDescription.ParamType.body;
                response.dataType = "ThenHttpResponse";
                response.schemaKey = "restx.specs.ThenHttpResponse";
                response.required = true;
                operation.parameters.add(response);
                operation.responseClass = "ThenHttpResponse";
                operation.inEntitySchemaKey = "restx.specs.ThenHttpResponse";
                operation.inEntityType = ThenHttpResponse.class;
                operation.outEntitySchemaKey = "restx.specs.ThenHttpResponse";
                operation.outEntityType = ThenHttpResponse.class;
                operation.sourceLocation = "restx.apidocs.SpecsResource#updateSpecThenHttp(java.lang.String,int,restx.specs.ThenHttpResponse)";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new PUT(){

                    public Class<PUT> annotationType() {
                        return PUT.class;
                    }

                    public String value() {
                        return "/@/specs/{id}/wts/{wtsIndex}/then";
                    }
                }).build();
            }
        }});
    }
}

