/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import restx.Status;
import restx.WebException;
import restx.annotations.DELETE;
import restx.annotations.GET;
import restx.annotations.POST;
import restx.annotations.RestxResource;
import restx.common.UUIDGenerator;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.security.BasicPrincipalAuthenticator;
import restx.security.PermitAll;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;
import restx.security.Session;

@Component
@RestxResource(priority=10000)
public class SessionResource {
    private final BasicPrincipalAuthenticator authenticator;
    private final UUIDGenerator uuidGenerator;

    public SessionResource(BasicPrincipalAuthenticator authenticator, UUIDGenerator uuidGenerator) {
        this.authenticator = authenticator;
        this.uuidGenerator = uuidGenerator;
    }

    @PermitAll
    @POST(value="/sessions")
    public Session authenticate(Map session) {
        String passwordHash;
        RestxSession.current().clearPrincipal();
        RestxSession.current().define(String.class, "sessionKey", null);
        Map<String, ?> principal = this.getPrincipal(session);
        if (principal == null) {
            throw new WebException(HttpStatus.UNAUTHORIZED);
        }
        String name = (String)principal.get("name");
        Optional<? extends RestxPrincipal> principalOptional = this.authenticator.authenticate(name, passwordHash = (String)principal.get("passwordHash"), ImmutableMap.copyOf(principal));
        if (principalOptional.isPresent()) {
            String sessionKey = this.uuidGenerator.doGenerate();
            RestxSession.current().authenticateAs((RestxPrincipal)principalOptional.get());
            RestxSession.current().define(String.class, "sessionKey", sessionKey);
            return new Session(sessionKey, (RestxPrincipal)principalOptional.get());
        }
        throw new WebException(HttpStatus.UNAUTHORIZED);
    }

    protected Map<String, ?> getPrincipal(Map session) {
        return (Map)session.get("principal");
    }

    @GET(value="/sessions/current")
    public Session currentSession() {
        String sessionKey = (String)RestxSession.current().get(String.class, "sessionKey").get();
        RestxPrincipal principal = (RestxPrincipal)RestxSession.current().getPrincipal().get();
        return new Session(sessionKey, principal);
    }

    @PermitAll
    @DELETE(value="/sessions/{sessionKey}")
    public Status logout(String sessionKey) {
        RestxSession.current().clearPrincipal();
        RestxSession.current().define(String.class, "sessionKey", null);
        return Status.of((String)"logout");
    }
}

