/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.Status;
import restx.StdRestxRequestMatcher;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.description.OperationParameterDescription;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.security.Permissions;
import restx.security.RestxSecurityManager;
import restx.security.Session;
import restx.security.SessionResource;
import restx.validation.Validations;

@Component(priority=10000)
public class SessionResourceRouter
extends RestxRouter {
    public SessionResourceRouter(final SessionResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, final Validator validator, final RestxSecurityManager securityManager) {
        super("default", "SessionResourceRouter", new RestxRoute[]{new StdEntityRoute<Map, Session>("default#SessionResource#authenticate", readerRegistry.build(Map.class, Optional.absent()), writerRegistry.build(Session.class, Optional.absent()), (RestxRequestMatcher)new StdRestxRequestMatcher("POST", "/sessions"), HttpStatus.OK, RestxLogLevel.DEFAULT){

            protected Optional<Session> doRoute(RestxRequest request, RestxRequestMatch match, Map body) throws IOException {
                securityManager.check(request, Permissions.open());
                return Optional.of((Object)resource.authenticate((Map)Validations.checkValid((Validator)validator, (Object)body)));
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription session = new OperationParameterDescription();
                session.name = "session";
                session.paramType = OperationParameterDescription.ParamType.body;
                session.dataType = "Map";
                session.schemaKey = "";
                session.required = true;
                operation.parameters.add(session);
                operation.responseClass = "Session";
                operation.inEntitySchemaKey = "";
                operation.outEntitySchemaKey = "restx.security.Session";
                operation.sourceLocation = "restx.security.SessionResource#authenticate(java.util.Map)";
            }
        }, new StdEntityRoute<Void, Session>("default#SessionResource#currentSession", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(Session.class, Optional.absent()), (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/sessions/current"), HttpStatus.OK, RestxLogLevel.DEFAULT){

            protected Optional<Session> doRoute(RestxRequest request, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, Permissions.isAuthenticated());
                return Optional.of((Object)resource.currentSession());
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "Session";
                operation.inEntitySchemaKey = "";
                operation.outEntitySchemaKey = "restx.security.Session";
                operation.sourceLocation = "restx.security.SessionResource#currentSession()";
            }
        }, new StdEntityRoute<Void, Status>("default#SessionResource#logout", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build(Status.class, Optional.absent()), (RestxRequestMatcher)new StdRestxRequestMatcher("DELETE", "/sessions/{sessionKey}"), HttpStatus.OK, RestxLogLevel.DEFAULT){

            protected Optional<Status> doRoute(RestxRequest request, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, Permissions.open());
                return Optional.of((Object)resource.logout(match.getPathParam("sessionKey")));
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription sessionKey = new OperationParameterDescription();
                sessionKey.name = "sessionKey";
                sessionKey.paramType = OperationParameterDescription.ParamType.path;
                sessionKey.dataType = "string";
                sessionKey.schemaKey = "";
                sessionKey.required = true;
                operation.parameters.add(sessionKey);
                operation.responseClass = "Status";
                operation.inEntitySchemaKey = "";
                operation.outEntitySchemaKey = "restx.Status";
                operation.sourceLocation = "restx.security.SessionResource#logout(java.lang.String)";
            }
        }});
    }
}

