/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.collect.ImmutableSet;
import javax.validation.Validator;
import restx.converters.MainStringConverter;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.security.RestxSecurityManager;
import restx.security.SessionResource;
import restx.security.SessionResourceRouter;

@Machine
public class SessionResourceRouterFactoryMachine
extends SingleNameFactoryMachine<SessionResourceRouter> {
    public static final Name<SessionResourceRouter> NAME = Name.of(SessionResourceRouter.class, (String)"SessionResourceRouter");

    public SessionResourceRouterFactoryMachine() {
        super(10000, (MachineEngine)new StdMachineEngine<SessionResourceRouter>(NAME, BoundlessComponentBox.FACTORY){
            private final Factory.Query<SessionResource> resource = Factory.Query.byClass(SessionResource.class).mandatory();
            private final Factory.Query<EntityRequestBodyReaderRegistry> readerRegistry = Factory.Query.byClass(EntityRequestBodyReaderRegistry.class).mandatory();
            private final Factory.Query<EntityResponseWriterRegistry> writerRegistry = Factory.Query.byClass(EntityResponseWriterRegistry.class).mandatory();
            private final Factory.Query<MainStringConverter> converter = Factory.Query.byClass(MainStringConverter.class).mandatory();
            private final Factory.Query<Validator> validator = Factory.Query.byClass(Validator.class).mandatory();
            private final Factory.Query<RestxSecurityManager> securityManager = Factory.Query.byClass(RestxSecurityManager.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.resource, this.readerRegistry, this.writerRegistry, this.converter, this.validator, this.securityManager, (Object[])new Factory.Query[0]));
            }

            protected SessionResourceRouter doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new SessionResourceRouter((SessionResource)((NamedComponent)satisfiedBOM.getOne(this.resource).get()).getComponent(), (EntityRequestBodyReaderRegistry)((NamedComponent)satisfiedBOM.getOne(this.readerRegistry).get()).getComponent(), (EntityResponseWriterRegistry)((NamedComponent)satisfiedBOM.getOne(this.writerRegistry).get()).getComponent(), (MainStringConverter)((NamedComponent)satisfiedBOM.getOne(this.converter).get()).getComponent(), (Validator)((NamedComponent)satisfiedBOM.getOne(this.validator).get()).getComponent(), (RestxSecurityManager)((NamedComponent)satisfiedBOM.getOne(this.securityManager).get()).getComponent());
            }
        });
    }
}

