package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.security.BasicSecurityModule;


@Machine
public class BasicSecurityModuleFactoryMachine extends DefaultFactoryMachine {
    private static final BasicSecurityModule module = new BasicSecurityModule();

    public BasicSecurityModuleFactoryMachine() {
        super(10000, new MachineEngine[] {
            new StdMachineEngine<restx.security.RestxSession.Definition.Entry>(Name.of(restx.security.RestxSession.Definition.Entry.class, "principal"), 10000, BoundlessComponentBox.FACTORY) {
        private final Factory.Query<restx.security.BasicPrincipalAuthenticator> authenticator = Factory.Query.byClass(restx.security.BasicPrincipalAuthenticator.class).mandatory();
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        authenticator
                    ));
                }

                @Override
                public restx.security.RestxSession.Definition.Entry doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.principalSessionEntry(
	        satisfiedBOM.getOne(authenticator).get().getComponent()
	                    );
                }
            },
            new StdMachineEngine<restx.security.RestxSession.Definition.Entry>(Name.of(restx.security.RestxSession.Definition.Entry.class, "sessionKey"), 10000, BoundlessComponentBox.FACTORY) {
        
                @Override
                public BillOfMaterials getBillOfMaterial() {
                    return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
        
                    ));
                }

                @Override
                public restx.security.RestxSession.Definition.Entry doNewComponent(SatisfiedBOM satisfiedBOM) {
	                    return module.sessionKeySessionEntry(
	        
	                    );
                }
            },

        });
    }
}
