package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.security.HttpAuthenticationFilter;

@Machine
public class HttpAuthenticationFilterFactoryMachine extends SingleNameFactoryMachine<restx.security.HttpAuthenticationFilter> {
    public static final Name<restx.security.HttpAuthenticationFilter> NAME = Name.of(restx.security.HttpAuthenticationFilter.class, "HttpAuthenticationFilter");

    public HttpAuthenticationFilterFactoryMachine() {
        super(-190, new StdMachineEngine<restx.security.HttpAuthenticationFilter>(NAME, -190, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler> basicHandler = Factory.Query.byClass(restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
basicHandler
                ));
            }

            @Override
            protected restx.security.HttpAuthenticationFilter doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new HttpAuthenticationFilter(
satisfiedBOM.getOne(basicHandler).get().getComponent()
                );
            }
        });
    }

}
