package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler;

@Machine
public class HttpBasicAuthHandlerFactoryMachine extends SingleNameFactoryMachine<restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler> {
    public static final Name<restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler> NAME = Name.of(restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler.class, "HttpBasicAuthHandler");

    public HttpBasicAuthHandlerFactoryMachine() {
        super(0, new StdMachineEngine<restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.security.BasicPrincipalAuthenticator> authenticator = Factory.Query.byClass(restx.security.BasicPrincipalAuthenticator.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
authenticator
                ));
            }

            @Override
            protected restx.security.HttpAuthenticationFilter.HttpBasicAuthHandler doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new HttpBasicAuthHandler(
satisfiedBOM.getOne(authenticator).get().getComponent()
                );
            }
        });
    }

}
