package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.security.SecuritySettingsConfig;

@Machine
public class SecuritySettingsConfigFactoryMachine extends SingleNameFactoryMachine<restx.security.SecuritySettingsConfig> {
    public static final Name<restx.security.SecuritySettingsConfig> NAME = Name.of(restx.security.SecuritySettingsConfig.class, "SecuritySettingsConfig");

    public SecuritySettingsConfigFactoryMachine() {
        super(0, new StdMachineEngine<restx.security.SecuritySettingsConfig>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.common.RestxConfig> config = Factory.Query.byClass(restx.common.RestxConfig.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
config
                ));
            }

            @Override
            protected restx.security.SecuritySettingsConfig doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new SecuritySettingsConfig(
satisfiedBOM.getOne(config).get().getComponent()
                );
            }
        });
    }

}
