package restx.security;

import restx.common.ConfigElement;
import restx.config.ConfigSupplier;
import restx.common.RestxConfig;
import restx.common.StdRestxConfig;
import restx.factory.Component;

import static java.util.Arrays.asList;

@Component(priority = 1000)
public class SecuritySettingsProvider implements ConfigSupplier {
    @Override
    public RestxConfig get() {
        return StdRestxConfig.of(asList(new ConfigElement[] {
                ConfigElement.of("restx.security.SecuritySettings", "the duration in days during which authentication should be remembered when using rememberme feature with StdBasicPrincipalAuthenticator", "restx.security.rememberMe.duration", "30"),
        }
        ));
    }
}
