package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.security.SessionInvalider;

@Machine
public class SessionInvaliderFactoryMachine extends SingleNameFactoryMachine<restx.security.SessionInvalider> {
    public static final Name<restx.security.SessionInvalider> NAME = Name.of(restx.security.SessionInvalider.class, "SessionInvalider");

    public SessionInvaliderFactoryMachine() {
        super(0, new StdMachineEngine<restx.security.SessionInvalider>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.security.RestxSession.Definition> restxSessionDefinition = Factory.Query.byClass(restx.security.RestxSession.Definition.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
restxSessionDefinition
                ));
            }

            @Override
            protected restx.security.SessionInvalider doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new SessionInvalider(
satisfiedBOM.getOne(restxSessionDefinition).get().getComponent()
                );
            }
        });
    }

}
