package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.security.SessionResource;

@Machine
public class SessionResourceFactoryMachine extends SingleNameFactoryMachine<restx.security.SessionResource> {
    public static final Name<restx.security.SessionResource> NAME = Name.of(restx.security.SessionResource.class, "SessionResource");

    public SessionResourceFactoryMachine() {
        super(0, new StdMachineEngine<restx.security.SessionResource>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.security.BasicPrincipalAuthenticator> authenticator = Factory.Query.byClass(restx.security.BasicPrincipalAuthenticator.class).mandatory();
private final Factory.Query<restx.common.UUIDGenerator> uuidGenerator = Factory.Query.byClass(restx.common.UUIDGenerator.class).mandatory();
private final Factory.Query<restx.security.SessionInvalider> sessionInvalider = Factory.Query.byClass(restx.security.SessionInvalider.class).mandatory();
private final Factory.Query<restx.security.CurrentSessionResolver> currentSessionResolver = Factory.Query.byClass(restx.security.CurrentSessionResolver.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
authenticator,
uuidGenerator,
sessionInvalider,
currentSessionResolver
                ));
            }

            @Override
            protected restx.security.SessionResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new SessionResource(
satisfiedBOM.getOne(authenticator).get().getComponent(),
satisfiedBOM.getOne(uuidGenerator).get().getComponent(),
satisfiedBOM.getOne(sessionInvalider).get().getComponent(),
satisfiedBOM.getOne(currentSessionResolver).get().getComponent()
                );
            }
        });
    }

}
