package restx.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import static com.google.common.base.Preconditions.checkNotNull;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableList;
import restx.common.Types;
import restx.common.TypeReference;
import restx.*;
import restx.entity.*;
import restx.http.*;
import restx.endpoint.*;
import restx.exceptions.WrappedCheckedException;
import restx.factory.*;
import restx.security.*;
import restx.security.PermissionFactory;
import restx.description.*;
import restx.converters.MainStringConverter;
import static restx.common.MorePreconditions.checkPresent;

import javax.validation.Validator;
import static restx.validation.Validations.checkValid;

import java.io.IOException;
import java.io.PrintWriter;

import java.util.Arrays;


@Component(priority = 10000)

public class SessionResourceRouter extends RestxRouter {

    public SessionResourceRouter(
                    final SessionResource resource,
                    final EntityRequestBodyReaderRegistry readerRegistry,
                    final EntityResponseWriterRegistry writerRegistry,
                    final MainStringConverter converter,
                    final PermissionFactory pf,
                    final Optional<Validator> validator,
                    final RestxSecurityManager securityManager,
                    final EndpointParameterMapperRegistry paramMapperRegistry) {
        super(
            "default", "SessionResourceRouter", new RestxRoute[] {
        new StdEntityRoute<java.util.Map, restx.security.Session>("default#SessionResource#authenticate",
                readerRegistry.<java.util.Map>build(java.util.Map.class, Optional.<String>absent()),
                writerRegistry.<restx.security.Session>build(restx.security.Session.class, Optional.<String>absent()),
                Endpoint.of("POST", "/sessions"),
                HttpStatus.OK, RestxLogLevel.DEFAULT, pf,
                paramMapperRegistry, new ParamDef[]{

                }) {
            @Override
            protected Optional<restx.security.Session> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, java.util.Map body) throws IOException {
                securityManager.check(request, match, open());
                try {
                    return Optional.of(resource.authenticate(
                        /* [BODY] session */ checkValid(validator, checkNotNull(body, "body param <session> is required"))
                    ));
                } catch(RuntimeException e) { throw e; }
                  catch(Exception e) { throw new WrappedCheckedException(e); }
            }

            @Override
            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription session = new OperationParameterDescription();
                session.name = "session";
                session.paramType = OperationParameterDescription.ParamType.body;
                session.dataType = "MAP";
                session.schemaKey = "";
                session.required = true;
                operation.parameters.add(session);


                operation.responseClass = "Session";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = java.util.Map.class;
                operation.outEntitySchemaKey = "restx.security.Session";
                operation.outEntityType = restx.security.Session.class;
                operation.sourceLocation = "restx.security.SessionResource#authenticate(java.util.Map)";
                operation.annotations = ImmutableList.<java.lang.annotation.Annotation>builder()
                    .add(new restx.security.PermitAll() {
                        public Class<restx.security.PermitAll> annotationType() { return restx.security.PermitAll.class; }
                    })
                    .add(new restx.annotations.POST() {
                        public Class<restx.annotations.POST> annotationType() { return restx.annotations.POST.class; }
                        public java.lang.String value() { return "/sessions"; }
                    })
                    .build();
            }
        },
        new StdEntityRoute<Void, restx.security.Session>("default#SessionResource#currentSession",
                readerRegistry.<Void>build(Void.class, Optional.<String>absent()),
                writerRegistry.<restx.security.Session>build(restx.security.Session.class, Optional.<String>absent()),
                Endpoint.of("GET", "/sessions/current"),
                HttpStatus.OK, RestxLogLevel.DEFAULT, pf,
                paramMapperRegistry, new ParamDef[]{

                }) {
            @Override
            protected Optional<restx.security.Session> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, isAuthenticated());
                try {
                    return resource.currentSession(
                        
                    );
                } catch(RuntimeException e) { throw e; }
                  catch(Exception e) { throw new WrappedCheckedException(e); }
            }

            @Override
            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);


                operation.responseClass = "Session";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.security.Session";
                operation.outEntityType = restx.security.Session.class;
                operation.sourceLocation = "restx.security.SessionResource#currentSession()";
                operation.annotations = ImmutableList.<java.lang.annotation.Annotation>builder()
                    .add(new restx.annotations.GET() {
                        public Class<restx.annotations.GET> annotationType() { return restx.annotations.GET.class; }
                        public java.lang.String value() { return "/sessions/current"; }
                    })
                    .build();
            }
        },
        new StdEntityRoute<Void, restx.Status>("default#SessionResource#logout",
                readerRegistry.<Void>build(Void.class, Optional.<String>absent()),
                writerRegistry.<restx.Status>build(restx.Status.class, Optional.<String>absent()),
                Endpoint.of("DELETE", "/sessions/{sessionKey}"),
                HttpStatus.OK, RestxLogLevel.DEFAULT, pf,
                paramMapperRegistry, new ParamDef[]{
                    ParamDef.of(new TypeReference<java.lang.String>(){}, "sessionKey")
                }) {
            @Override
            protected Optional<restx.Status> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, open());
                try {
                    return Optional.of(resource.logout(
                        /* [PATH] sessionKey */ checkValid(validator, checkNotNull(mapQueryObjectFromRequest(java.lang.String.class, "sessionKey", request, match, EndpointParameterKind.PATH), "PATH param <sessionKey> is required"))
                    ));
                } catch(RuntimeException e) { throw e; }
                  catch(Exception e) { throw new WrappedCheckedException(e); }
            }

            @Override
            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                OperationParameterDescription sessionKey = new OperationParameterDescription();
                sessionKey.name = "sessionKey";
                sessionKey.paramType = OperationParameterDescription.ParamType.path;
                sessionKey.dataType = "string";
                sessionKey.schemaKey = "";
                sessionKey.required = true;
                operation.parameters.add(sessionKey);


                operation.responseClass = "Status";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.Status";
                operation.outEntityType = restx.Status.class;
                operation.sourceLocation = "restx.security.SessionResource#logout(java.lang.String)";
                operation.annotations = ImmutableList.<java.lang.annotation.Annotation>builder()
                    .add(new restx.security.PermitAll() {
                        public Class<restx.security.PermitAll> annotationType() { return restx.security.PermitAll.class; }
                    })
                    .add(new restx.annotations.DELETE() {
                        public Class<restx.annotations.DELETE> annotationType() { return restx.annotations.DELETE.class; }
                        public java.lang.String value() { return "/sessions/{sessionKey}"; }
                    })
                    .build();
            }
        },
        });
    }

}
