/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.UsageLoggers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Properties;

public class BaseLogger<T extends BaseLogger> {
    protected final String agent;
    protected boolean enabled;
    protected final List<String> queue;
    protected String url;
    protected final String version;

    public BaseLogger(String agent) {
        this(agent, true);
    }

    public BaseLogger(String agent, boolean enabled) {
        this(agent, UsageLoggers.urlByDefault(), enabled);
    }

    public BaseLogger(String agent, String url) {
        this(agent, url, true);
    }

    public BaseLogger(String agent, String url, boolean enabled) {
        this.agent = agent;
        this.version = BaseLogger.version_lookup();
        this.queue = null;
        this.enabled = enabled;
        if (url == null) {
            this.url = UsageLoggers.urlByDefault();
            if (this.url == null) {
                this.enabled = false;
            }
        } else {
            this.url = url.equals("DEMO") ? UsageLoggers.urlForDemo() : url;
        }
        if (this.url != null) {
            try {
                if (!new URL(this.url).getProtocol().contains("http")) {
                    throw new RuntimeException();
                }
            }
            catch (Exception e) {
                this.url = null;
                this.enabled = false;
            }
        }
    }

    public BaseLogger(String agent, List<String> queue) {
        this(agent, queue, true);
    }

    public BaseLogger(String agent, List<String> queue, boolean enabled) {
        this.agent = agent;
        this.version = BaseLogger.version_lookup();
        this.enabled = enabled;
        this.queue = queue;
        this.url = null;
    }

    public T disable() {
        this.enabled = false;
        return (T)this;
    }

    public T enable() {
        if (this.queue != null || this.url != null) {
            this.enabled = true;
        }
        return (T)this;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isEnabled() {
        return this.enabled && UsageLoggers.isEnabled();
    }

    public boolean submit(String json) {
        if (!this.isEnabled()) {
            return true;
        }
        if (this.queue != null) {
            this.queue.add(json);
            return true;
        }
        try {
            URL url_parsed = new URL(this.url);
            HttpURLConnection url_connection = (HttpURLConnection)url_parsed.openConnection();
            url_connection.setConnectTimeout(5000);
            url_connection.setReadTimeout(1000);
            url_connection.setRequestMethod("POST");
            url_connection.setDoOutput(true);
            try (OutputStream os = url_connection.getOutputStream();){
                os.write(json.getBytes());
                os.flush();
            }
            return url_connection.getResponseCode() == 204;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String version_lookup() {
        try (InputStream is = BaseLogger.class.getResourceAsStream("/version.properties");){
            Properties p = new Properties();
            p.load(is);
            String string = p.getProperty("version", null);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Version could not be loaded: " + e.getMessage());
        }
    }
}

