/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.BaseLogger;
import io.resurface.Json;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpLogger
extends BaseLogger<HttpLogger> {
    public static final String AGENT = "HttpLogger.java";

    public HttpLogger() {
        super(AGENT);
    }

    public HttpLogger(boolean enabled) {
        super(AGENT, enabled);
    }

    public HttpLogger(String url) {
        super(AGENT, url);
    }

    public HttpLogger(String url, boolean enabled) {
        super(AGENT, url, enabled);
    }

    public HttpLogger(List<String> queue) {
        super(AGENT, queue);
    }

    public HttpLogger(List<String> queue, boolean enabled) {
        super(AGENT, queue, enabled);
    }

    public String format(HttpServletRequest request, String request_body, HttpServletResponse response, String response_body) {
        return this.format(request, request_body, response, response_body, System.currentTimeMillis());
    }

    public String format(HttpServletRequest request, String request_body, HttpServletResponse response, String response_body, long now) {
        ArrayList<String[]> message = new ArrayList<String[]>();
        message.add(new String[]{"request_method", request.getMethod()});
        message.add(new String[]{"request_url", this.formatURL(request)});
        message.add(new String[]{"response_code", String.valueOf(response.getStatus())});
        this.appendRequestHeaders(message, request);
        this.appendResponseHeaders(message, response);
        if (request_body != null) {
            message.add(new String[]{"request_body", request_body});
        }
        if (response_body != null) {
            message.add(new String[]{"response_body", response_body});
        }
        message.add(new String[]{"agent", this.agent});
        message.add(new String[]{"version", this.version});
        message.add(new String[]{"now", String.valueOf(now)});
        return Json.stringify(message);
    }

    public boolean log(HttpServletRequest request, String request_body, HttpServletResponse response, String response_body) {
        return !this.isEnabled() || this.submit(this.format(request, request_body, response, response_body));
    }

    protected void appendRequestHeaders(List<String[]> message, HttpServletRequest request) {
        Enumeration header_names = request.getHeaderNames();
        while (header_names.hasMoreElements()) {
            String name = (String)header_names.nextElement();
            Enumeration e = request.getHeaders(name);
            name = "request_header." + name.toLowerCase();
            while (e.hasMoreElements()) {
                message.add(new String[]{name, (String)e.nextElement()});
            }
        }
    }

    protected void appendResponseHeaders(List<String[]> message, HttpServletResponse response) {
        for (String name : response.getHeaderNames()) {
            Iterator i = response.getHeaders(name).iterator();
            name = "response_header." + name.toLowerCase();
            while (i.hasNext()) {
                message.add(new String[]{name, (String)i.next()});
            }
        }
    }

    protected String formatURL(HttpServletRequest request) {
        String queryString = request.getQueryString();
        StringBuffer url = request.getRequestURL();
        if (queryString != null) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }
}

