/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import java.util.List;

public class Json {
    public static StringBuilder append(StringBuilder json, CharSequence key, CharSequence value) {
        if (key != null && value != null) {
            json.append("\"").append(key.toString()).append("\",\"");
            Json.escape(json, value).append("\"");
        }
        return json;
    }

    public static StringBuilder escape(StringBuilder json, CharSequence value) {
        if (value == null) {
            return json;
        }
        int len = value.length();
        block9: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    json.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    json.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    json.append("\\b");
                    continue block9;
                }
                case '\f': {
                    json.append("\\f");
                    continue block9;
                }
                case '\n': {
                    json.append("\\n");
                    continue block9;
                }
                case '\r': {
                    json.append("\\r");
                    continue block9;
                }
                case '\t': {
                    json.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        json.append("\\u");
                        String ss = Integer.toHexString(ch);
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            json.append('0');
                        }
                        json.append(ss.toUpperCase());
                        continue block9;
                    }
                    json.append(ch);
                }
            }
        }
        return json;
    }

    public static String stringify(List<String[]> message) {
        StringBuilder json = new StringBuilder(1024);
        json.append('[');
        int idx = 0;
        for (String[] entry : message) {
            json.append(idx++ > 0 ? ",[" : Character.valueOf('['));
            Json.append(json, entry[0], entry[1]).append(']');
        }
        json.append(']');
        return json.toString();
    }
}

