/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.compiler.api.HdesCompiler;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HdesCompiler.Resource", generator="Immutables")
@Immutable
public final class ImmutableResource
implements HdesCompiler.Resource {
    private final String name;
    private final HdesCompiler.ResourceType type;
    private final String source;
    private final BodyNode ast;
    private final HdesCompiler.ResourceName accepts;
    private final HdesCompiler.ResourceName returns;
    private final HdesCompiler.ResourceName ends;
    private final ImmutableList<HdesCompiler.ResourceName> types;
    private final ImmutableList<HdesCompiler.ResourceDeclaration> declarations;

    private ImmutableResource(String name, HdesCompiler.ResourceType type, String source, BodyNode ast, HdesCompiler.ResourceName accepts, HdesCompiler.ResourceName returns, HdesCompiler.ResourceName ends, ImmutableList<HdesCompiler.ResourceName> types, ImmutableList<HdesCompiler.ResourceDeclaration> declarations) {
        this.name = name;
        this.type = type;
        this.source = source;
        this.ast = ast;
        this.accepts = accepts;
        this.returns = returns;
        this.ends = ends;
        this.types = types;
        this.declarations = declarations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HdesCompiler.ResourceType getType() {
        return this.type;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public BodyNode getAst() {
        return this.ast;
    }

    @Override
    public HdesCompiler.ResourceName getAccepts() {
        return this.accepts;
    }

    @Override
    public HdesCompiler.ResourceName getReturns() {
        return this.returns;
    }

    @Override
    public HdesCompiler.ResourceName getEnds() {
        return this.ends;
    }

    public ImmutableList<HdesCompiler.ResourceName> getTypes() {
        return this.types;
    }

    public ImmutableList<HdesCompiler.ResourceDeclaration> getDeclarations() {
        return this.declarations;
    }

    public final ImmutableResource withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableResource(newValue, this.type, this.source, this.ast, this.accepts, this.returns, this.ends, this.types, this.declarations);
    }

    public final ImmutableResource withType(HdesCompiler.ResourceType value) {
        if (this.type == value) {
            return this;
        }
        HdesCompiler.ResourceType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableResource(this.name, newValue, this.source, this.ast, this.accepts, this.returns, this.ends, this.types, this.declarations);
    }

    public final ImmutableResource withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableResource(this.name, this.type, newValue, this.ast, this.accepts, this.returns, this.ends, this.types, this.declarations);
    }

    public final ImmutableResource withAst(BodyNode value) {
        if (this.ast == value) {
            return this;
        }
        BodyNode newValue = Objects.requireNonNull(value, "ast");
        return new ImmutableResource(this.name, this.type, this.source, newValue, this.accepts, this.returns, this.ends, this.types, this.declarations);
    }

    public final ImmutableResource withAccepts(HdesCompiler.ResourceName value) {
        if (this.accepts == value) {
            return this;
        }
        HdesCompiler.ResourceName newValue = Objects.requireNonNull(value, "accepts");
        return new ImmutableResource(this.name, this.type, this.source, this.ast, newValue, this.returns, this.ends, this.types, this.declarations);
    }

    public final ImmutableResource withReturns(HdesCompiler.ResourceName value) {
        if (this.returns == value) {
            return this;
        }
        HdesCompiler.ResourceName newValue = Objects.requireNonNull(value, "returns");
        return new ImmutableResource(this.name, this.type, this.source, this.ast, this.accepts, newValue, this.ends, this.types, this.declarations);
    }

    public final ImmutableResource withEnds(HdesCompiler.ResourceName value) {
        if (this.ends == value) {
            return this;
        }
        HdesCompiler.ResourceName newValue = Objects.requireNonNull(value, "ends");
        return new ImmutableResource(this.name, this.type, this.source, this.ast, this.accepts, this.returns, newValue, this.types, this.declarations);
    }

    public final ImmutableResource withTypes(HdesCompiler.ResourceName ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableResource(this.name, this.type, this.source, this.ast, this.accepts, this.returns, this.ends, (ImmutableList<HdesCompiler.ResourceName>)newValue, this.declarations);
    }

    public final ImmutableResource withTypes(Iterable<? extends HdesCompiler.ResourceName> elements) {
        if (this.types == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableResource(this.name, this.type, this.source, this.ast, this.accepts, this.returns, this.ends, (ImmutableList<HdesCompiler.ResourceName>)newValue, this.declarations);
    }

    public final ImmutableResource withDeclarations(HdesCompiler.ResourceDeclaration ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableResource(this.name, this.type, this.source, this.ast, this.accepts, this.returns, this.ends, this.types, (ImmutableList<HdesCompiler.ResourceDeclaration>)newValue);
    }

    public final ImmutableResource withDeclarations(Iterable<? extends HdesCompiler.ResourceDeclaration> elements) {
        if (this.declarations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableResource(this.name, this.type, this.source, this.ast, this.accepts, this.returns, this.ends, this.types, (ImmutableList<HdesCompiler.ResourceDeclaration>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResource && this.equalTo((ImmutableResource)another);
    }

    private boolean equalTo(ImmutableResource another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && this.source.equals(another.source) && this.ast.equals(another.ast) && this.accepts.equals(another.accepts) && this.returns.equals(another.returns) && this.ends.equals(another.ends) && this.types.equals(another.types) && this.declarations.equals(another.declarations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.ast.hashCode();
        h += (h << 5) + this.accepts.hashCode();
        h += (h << 5) + this.returns.hashCode();
        h += (h << 5) + this.ends.hashCode();
        h += (h << 5) + this.types.hashCode();
        h += (h << 5) + this.declarations.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Resource").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("source", (Object)this.source).add("ast", (Object)this.ast).add("accepts", (Object)this.accepts).add("returns", (Object)this.returns).add("ends", (Object)this.ends).add("types", this.types).add("declarations", this.declarations).toString();
    }

    public static ImmutableResource copyOf(HdesCompiler.Resource instance) {
        if (instance instanceof ImmutableResource) {
            return (ImmutableResource)instance;
        }
        return ImmutableResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HdesCompiler.Resource", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_SOURCE = 4L;
        private static final long INIT_BIT_AST = 8L;
        private static final long INIT_BIT_ACCEPTS = 16L;
        private static final long INIT_BIT_RETURNS = 32L;
        private static final long INIT_BIT_ENDS = 64L;
        private long initBits = 127L;
        @Nullable
        private String name;
        @Nullable
        private HdesCompiler.ResourceType type;
        @Nullable
        private String source;
        @Nullable
        private BodyNode ast;
        @Nullable
        private HdesCompiler.ResourceName accepts;
        @Nullable
        private HdesCompiler.ResourceName returns;
        @Nullable
        private HdesCompiler.ResourceName ends;
        private ImmutableList.Builder<HdesCompiler.ResourceName> types = ImmutableList.builder();
        private ImmutableList.Builder<HdesCompiler.ResourceDeclaration> declarations = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HdesCompiler.Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.type(instance.getType());
            this.source(instance.getSource());
            this.ast(instance.getAst());
            this.accepts(instance.getAccepts());
            this.returns(instance.getReturns());
            this.ends(instance.getEnds());
            this.addAllTypes(instance.getTypes());
            this.addAllDeclarations(instance.getDeclarations());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(HdesCompiler.ResourceType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ast(BodyNode ast) {
            this.ast = Objects.requireNonNull(ast, "ast");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accepts(HdesCompiler.ResourceName accepts) {
            this.accepts = Objects.requireNonNull(accepts, "accepts");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returns(HdesCompiler.ResourceName returns) {
            this.returns = Objects.requireNonNull(returns, "returns");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ends(HdesCompiler.ResourceName ends) {
            this.ends = Objects.requireNonNull(ends, "ends");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTypes(HdesCompiler.ResourceName element) {
            this.types.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTypes(HdesCompiler.ResourceName ... elements) {
            this.types.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder types(Iterable<? extends HdesCompiler.ResourceName> elements) {
            this.types = ImmutableList.builder();
            return this.addAllTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTypes(Iterable<? extends HdesCompiler.ResourceName> elements) {
            this.types.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeclarations(HdesCompiler.ResourceDeclaration element) {
            this.declarations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeclarations(HdesCompiler.ResourceDeclaration ... elements) {
            this.declarations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder declarations(Iterable<? extends HdesCompiler.ResourceDeclaration> elements) {
            this.declarations = ImmutableList.builder();
            return this.addAllDeclarations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDeclarations(Iterable<? extends HdesCompiler.ResourceDeclaration> elements) {
            this.declarations.addAll(elements);
            return this;
        }

        public ImmutableResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResource(this.name, this.type, this.source, this.ast, this.accepts, this.returns, this.ends, (ImmutableList<HdesCompiler.ResourceName>)this.types.build(), (ImmutableList<HdesCompiler.ResourceDeclaration>)this.declarations.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ast");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("accepts");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("returns");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("ends");
            }
            return "Cannot build Resource, some of required attributes are not set " + attributes;
        }
    }
}

