/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.api;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.compiler.api.HdesCompiler;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HdesCompiler.ResourceDeclaration", generator="Immutables")
@Immutable
public final class ImmutableResourceDeclaration
implements HdesCompiler.ResourceDeclaration {
    private final HdesCompiler.ResourceName type;
    private final String value;
    private final boolean isExecutable;

    private ImmutableResourceDeclaration(HdesCompiler.ResourceName type, String value, boolean isExecutable) {
        this.type = type;
        this.value = value;
        this.isExecutable = isExecutable;
    }

    @Override
    public HdesCompiler.ResourceName getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isExecutable() {
        return this.isExecutable;
    }

    public final ImmutableResourceDeclaration withType(HdesCompiler.ResourceName value) {
        if (this.type == value) {
            return this;
        }
        HdesCompiler.ResourceName newValue = Objects.requireNonNull(value, "type");
        return new ImmutableResourceDeclaration(newValue, this.value, this.isExecutable);
    }

    public final ImmutableResourceDeclaration withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableResourceDeclaration(this.type, newValue, this.isExecutable);
    }

    public final ImmutableResourceDeclaration withIsExecutable(boolean value) {
        if (this.isExecutable == value) {
            return this;
        }
        return new ImmutableResourceDeclaration(this.type, this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResourceDeclaration && this.equalTo((ImmutableResourceDeclaration)another);
    }

    private boolean equalTo(ImmutableResourceDeclaration another) {
        return this.type.equals(another.type) && this.value.equals(another.value) && this.isExecutable == another.isExecutable;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isExecutable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ResourceDeclaration").omitNullValues().add("type", (Object)this.type).add("value", (Object)this.value).add("isExecutable", this.isExecutable).toString();
    }

    public static ImmutableResourceDeclaration copyOf(HdesCompiler.ResourceDeclaration instance) {
        if (instance instanceof ImmutableResourceDeclaration) {
            return (ImmutableResourceDeclaration)instance;
        }
        return ImmutableResourceDeclaration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HdesCompiler.ResourceDeclaration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_IS_EXECUTABLE = 4L;
        private long initBits = 7L;
        @Nullable
        private HdesCompiler.ResourceName type;
        @Nullable
        private String value;
        private boolean isExecutable;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HdesCompiler.ResourceDeclaration instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            this.value(instance.getValue());
            this.isExecutable(instance.isExecutable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(HdesCompiler.ResourceName type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isExecutable(boolean isExecutable) {
            this.isExecutable = isExecutable;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableResourceDeclaration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResourceDeclaration(this.type, this.value, this.isExecutable);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isExecutable");
            }
            return "Cannot build ResourceDeclaration, some of required attributes are not set " + attributes;
        }
    }
}

