/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.compiler.api.HdesCompiler;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HdesCompiler.ResourceName", generator="Immutables")
@Immutable
public final class ImmutableResourceName
implements HdesCompiler.ResourceName {
    private final String pkg;
    private final String name;

    private ImmutableResourceName(String pkg, String name) {
        this.pkg = pkg;
        this.name = name;
    }

    @Override
    public String getPkg() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final ImmutableResourceName withPkg(String value) {
        String newValue = Objects.requireNonNull(value, "pkg");
        if (this.pkg.equals(newValue)) {
            return this;
        }
        return new ImmutableResourceName(newValue, this.name);
    }

    public final ImmutableResourceName withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableResourceName(this.pkg, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResourceName && this.equalTo((ImmutableResourceName)another);
    }

    private boolean equalTo(ImmutableResourceName another) {
        return this.pkg.equals(another.pkg) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pkg.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ResourceName").omitNullValues().add("pkg", (Object)this.pkg).add("name", (Object)this.name).toString();
    }

    public static ImmutableResourceName copyOf(HdesCompiler.ResourceName instance) {
        if (instance instanceof ImmutableResourceName) {
            return (ImmutableResourceName)instance;
        }
        return ImmutableResourceName.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HdesCompiler.ResourceName", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PKG = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String pkg;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HdesCompiler.ResourceName instance) {
            Objects.requireNonNull(instance, "instance");
            this.pkg(instance.getPkg());
            this.name(instance.getName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pkg(String pkg) {
            this.pkg = Objects.requireNonNull(pkg, "pkg");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableResourceName build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResourceName(this.pkg, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pkg");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ResourceName, some of required attributes are not set " + attributes;
        }
    }
}

