/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi;

import com.google.googlejavaformat.java.Formatter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.DecisionTableNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.RootNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.ast.api.visitors.HdesVisitor;
import io.resys.hdes.ast.spi.ImmutableHdesTree;
import io.resys.hdes.compiler.api.HdesCompiler;
import io.resys.hdes.compiler.api.HdesCompilerException;
import io.resys.hdes.compiler.api.ImmutableResource;
import io.resys.hdes.compiler.api.ImmutableResourceDeclaration;
import io.resys.hdes.compiler.api.ImmutableResourceName;
import io.resys.hdes.compiler.spi.dt.visitors.DtApiVisitor;
import io.resys.hdes.compiler.spi.dt.visitors.DtImplVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.FlApiVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.FlImplVisitor;
import io.resys.hdes.compiler.spi.st.visitors.StApiVisitor;
import io.resys.hdes.compiler.spi.st.visitors.StImplVisitor;
import io.resys.hdes.compiler.spi.st.visitors.StPromiseApiVisitor;
import io.resys.hdes.compiler.spi.st.visitors.StPromiseImplVisitor;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.compiler.spi.units.ImmutableCompilerNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CompilerRootNodeVisitor
implements HdesVisitor.RootNodeVisitor<List<HdesCompiler.Resource>, HdesCompiler.Resource> {
    public List<HdesCompiler.Resource> visitBody(RootNode root) {
        ImmutableCompilerNode compilerNode = ImmutableCompilerNode.config().ast(root).build();
        HdesTree.RootTree ctx = (HdesTree.RootTree)ImmutableHdesTree.builder().value((HdesNode)root).parent((HdesTree)ImmutableHdesTree.builder().value((HdesNode)compilerNode).build()).build();
        return Collections.unmodifiableList(root.getBody().values().stream().map(node -> this.visitNode((BodyNode)node, ctx)).collect(Collectors.toList()));
    }

    public HdesCompiler.Resource visitNode(BodyNode ast, HdesTree.RootTree ctx) {
        if (ast instanceof DecisionTableNode.DecisionTableBody) {
            CompilerNode.DecisionTableUnit type = ((CompilerNode)ctx.get().node(CompilerNode.class)).dt((DecisionTableNode.DecisionTableBody)ast);
            return this.visitDecisionTable((HdesTree.DecisionTableTree)ctx.next((HdesNode)type).next((HdesNode)ast));
        }
        if (ast instanceof FlowNode.FlowBody) {
            CompilerNode.FlowUnit unit = ((CompilerNode)ctx.get().node(CompilerNode.class)).fl((FlowNode.FlowBody)ast);
            return this.visitFlow((HdesTree.FlowTree)ctx.next((HdesNode)unit).next((HdesNode)ast));
        }
        if (ast instanceof ServiceNode.ServiceBody) {
            CompilerNode.ServiceUnit unit = ((CompilerNode)ctx.get().node(CompilerNode.class)).st((ServiceNode.ServiceBody)ast);
            return this.visitService((HdesTree.ServiceTree)ctx.next((HdesNode)unit).next((HdesNode)ast));
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)ast));
    }

    public HdesCompiler.Resource visitService(HdesTree.ServiceTree ctx) {
        ServiceNode.ServiceBody body = ctx.getValue();
        CompilerNode.ServiceUnit type = (CompilerNode.ServiceUnit)ctx.get().node(CompilerNode.ServiceUnit.class);
        boolean promise = body.getCommand().getPromise().isPresent();
        TypeSpec api = promise ? new StPromiseApiVisitor().visitBody(ctx) : new StApiVisitor().visitBody(ctx);
        TypeSpec impl = promise ? new StPromiseImplVisitor().visitBody(ctx) : new StImplVisitor().visitBody(ctx);
        String pkg = type.getType().getPkg();
        return ImmutableResource.builder().type(HdesCompiler.ResourceType.ST).name(body.getId().getValue()).source(body.getToken().getText()).ast((BodyNode)body).accepts(CompilerRootNodeVisitor.typeName(type.getType().getAccepts().getName())).returns(CompilerRootNodeVisitor.typeName(type.getType().getReturns().getName())).ends(CompilerRootNodeVisitor.typeName(type.getType().getReturnType().getName())).addDeclarations((HdesCompiler.ResourceDeclaration)ImmutableResourceDeclaration.builder().type(ImmutableResourceName.builder().name(api.name).pkg(pkg).build()).isExecutable(false).value(CompilerRootNodeVisitor.javaFile(api, pkg)).build()).addDeclarations((HdesCompiler.ResourceDeclaration)ImmutableResourceDeclaration.builder().type(ImmutableResourceName.builder().name(impl.name).pkg(pkg).build()).isExecutable(true).value(CompilerRootNodeVisitor.javaFile(impl, pkg)).build()).build();
    }

    public HdesCompiler.Resource visitFlow(HdesTree.FlowTree ctx) {
        FlowNode.FlowBody body = ctx.getValue();
        CompilerNode.FlowUnit type = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        TypeSpec api = new FlApiVisitor().visitBody(ctx);
        TypeSpec impl = new FlImplVisitor().visitBody(ctx);
        String pkg = type.getType().getPkg();
        return ImmutableResource.builder().type(HdesCompiler.ResourceType.FL).name(body.getId().getValue()).source(body.getToken().getText()).ast((BodyNode)body).accepts(CompilerRootNodeVisitor.typeName(type.getType().getAccepts().getName())).returns(CompilerRootNodeVisitor.typeName(type.getType().getReturns().getName())).ends(CompilerRootNodeVisitor.typeName(type.getType().getReturnType().getName())).addDeclarations((HdesCompiler.ResourceDeclaration)ImmutableResourceDeclaration.builder().type(ImmutableResourceName.builder().name(api.name).pkg(pkg).build()).isExecutable(false).value(CompilerRootNodeVisitor.javaFile(api, pkg)).build()).addDeclarations((HdesCompiler.ResourceDeclaration)ImmutableResourceDeclaration.builder().type(ImmutableResourceName.builder().name(impl.name).pkg(pkg).build()).isExecutable(true).value(CompilerRootNodeVisitor.javaFile(impl, pkg)).build()).build();
    }

    public HdesCompiler.Resource visitDecisionTable(HdesTree.DecisionTableTree ctx) {
        DecisionTableNode.DecisionTableBody body = ctx.getValue();
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        TypeSpec api = new DtApiVisitor().visitBody(ctx);
        TypeSpec impl = new DtImplVisitor().visitBody(ctx);
        String pkg = type.getType().getPkg();
        String nestedPkg = pkg + "." + api.name;
        return ImmutableResource.builder().type(HdesCompiler.ResourceType.DT).name(body.getId().getValue()).source(body.getToken().getText()).ast((BodyNode)body).addAllTypes(api.typeSpecs.stream().map(spec -> ImmutableResourceName.builder().name(spec.name).pkg(nestedPkg).build()).collect(Collectors.toList())).addTypes((HdesCompiler.ResourceName)ImmutableResourceName.builder().name(api.name).pkg(pkg).build()).addTypes((HdesCompiler.ResourceName)ImmutableResourceName.builder().name(impl.name).pkg(pkg).build()).accepts(CompilerRootNodeVisitor.typeName(type.getType().getAccepts().getName())).returns(CompilerRootNodeVisitor.typeName(type.getType().getReturns().getName())).ends(CompilerRootNodeVisitor.typeName(type.getType().getReturnType().getName())).addDeclarations((HdesCompiler.ResourceDeclaration)ImmutableResourceDeclaration.builder().type(ImmutableResourceName.builder().name(api.name).pkg(pkg).build()).isExecutable(false).value(CompilerRootNodeVisitor.javaFile(api, pkg)).build()).addDeclarations((HdesCompiler.ResourceDeclaration)ImmutableResourceDeclaration.builder().type(ImmutableResourceName.builder().name(impl.name).pkg(pkg).build()).isExecutable(true).value(CompilerRootNodeVisitor.javaFile(impl, pkg)).build()).build();
    }

    private static HdesCompiler.ResourceName typeName(ClassName name) {
        return ImmutableResourceName.builder().name(name.simpleName()).pkg(name.packageName()).build();
    }

    public static String javaFile(TypeSpec spec, String pkg) {
        try {
            StringBuilder appendable = new StringBuilder();
            JavaFile file = JavaFile.builder((String)pkg, (TypeSpec)spec).build();
            file.writeTo((Appendable)appendable);
            String result = appendable.toString();
            return new Formatter().formatSource(result);
        }
        catch (Exception e) {
            StringBuilder appendable = new StringBuilder();
            JavaFile file = JavaFile.builder((String)pkg, (TypeSpec)spec).build();
            try {
                file.writeTo((Appendable)appendable);
            }
            catch (IOException e1) {
                throw new UncheckedIOException(e1);
            }
            String result = appendable.toString();
            return result;
        }
    }
}

