/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.dt.visitors;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.DecisionTableNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.visitors.DecisionTableVisitor;
import io.resys.hdes.compiler.spi.dt.visitors.DtSpec;
import io.resys.hdes.compiler.spi.dt.visitors.ImmutableDtHeaderSpec;
import io.resys.hdes.compiler.spi.dt.visitors.ImmutableDtHeadersSpec;
import io.resys.hdes.compiler.spi.dt.visitors.ImmutableDtHitPolicySpec;
import io.resys.hdes.compiler.spi.spec.HdesDefSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.spi.dt.DecisionTableConstants;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public class DtApiVisitor
implements DecisionTableVisitor<DtSpec, TypeSpec> {
    public TypeSpec visitBody(HdesTree.DecisionTableTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        HdesDefSpec.ApiBuilder api = HdesDefSpec.api(type.getType());
        this.visitHeaders(ctx.getValue().getHeaders(), (HdesTree)ctx).getValue().accept(api);
        this.visitHitPolicy(ctx.getValue().getHitPolicy(), (HdesTree)ctx);
        return api.build().build();
    }

    public DtHitPolicySpec visitHitPolicy(DecisionTableNode.HitPolicy hitPolicy, HdesTree ctx) {
        if (hitPolicy instanceof DecisionTableNode.HitPolicyAll) {
            return this.visitHitPolicyAll((DecisionTableNode.HitPolicyAll)hitPolicy, ctx);
        }
        if (hitPolicy instanceof DecisionTableNode.HitPolicyFirst) {
            return this.visitHitPolicyFirst((DecisionTableNode.HitPolicyFirst)hitPolicy, ctx);
        }
        if (hitPolicy instanceof DecisionTableNode.HitPolicyMapping) {
            return this.visitHitPolicyMapping((DecisionTableNode.HitPolicyMapping)hitPolicy, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public DtHeadersSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        DecisionTableNode.DecisionTableBody body = (DecisionTableNode.DecisionTableBody)ctx.get().node(DecisionTableNode.DecisionTableBody.class);
        ParameterizedTypeName staticType = ParameterizedTypeName.get((ClassName)ClassName.get(DecisionTableConstants.class), (TypeName[])new TypeName[]{type.getConstants().getSuperinterface()});
        HdesTree next = ctx.next((HdesNode)node);
        Consumer<HdesDefSpec.ApiBuilder> consumer = api -> {
            ImmutableSpec.ImmutableBuilder input = api.inputValue();
            ImmutableSpec.ImmutableBuilder output = api.outputValue(type.getListValue().getName());
            ImmutableSpec.ImmutableBuilder constants = api.immutable(type.getConstants().getName()).superinterface((TypeName)staticType);
            node.getAcceptDefs().stream().forEach(typeDef -> this.visitHeader((BodyNode.TypeDef)typeDef, next).getValue().accept(input));
            node.getReturnDefs().stream().forEach(typeDef -> this.visitHeader((BodyNode.TypeDef)typeDef, next).getValue().accept(output));
            DtHitPolicySpec hitPolicy = this.visitHitPolicy(body.getHitPolicy(), next);
            hitPolicy.getOutputs().accept(output);
            hitPolicy.getNested().accept((HdesDefSpec.ApiBuilder)api);
            hitPolicy.getStatics().accept(constants);
            constants.build();
            input.build();
            output.build();
        };
        return ImmutableDtHeadersSpec.builder().value(consumer).build();
    }

    public DtHeaderSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        BodyNode.ScalarDef scalar = (BodyNode.ScalarDef)node;
        return this.visitHeader(scalar, ctx);
    }

    public DtHeaderSpec visitHeader(BodyNode.ScalarDef scalar, HdesTree ctx) {
        return ImmutableDtHeaderSpec.builder().value(immutable -> immutable.method(scalar).build()).build();
    }

    public DtHitPolicySpec visitHitPolicyAll(DecisionTableNode.HitPolicyAll node, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        return ImmutableDtHitPolicySpec.builder().nested(api -> api.outputValue().method("values").isList().returns((TypeName)type.getListValue().getName()).build().build()).outputs(t -> {}).statics(t -> {}).build();
    }

    public DtHitPolicySpec visitHitPolicyFirst(DecisionTableNode.HitPolicyFirst node, HdesTree ctx) {
        return ImmutableDtHitPolicySpec.builder().nested(t -> {}).outputs(t -> {}).statics(t -> {}).build();
    }

    public DtHitPolicySpec visitHitPolicyMapping(DecisionTableNode.HitPolicyMapping matrix, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)matrix);
        List delegate = matrix.getMapsTo().stream().map(row -> this.visitMappingRow((DecisionTableNode.MappingRow)row, next)).collect(Collectors.toList());
        return ImmutableDtHitPolicySpec.builder().nested(t -> delegate.forEach(d -> d.getNested().accept((HdesDefSpec.ApiBuilder)t))).outputs(t -> delegate.forEach(d -> d.getOutputs().accept((ImmutableSpec.ImmutableBuilder)t))).statics(t -> delegate.forEach(d -> d.getStatics().accept((ImmutableSpec.ImmutableBuilder)t))).build();
    }

    public DtHitPolicySpec visitMappingRow(DecisionTableNode.MappingRow row, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        DecisionTableNode.HitPolicyMapping matrix = (DecisionTableNode.HitPolicyMapping)ctx.getValue();
        String headerName = row.getAccepts().getValue();
        BodyNode.ScalarDef scalar = (BodyNode.ScalarDef)type.getBody().getHeaders().getAcceptDefs().stream().filter(t -> t.getName().equals(headerName)).findFirst().get();
        return ImmutableDtHitPolicySpec.builder().nested(t -> {}).outputs(t -> t.method(scalar).returns(matrix.getDefTo()).build()).statics(t -> t.method(row.getAccepts()).returns(type.getConstants().getSuperinterface()).build()).build();
    }

    public DtSpec visitWhenRuleRow(DecisionTableNode.WhenRuleRow node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public DtSpec visitThenRuleRow(DecisionTableNode.ThenRuleRow node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public DtSpec visitRuleRow(DecisionTableNode.RuleRow node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public DtSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public DtSpec visitFormula(BodyNode.ScalarDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    @Value.Immutable
    public static interface DtHeadersSpec
    extends DtSpec {
        public Consumer<HdesDefSpec.ApiBuilder> getValue();
    }

    @Value.Immutable
    public static interface DtHitPolicySpec
    extends DtSpec {
        public Consumer<ImmutableSpec.ImmutableBuilder> getOutputs();

        public Consumer<ImmutableSpec.ImmutableBuilder> getStatics();

        public Consumer<HdesDefSpec.ApiBuilder> getNested();
    }

    @Value.Immutable
    public static interface DtHeaderSpec
    extends DtSpec {
        public Consumer<ImmutableSpec.ImmutableBuilder> getValue();
    }
}

