/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.dt.visitors;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.DecisionTableNode;
import io.resys.hdes.ast.api.nodes.ExpressionNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.visitors.DecisionTableVisitor;
import io.resys.hdes.compiler.spi.dt.visitors.DtSpec;
import io.resys.hdes.compiler.spi.dt.visitors.ImmutableDtCodeBlockSpec;
import io.resys.hdes.compiler.spi.dt.visitors.ImmutableDtHeaderCodeBlockSpec;
import io.resys.hdes.compiler.spi.dt.visitors.ImmutableDtHitPolicyCodeSpec;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.spec.HdesDefSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.spi.beans.ImmutableMatched;
import io.resys.hdes.executor.spi.beans.ImmutableTrace;
import io.resys.hdes.executor.spi.exceptions.HdesNoMatchesException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.immutables.value.Value;

public class DtImplVisitor
implements DecisionTableVisitor<DtSpec, TypeSpec> {
    public TypeSpec visitBody(HdesTree.DecisionTableTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        HdesDefSpec.ImplBuilder exec = HdesDefSpec.impl(type.getType());
        DtHitPolicyCodeSpec hitpolicy = this.visitHitPolicy(ctx.getValue().getHitPolicy(), (HdesTree)ctx);
        hitpolicy.getConstants().ifPresent(c -> exec.field(FieldSpec.builder((TypeName)type.getConstants().getName(), (String)"constants", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer(c).build()));
        CodeBlock.Builder execution = CodeBlock.builder().addStatement("var parent = $T.builder().id($S).body($L).build()", new Object[]{ImmutableTrace.class, "input", "input"});
        DtHeaderCodeBlockSpec headers = this.visitHeaders(ctx.getValue().getHeaders(), (HdesTree)ctx);
        headers.getBefore().ifPresent(e -> execution.add(e));
        execution.add(hitpolicy.getValue());
        headers.getAfter().ifPresent(e -> execution.add(e));
        execution.addStatement("return $T.builder().id($S).time(System.currentTimeMillis()).parent(parent).body(returns).build()", new Object[]{ImmutableSpec.from(type.getType().getReturnType().getName()), ctx.getValue().getId().getValue()});
        return exec.execution(execution.build()).build().build();
    }

    public DtHitPolicyCodeSpec visitHitPolicy(DecisionTableNode.HitPolicy hitPolicy, HdesTree ctx) {
        if (hitPolicy instanceof DecisionTableNode.HitPolicyFirst) {
            return this.visitHitPolicyFirst((DecisionTableNode.HitPolicyFirst)hitPolicy, ctx);
        }
        if (hitPolicy instanceof DecisionTableNode.HitPolicyAll) {
            return this.visitHitPolicyAll((DecisionTableNode.HitPolicyAll)hitPolicy, ctx);
        }
        return this.visitHitPolicyMapping((DecisionTableNode.HitPolicyMapping)hitPolicy, ctx);
    }

    public DtHitPolicyCodeSpec visitHitPolicyAll(DecisionTableNode.HitPolicyAll node, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder code = CodeBlock.builder().addStatement("final var hitpolicy = $T.builder()", new Object[]{ImmutableSpec.from(type.getType().getReturns().getName())}).addStatement("final var hitpolicyTrace = $T.builder()", new Object[]{ImmutableMatched.class});
        int index = 0;
        for (DecisionTableNode.RuleRow rules : node.getRows()) {
            CodeBlock when = this.visitWhenRuleRow(rules.getWhen(), next).getValue();
            DtCodeBlockSpec conclusion = this.visitThenRuleRow(rules.getThen(), next);
            code.beginControlFlow("if($L)", new Object[]{when.isEmpty() ? "true" : when}).addStatement("hitpolicyTrace.add($L, $S)", new Object[]{index, rules.getToken().getText()}).addStatement("hitpolicy.addValues($L)", new Object[]{conclusion.getValue()}).endControlFlow();
            ++index;
        }
        code.addStatement("var returns = hitpolicy.build()", new Object[0]).addStatement("parent = $T.builder().parent(parent).id($S).body(hitpolicyTrace.returns(returns).build()).build()", new Object[]{ImmutableTrace.class, "when"});
        return ImmutableDtHitPolicyCodeSpec.builder().constants(this.getRuleConstants(node.getRows(), next)).value(code.build()).build();
    }

    public DtCodeBlockSpec visitWhenRuleRow(DecisionTableNode.WhenRuleRow node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder code = CodeBlock.builder();
        int index = 0;
        ArrayList<CodeBlock> blocks = new ArrayList<CodeBlock>();
        for (ExpressionNode.ExpressionBody expression : node.getValues()) {
            BodyNode.ScalarDef header = (BodyNode.ScalarDef)ctx.get().body().getHeaders().getAcceptDefs().get(index);
            CodeBlock value = ExpressionFactory.builder().body(expression).tree(next.next((HdesNode)header)).build().getValue();
            if (!value.toString().trim().equals("true")) {
                blocks.add(value);
            }
            ++index;
        }
        index = 0;
        for (CodeBlock value : blocks) {
            if (index++ > 0) {
                code.add(" && ", new Object[0]);
            }
            code.add("($L)", new Object[]{value});
        }
        return ImmutableDtCodeBlockSpec.builder().value(code.build()).build();
    }

    public DtHitPolicyCodeSpec visitHitPolicyFirst(DecisionTableNode.HitPolicyFirst node, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder code = CodeBlock.builder().addStatement("$T returns", new Object[]{type.getType().getReturns().getName()}).addStatement("final var hitpolicyTrace = $T.builder()", new Object[]{ImmutableMatched.class});
        int index = 0;
        for (DecisionTableNode.RuleRow rules : node.getRows()) {
            CodeBlock when = this.visitWhenRuleRow(rules.getWhen(), next).getValue();
            String control = index > 0 ? "else if" : "if";
            DtCodeBlockSpec conclusion = this.visitThenRuleRow(rules.getThen(), next);
            code.beginControlFlow(control + "($L)", new Object[]{when.isEmpty() ? "true" : when}).addStatement("hitpolicyTrace.add($L, $S)", new Object[]{index, rules.getToken().getText()}).addStatement("returns = $L", new Object[]{conclusion.getValue()}).endControlFlow();
            ++index;
        }
        if (index > 0) {
            code.beginControlFlow("else", new Object[0]).addStatement("throw new $T()", new Object[]{HdesNoMatchesException.class}).endControlFlow();
        }
        code.addStatement("parent = $T.builder().parent(parent).id($S).body(hitpolicyTrace.returns(returns).build()).build()", new Object[]{ImmutableTrace.class, "when"});
        return ImmutableDtHitPolicyCodeSpec.builder().constants(this.getRuleConstants(node.getRows(), next)).value(code.build()).build();
    }

    public DtHitPolicyCodeSpec visitHitPolicyMapping(DecisionTableNode.HitPolicyMapping node, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder code = CodeBlock.builder().addStatement("final var hitpolicy = $T.builder()", new Object[]{ImmutableSpec.from(type.getType().getReturns().getName())}).addStatement("final var hitpolicyTrace = $T.builder()", new Object[]{ImmutableMatched.class});
        for (DecisionTableNode.MappingRow row : node.getMapsTo()) {
            code.add("\r\n", new Object[0]).add(this.visitMappingRow(row, next).getValue());
        }
        code.addStatement("var returns = hitpolicy.build()", new Object[0]).addStatement("parent = $T.builder().parent(parent).id($S).body(hitpolicyTrace.returns(returns).build()).build()", new Object[]{ImmutableTrace.class, "when"});
        return ImmutableDtHitPolicyCodeSpec.builder().constants(this.getMappingConstants(node.getMapsTo(), next)).value(code.build()).build();
    }

    public DtCodeBlockSpec visitMappingRow(DecisionTableNode.MappingRow row, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        DecisionTableNode.HitPolicyMapping matrix = (DecisionTableNode.HitPolicyMapping)type.getBody().getHitPolicy();
        DecisionTableNode.WhenRuleRow when = matrix.getWhen();
        BodyNode.ScalarDef header = (BodyNode.ScalarDef)type.getBody().getHeaders().getAcceptDefs().stream().filter(t -> t.getName().equals(row.getAccepts().getValue())).findFirst().get();
        CodeBlock.Builder code = CodeBlock.builder();
        HdesTree next = ctx.next((HdesNode)header);
        int index = 0;
        for (ExpressionNode.ExpressionBody condition : when.getValues()) {
            String control = index > 0 ? "else if" : "if";
            BodyNode.Literal conclusion = (BodyNode.Literal)row.getThen().getValues().get(index);
            code.beginControlFlow("$L($L) ", new Object[]{control, ExpressionFactory.builder().body(condition).tree(next).build().getValue()}).addStatement("hitpolicyTrace.add($L, $S)", new Object[]{index, condition.getToken().getText()});
            code.addStatement("hitpolicy.$L($L)", new Object[]{header.getName(), ExpressionFactory.builder().body(conclusion).tree(next).build().getValue()}).endControlFlow();
            ++index;
        }
        return ImmutableDtCodeBlockSpec.builder().value(code.build()).build();
    }

    public DtHeaderCodeBlockSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder beforeCollector = CodeBlock.builder();
        for (BodyNode.TypeDef type : node.getAcceptDefs()) {
            beforeCollector.add(this.visitHeader(type, next).getValue());
        }
        CodeBlock beforeFormulas = beforeCollector.build();
        CodeBlock.Builder before = CodeBlock.builder();
        if (!beforeFormulas.toString().isBlank()) {
            before.add("\r\n", new Object[0]).add("// formulas on accepts params\r\n", new Object[0]).add(beforeFormulas).addStatement("parent = $T.builder().parent(parent).id($S).body($L).build()", new Object[]{ImmutableTrace.class, "accepts-formulas", "input"});
        }
        CodeBlock.Builder afterCollector = CodeBlock.builder();
        for (BodyNode.TypeDef type : node.getReturnDefs()) {
            afterCollector.add(this.visitHeader(type, next).getValue());
        }
        CodeBlock afterFormulas = afterCollector.build();
        CodeBlock.Builder after = CodeBlock.builder();
        if (!afterFormulas.toString().isBlank()) {
            after.add("\r\n", new Object[0]).add("// formulas on returns params\r\n", new Object[0]).add(afterFormulas).addStatement("parent = $T.builder().parent(parent).id($S).body($L).build()", new Object[]{ImmutableTrace.class, "returns-formulas", "returns"});
        }
        return ImmutableDtHeaderCodeBlockSpec.builder().before(before.add("\r\n", new Object[0]).build()).after(after.add("\r\n", new Object[0]).build()).build();
    }

    public DtCodeBlockSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        BodyNode.ScalarDef scalar = (BodyNode.ScalarDef)node;
        return this.visitHeader(scalar, ctx);
    }

    public DtCodeBlockSpec visitHeader(BodyNode.ScalarDef node, HdesTree ctx) {
        if (node.getFormula().isEmpty()) {
            return ImmutableDtCodeBlockSpec.builder().value(CodeBlock.builder().build()).build();
        }
        return this.visitFormula(node, ctx);
    }

    public DtCodeBlockSpec visitFormula(BodyNode.ScalarDef node, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder code = CodeBlock.builder();
        if (node.getContext() == BodyNode.ContextTypeDef.ACCEPTS) {
            CodeBlock formula = ExpressionFactory.builder().body((ExpressionNode.ExpressionBody)node.getFormula().get()).tree(next).build().getValue();
            code.addStatement("$L = $T.builder().from($L).$L($L).build()", new Object[]{"input", ImmutableSpec.from(type.getType().getAccepts().getName()), "input", node.getName(), formula});
        } else {
            CodeBlock formula = ExpressionFactory.builder().body((ExpressionNode.ExpressionBody)node.getFormula().get()).tree(next).build().getValue();
            code.addStatement("$L = $T.builder().from($L).$L($L).build()", new Object[]{"returns", ImmutableSpec.from(type.getType().getReturns().getName()), "returns", node.getName(), formula});
        }
        return ImmutableDtCodeBlockSpec.builder().value(code.build()).build();
    }

    public DtCodeBlockSpec visitThenRuleRow(DecisionTableNode.ThenRuleRow node, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        HdesTree next = ctx.next((HdesNode)node);
        List headers = type.getBody().getHeaders().getReturnDefs().stream().map(e -> (BodyNode.ScalarDef)e).filter(e -> e.getFormula().isEmpty()).collect(Collectors.toList());
        CodeBlock.Builder code = CodeBlock.builder().add("$T.builder()", new Object[]{ImmutableSpec.from(type.getListValue().getName())});
        int index = 0;
        for (BodyNode.Literal conclusion : node.getValues()) {
            BodyNode.TypeDef header = (BodyNode.TypeDef)headers.get(index);
            code.add(".$L($L)", new Object[]{header.getName(), ExpressionFactory.builder().body(conclusion).tree(next).build().getValue()});
            ++index;
        }
        return ImmutableDtCodeBlockSpec.builder().value(code.add(".build()", new Object[0]).build()).build();
    }

    public DtCodeBlockSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public DtCodeBlockSpec visitRuleRow(DecisionTableNode.RuleRow node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    private CodeBlock getRuleConstants(List<DecisionTableNode.RuleRow> rows, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        List headers = type.getBody().getHeaders().getReturnDefs().stream().map(e -> (BodyNode.ScalarDef)e).filter(e -> e.getFormula().isEmpty()).collect(Collectors.toList());
        CodeBlock.Builder execution = CodeBlock.builder().add("$T.builder()", new Object[]{ImmutableSpec.from(type.getConstants().getName())});
        for (DecisionTableNode.RuleRow row : rows) {
            CodeBlock.Builder value = CodeBlock.builder();
            int index = 0;
            for (BodyNode.Literal then : row.getThen().getValues()) {
                BodyNode.ScalarDef header = (BodyNode.ScalarDef)headers.get(index++);
                HdesTree next = ctx.next((HdesNode)row).next((HdesNode)header);
                CodeBlock literal = ExpressionFactory.builder().body(then).tree(next).build().getValue();
                CodeBlock ruleCode = CodeBlock.builder().add(".$L($L)", new Object[]{header.getName(), literal}).build();
                if (ruleCode.isEmpty()) continue;
                value.add(ruleCode);
            }
            execution.add(".addValues($T.builder()$L.build())", new Object[]{ImmutableSpec.from(type.getListValue().getName()), value.build()});
        }
        return execution.add(".build()", new Object[0]).build();
    }

    private CodeBlock getMappingConstants(List<DecisionTableNode.MappingRow> rows, HdesTree ctx) {
        CompilerNode.DecisionTableUnit type = (CompilerNode.DecisionTableUnit)ctx.get().node(CompilerNode.DecisionTableUnit.class);
        CodeBlock.Builder execution = CodeBlock.builder().add("$T.builder()", new Object[]{ImmutableSpec.from(type.getConstants().getName())});
        for (DecisionTableNode.MappingRow matrixRow : rows) {
            BodyNode.ScalarDef header = (BodyNode.ScalarDef)type.getBody().getHeaders().getAcceptDefs().stream().filter(t -> t.getName().equals(matrixRow.getAccepts().getValue())).findFirst().get();
            CodeBlock.Builder values = CodeBlock.builder();
            HdesTree next = ctx.next((HdesNode)matrixRow).next((HdesNode)header);
            for (BodyNode.Literal literalValue : matrixRow.getThen().getValues()) {
                if (!values.isEmpty()) {
                    values.add(", ", new Object[0]);
                }
                values.add("$L", new Object[]{ExpressionFactory.builder().body(literalValue).tree(next).build().getValue()});
            }
            execution.add(".$L($T.asList($L))", new Object[]{header.getName(), Arrays.class, values.build()});
            execution.add(".addValues($T.asList($L))", new Object[]{Arrays.class, values.build()});
        }
        return execution.add(".build()", new Object[0]).build();
    }

    @Value.Immutable
    static interface DtHitPolicyCodeSpec
    extends DtSpec {
        public CodeBlock getValue();

        public Optional<CodeBlock> getConstants();
    }

    @Value.Immutable
    static interface DtHeaderCodeBlockSpec
    extends DtSpec {
        public Optional<CodeBlock> getBefore();

        public Optional<CodeBlock> getAfter();
    }

    @Value.Immutable
    static interface DtCodeBlockSpec
    extends DtSpec {
        public CodeBlock getValue();
    }
}

