/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.dt.visitors;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.compiler.spi.dt.visitors.DtImplVisitor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DtImplVisitor.DtHitPolicyCodeSpec", generator="Immutables")
@Immutable
final class ImmutableDtHitPolicyCodeSpec
implements DtImplVisitor.DtHitPolicyCodeSpec {
    private final CodeBlock value;
    @Nullable
    private final CodeBlock constants;

    private ImmutableDtHitPolicyCodeSpec(CodeBlock value, @Nullable CodeBlock constants) {
        this.value = value;
        this.constants = constants;
    }

    @Override
    public CodeBlock getValue() {
        return this.value;
    }

    @Override
    public Optional<CodeBlock> getConstants() {
        return Optional.ofNullable(this.constants);
    }

    public final ImmutableDtHitPolicyCodeSpec withValue(CodeBlock value) {
        if (this.value == value) {
            return this;
        }
        CodeBlock newValue = Objects.requireNonNull(value, "value");
        return new ImmutableDtHitPolicyCodeSpec(newValue, this.constants);
    }

    public final ImmutableDtHitPolicyCodeSpec withConstants(CodeBlock value) {
        CodeBlock newValue = Objects.requireNonNull(value, "constants");
        if (this.constants == newValue) {
            return this;
        }
        return new ImmutableDtHitPolicyCodeSpec(this.value, newValue);
    }

    public final ImmutableDtHitPolicyCodeSpec withConstants(Optional<? extends CodeBlock> optional) {
        CodeBlock value = optional.orElse(null);
        if (this.constants == value) {
            return this;
        }
        return new ImmutableDtHitPolicyCodeSpec(this.value, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDtHitPolicyCodeSpec && this.equalTo((ImmutableDtHitPolicyCodeSpec)another);
    }

    private boolean equalTo(ImmutableDtHitPolicyCodeSpec another) {
        return this.value.equals((Object)another.value) && Objects.equals(this.constants, another.constants);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.constants);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DtHitPolicyCodeSpec").omitNullValues().add("value", (Object)this.value).add("constants", (Object)this.constants).toString();
    }

    public static ImmutableDtHitPolicyCodeSpec copyOf(DtImplVisitor.DtHitPolicyCodeSpec instance) {
        if (instance instanceof ImmutableDtHitPolicyCodeSpec) {
            return (ImmutableDtHitPolicyCodeSpec)instance;
        }
        return ImmutableDtHitPolicyCodeSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DtImplVisitor.DtHitPolicyCodeSpec", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private CodeBlock value;
        @Nullable
        private CodeBlock constants;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DtImplVisitor.DtHitPolicyCodeSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            Optional<CodeBlock> constantsOptional = instance.getConstants();
            if (constantsOptional.isPresent()) {
                this.constants(constantsOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(CodeBlock value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constants(CodeBlock constants) {
            this.constants = Objects.requireNonNull(constants, "constants");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder constants(Optional<? extends CodeBlock> constants) {
            this.constants = constants.orElse(null);
            return this;
        }

        public ImmutableDtHitPolicyCodeSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDtHitPolicyCodeSpec(this.value, this.constants);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build DtHitPolicyCodeSpec, some of required attributes are not set " + attributes;
        }
    }
}

