/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.expressions;

import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.HdesException;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.DecisionTableNode;
import io.resys.hdes.ast.api.nodes.ExpressionNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.ImmutableBodyId;
import io.resys.hdes.ast.api.nodes.ImmutableExpressionBody;
import io.resys.hdes.ast.api.nodes.ImmutableHeaders;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.ast.api.visitors.ExpressionVisitor;
import io.resys.hdes.ast.spi.util.Assertions;
import io.resys.hdes.compiler.spi.expressions.invocation.DecisionTableInvocationVisitor;
import io.resys.hdes.compiler.spi.expressions.invocation.FlowInvocationVisitor;
import io.resys.hdes.compiler.spi.expressions.invocation.ServiceInvocationVisitor;
import io.resys.hdes.compiler.spi.expressions.visitors.GenericExpressionVisitor;
import org.immutables.value.Value;

public interface ExpressionFactory {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ExpressionNode.ExpressionBody body;
        private HdesTree tree;

        public Builder body(ExpressionNode.ExpressionBody body) {
            this.body = body;
            return this;
        }

        public Builder body(BodyNode.Literal body) {
            this.body = ImmutableExpressionBody.builder().token(body.getToken()).value((HdesNode)body).src(body.getToken().getText()).headers((BodyNode.Headers)ImmutableHeaders.builder().token(body.getToken()).build()).id((BodyNode.BodyId)ImmutableBodyId.builder().token(body.getToken()).value("").build()).build();
            return this;
        }

        public Builder body(InvocationNode body) {
            this.body = ImmutableExpressionBody.builder().token(body.getToken()).value((HdesNode)body).src(body.getToken().getText()).headers((BodyNode.Headers)ImmutableHeaders.builder().token(body.getToken()).build()).id((BodyNode.BodyId)ImmutableBodyId.builder().token(body.getToken()).value("").build()).build();
            return this;
        }

        public Builder tree(HdesTree tree) {
            this.tree = tree;
            return this;
        }

        public ExpScalarCode build() {
            Object invocation;
            Assertions.notNull((Object)this.body, () -> "body side can't be null!");
            Assertions.notNull((Object)this.tree, () -> "tree side can't be null!");
            BodyNode closestBody = this.tree.get().body();
            if (closestBody instanceof DecisionTableNode.DecisionTableBody) {
                invocation = new DecisionTableInvocationVisitor();
            } else if (closestBody instanceof ServiceNode.ServiceBody) {
                invocation = new ServiceInvocationVisitor();
            } else if (closestBody instanceof FlowNode.FlowBody) {
                invocation = new FlowInvocationVisitor();
            } else {
                throw new HdesException("Unknown body node: " + this.body.getClass() + "!");
            }
            return new GenericExpressionVisitor((ExpressionVisitor.InvocationVisitor<ExpCode, ExpCode>)invocation).visitBody(this.body, this.tree);
        }
    }

    @FunctionalInterface
    public static interface ExpressionCallback {
        public ExpCode visitAny(HdesNode var1, HdesTree var2);
    }

    @Value.Immutable
    public static interface ExpObjectCode
    extends ExpCode {
        public BodyNode.ObjectDef getType();
    }

    @Value.Immutable
    public static interface ExpScalarCode
    extends ExpCode {
        public BodyNode.ScalarType getType();
    }

    public static interface ExpCode {
        public boolean getArray();

        public CodeBlock getValue();
    }
}

