/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.expressions;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExpressionFactory.ExpScalarCode", generator="Immutables")
@Immutable
public final class ImmutableExpScalarCode
implements ExpressionFactory.ExpScalarCode {
    private final boolean array;
    private final CodeBlock value;
    private final BodyNode.ScalarType type;

    private ImmutableExpScalarCode(boolean array, CodeBlock value, BodyNode.ScalarType type) {
        this.array = array;
        this.value = value;
        this.type = type;
    }

    @Override
    public boolean getArray() {
        return this.array;
    }

    @Override
    public CodeBlock getValue() {
        return this.value;
    }

    @Override
    public BodyNode.ScalarType getType() {
        return this.type;
    }

    public final ImmutableExpScalarCode withArray(boolean value) {
        if (this.array == value) {
            return this;
        }
        return new ImmutableExpScalarCode(value, this.value, this.type);
    }

    public final ImmutableExpScalarCode withValue(CodeBlock value) {
        if (this.value == value) {
            return this;
        }
        CodeBlock newValue = Objects.requireNonNull(value, "value");
        return new ImmutableExpScalarCode(this.array, newValue, this.type);
    }

    public final ImmutableExpScalarCode withType(BodyNode.ScalarType value) {
        if (this.type == value) {
            return this;
        }
        BodyNode.ScalarType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableExpScalarCode(this.array, this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExpScalarCode && this.equalTo((ImmutableExpScalarCode)another);
    }

    private boolean equalTo(ImmutableExpScalarCode another) {
        return this.array == another.array && this.value.equals((Object)another.value) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.array);
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExpScalarCode").omitNullValues().add("array", this.array).add("value", (Object)this.value).add("type", (Object)this.type).toString();
    }

    public static ImmutableExpScalarCode copyOf(ExpressionFactory.ExpScalarCode instance) {
        if (instance instanceof ImmutableExpScalarCode) {
            return (ImmutableExpScalarCode)instance;
        }
        return ImmutableExpScalarCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExpressionFactory.ExpScalarCode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARRAY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private boolean array;
        @Nullable
        private CodeBlock value;
        @Nullable
        private BodyNode.ScalarType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExpressionFactory.ExpScalarCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ExpressionFactory.ExpCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExpressionFactory.ExpCode instance;
            if (object instanceof ExpressionFactory.ExpScalarCode) {
                instance = (ExpressionFactory.ExpScalarCode)object;
                this.type(instance.getType());
            }
            if (object instanceof ExpressionFactory.ExpCode) {
                instance = (ExpressionFactory.ExpCode)object;
                this.array(instance.getArray());
                this.value(instance.getValue());
            }
        }

        @CanIgnoreReturnValue
        public final Builder array(boolean array) {
            this.array = array;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(CodeBlock value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(BodyNode.ScalarType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableExpScalarCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExpScalarCode(this.array, this.value, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("array");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ExpScalarCode, some of required attributes are not set " + attributes;
        }
    }
}

