/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.expressions.invocation;

import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.ExpressionNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.ImmutableObjectDef;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.visitors.ExpressionVisitor;
import io.resys.hdes.compiler.api.HdesCompilerException;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.expressions.ImmutableExpObjectCode;
import io.resys.hdes.compiler.spi.expressions.ImmutableExpScalarCode;
import io.resys.hdes.compiler.spi.spec.JavaSpecUtil;

public class DecisionTableInvocationVisitor
implements ExpressionVisitor.InvocationVisitor<ExpressionFactory.ExpCode, ExpressionFactory.ExpCode> {
    public static final String ACCESS_OUTPUT_VALUE = "returns";
    public static final String ACCESS_CONSTANTS = "constants";
    public static final String ACCESS_INPUT_VALUE = "input";

    public ExpressionFactory.ExpCode visitBody(InvocationNode node, HdesTree ctx) {
        if (node instanceof InvocationNode.NestedInvocation) {
            return this.visitNested((InvocationNode.NestedInvocation)node, ctx);
        }
        if (node instanceof InvocationNode.Placeholder) {
            return this.visitPlaceholder((InvocationNode.Placeholder)node, ctx);
        }
        if (node instanceof InvocationNode.SimpleInvocation) {
            return this.visitSimple((InvocationNode.SimpleInvocation)node, ctx);
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }

    public ExpressionFactory.ExpCode visitNested(InvocationNode.NestedInvocation node, HdesTree ctx) {
        BodyNode.TypeDef pathDef = ctx.any().build(node.getPath());
        CodeBlock path = this.visitBody(node.getPath(), ctx).getValue();
        ExpressionFactory.ExpCode value = this.visitBody(node.getValue(), ctx.next((HdesNode)pathDef));
        CodeBlock code = CodeBlock.builder().add(path).add(value.getValue()).build();
        if (value instanceof ExpressionFactory.ExpScalarCode) {
            ExpressionFactory.ExpScalarCode src = (ExpressionFactory.ExpScalarCode)value;
            return ImmutableExpScalarCode.builder().type(src.getType()).array(src.getArray()).value(code).build();
        }
        ExpressionFactory.ExpObjectCode src = (ExpressionFactory.ExpObjectCode)value;
        return ImmutableExpObjectCode.builder().array(src.getArray()).type(src.getType()).value(code).build();
    }

    public ExpressionFactory.ExpCode visitSimple(InvocationNode.SimpleInvocation node, HdesTree ctx) {
        BodyNode.TypeDef typeDef = ctx.any().build((InvocationNode)node);
        CodeBlock.Builder value = CodeBlock.builder();
        if (typeDef.getContext() == BodyNode.ContextTypeDef.ACCEPTS) {
            value.add("$L.$L$L", new Object[]{ACCESS_INPUT_VALUE, JavaSpecUtil.methodCall(typeDef.getName()), typeDef.getRequired() != false ? "" : ".get()"});
        } else if (typeDef.getContext() == BodyNode.ContextTypeDef.CONSTANTS) {
            value.add(node.getValue(), new Object[0]);
        } else if (typeDef.getContext() == BodyNode.ContextTypeDef.RETURNS) {
            value.add(".", new Object[0]).add(JavaSpecUtil.getMethodName(node.getValue()), new Object[0]).add("()", new Object[0]);
        }
        return DecisionTableInvocationVisitor.wrap(typeDef, value.build());
    }

    public ExpressionFactory.ExpCode visitPlaceholder(InvocationNode.Placeholder node, HdesTree ctx) {
        if (node instanceof InvocationNode.EmptyPlaceholder) {
            return this.visitEmptyPlaceholder((InvocationNode.EmptyPlaceholder)node, ctx);
        }
        if (node instanceof InvocationNode.NamedPlaceholder) {
            return this.visitNamedPlaceholder((InvocationNode.NamedPlaceholder)node, ctx);
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }

    public ExpressionFactory.ExpCode visitEmptyPlaceholder(InvocationNode.EmptyPlaceholder node, HdesTree ctx) {
        BodyNode.ScalarDef header = (BodyNode.ScalarDef)ctx.get().node(BodyNode.ScalarDef.class);
        String name = JavaSpecUtil.methodCall(header.getName());
        CodeBlock value = CodeBlock.builder().add("$L.$L", new Object[]{ACCESS_INPUT_VALUE, name + (header.getRequired() != false ? "" : ".get()")}).build();
        return DecisionTableInvocationVisitor.wrap((BodyNode.TypeDef)header, value);
    }

    public ExpressionFactory.ExpCode visitNamedPlaceholder(InvocationNode.NamedPlaceholder node, HdesTree ctx) {
        if (node.getValue().equals(ACCESS_CONSTANTS)) {
            BodyNode.TypeDef def = ctx.returns().build((HdesNode)node).getReturns();
            CodeBlock.Builder value = CodeBlock.builder().add(ACCESS_CONSTANTS, new Object[0]);
            if (ctx.getValue() instanceof ExpressionNode.LambdaExpression) {
                value.add(".getValues().stream()", new Object[0]);
            }
            return DecisionTableInvocationVisitor.wrap(def, value.build());
        }
        if (node.getValue().equals("matched")) {
            BodyNode.TypeDef def = ctx.returns().build((HdesNode)node).getReturns();
            CodeBlock.Builder value = CodeBlock.builder().add(ACCESS_OUTPUT_VALUE, new Object[0]);
            if (ctx.getValue() instanceof ExpressionNode.LambdaExpression) {
                value.add(".getValues().stream()", new Object[0]);
            }
            return DecisionTableInvocationVisitor.wrap(def, value.build());
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }

    protected static ExpressionFactory.ExpCode wrap(BodyNode.TypeDef typeDef, CodeBlock value) {
        if (typeDef instanceof BodyNode.ScalarDef) {
            BodyNode.ScalarDef scalarNode = (BodyNode.ScalarDef)typeDef;
            return ImmutableExpScalarCode.builder().type(scalarNode.getType()).array(typeDef.getArray()).value(value).build();
        }
        if (typeDef instanceof FlowNode.StepCallDef) {
            FlowNode.StepCallDef callDef = (FlowNode.StepCallDef)typeDef;
            ImmutableObjectDef type = ImmutableObjectDef.builder().from(typeDef).values((Iterable)callDef.getValues()).build();
            return ImmutableExpObjectCode.builder().array(typeDef.getArray()).type((BodyNode.ObjectDef)type).value(value).build();
        }
        BodyNode.ObjectDef type = (BodyNode.ObjectDef)typeDef;
        return ImmutableExpObjectCode.builder().array(typeDef.getArray()).type(type).value(value).build();
    }
}

