/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.expressions.invocation;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.DecisionTableNode;
import io.resys.hdes.ast.api.nodes.ExpressionNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.ast.api.visitors.ExpressionVisitor;
import io.resys.hdes.compiler.api.HdesCompilerException;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.expressions.ImmutableExpObjectCode;
import io.resys.hdes.compiler.spi.expressions.ImmutableExpScalarCode;
import io.resys.hdes.compiler.spi.expressions.invocation.DecisionTableInvocationVisitor;
import io.resys.hdes.compiler.spi.spec.JavaSpecUtil;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.spi.fl.GetTrace;
import java.util.Optional;

public class FlowInvocationVisitor
extends DecisionTableInvocationVisitor
implements ExpressionVisitor.InvocationVisitor<ExpressionFactory.ExpCode, ExpressionFactory.ExpCode> {
    public static final String ACCESS_INPUT_VALUE = "input";

    @Override
    public ExpressionFactory.ExpCode visitNested(InvocationNode.NestedInvocation node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        BodyNode.TypeDef pathDef = next.any().build(node.getPath());
        CodeBlock path = this.visitBody(node.getPath(), next).getValue();
        ExpressionFactory.ExpCode value = this.visitBody(node.getValue(), next.next((HdesNode)pathDef));
        CodeBlock code = CodeBlock.builder().add(path).add(value.getValue()).build();
        if (value instanceof ExpressionFactory.ExpScalarCode) {
            ExpressionFactory.ExpScalarCode src = (ExpressionFactory.ExpScalarCode)value;
            return ImmutableExpScalarCode.builder().type(src.getType()).array(src.getArray()).value(code).build();
        }
        ExpressionFactory.ExpObjectCode src = (ExpressionFactory.ExpObjectCode)value;
        return ImmutableExpObjectCode.builder().array(src.getArray()).type(src.getType()).value(code).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExpressionFactory.ExpCode visitSimple(InvocationNode.SimpleInvocation node, HdesTree ctx) {
        Optional lambda = ctx.find().node(ExpressionNode.LambdaExpression.class);
        BodyNode.TypeDef typeDef = ctx.any().build((InvocationNode)node);
        CodeBlock.Builder value = CodeBlock.builder();
        if (lambda.isPresent() && ((ExpressionNode.LambdaExpression)lambda.get()).getParam().getValue().equals(node.getValue())) {
            value.add("$L", new Object[]{node.getValue()});
            return FlowInvocationVisitor.wrap(typeDef, value.build());
        } else if (typeDef.getContext() == BodyNode.ContextTypeDef.STEP_RETURNS) {
            value.add("$T.from(parent).step($S)", new Object[]{ClassName.get(GetTrace.class), node.getValue()});
            BodyNode.ObjectDef returnDef = (BodyNode.ObjectDef)typeDef;
            if (returnDef.getValues().size() != 1) return FlowInvocationVisitor.wrap(typeDef, value.build());
            FlowNode.StepCallDef call = (FlowNode.StepCallDef)returnDef.getValues().get(0);
            String dependencyId = call.getCallDef().getId().getValue();
            BodyNode dependencyNode = ctx.getRoot().getBody(dependencyId);
            CompilerNode compilerNode = (CompilerNode)ctx.get().node(CompilerNode.class);
            if (dependencyNode instanceof DecisionTableNode.DecisionTableBody) {
                CompilerNode.DecisionTableUnit unit = compilerNode.dt((DecisionTableNode.DecisionTableBody)dependencyNode);
                value.add(".body($T.class)", new Object[]{unit.getType().getReturns().getName()});
                return FlowInvocationVisitor.wrap(typeDef, value.build());
            } else if (dependencyNode instanceof FlowNode.FlowBody) {
                CompilerNode.FlowUnit unit = compilerNode.fl((FlowNode.FlowBody)dependencyNode);
                value.add(".body($T.class)", new Object[]{unit.getType().getReturns().getName()});
                return FlowInvocationVisitor.wrap(typeDef, value.build());
            } else {
                if (!(dependencyNode instanceof ServiceNode.ServiceBody)) throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
                CompilerNode.ServiceUnit unit = compilerNode.st((ServiceNode.ServiceBody)dependencyNode);
                value.add(".body($T.class)", new Object[]{unit.getType().getReturns().getName()});
            }
            return FlowInvocationVisitor.wrap(typeDef, value.build());
        } else if (typeDef.getContext() == BodyNode.ContextTypeDef.STEP_AS) {
            CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
            FlowNode.FlowBody flow = (FlowNode.FlowBody)ctx.get().node(FlowNode.FlowBody.class);
            FlowNode.Step step = (FlowNode.Step)ctx.step().findStep(node.getValue(), flow.getStep()).get();
            value.add("$T.from(parent).step($S)", new Object[]{ClassName.get(GetTrace.class), node.getValue()}).add(".body($T.class)", new Object[]{unit.getEndAs(step).getName()});
            return FlowInvocationVisitor.wrap(typeDef, value.build());
        } else if (typeDef.getContext() == BodyNode.ContextTypeDef.ACCEPTS) {
            value.add("$T.from(parent).step($S)", new Object[]{ClassName.get(GetTrace.class), ACCESS_INPUT_VALUE}).add(".body($T.class)", new Object[]{((CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class)).getType().getAccepts().getName()}).add(".$L$L", new Object[]{JavaSpecUtil.methodCall(typeDef.getName()), typeDef.getRequired() != false ? "" : ".get()"});
            return FlowInvocationVisitor.wrap(typeDef, value.build());
        } else {
            if (typeDef.getContext() == BodyNode.ContextTypeDef.STEP_END) return FlowInvocationVisitor.wrap(typeDef, value.build());
            if (typeDef.getContext() == BodyNode.ContextTypeDef.RETURNS) {
                value.add("." + JavaSpecUtil.methodCall(typeDef.getName()) + (typeDef.getRequired() != false ? "" : ".get()"), new Object[0]);
                return FlowInvocationVisitor.wrap(typeDef, value.build());
            } else {
                if (typeDef.getContext() != BodyNode.ContextTypeDef.EXPRESSION) return FlowInvocationVisitor.wrap(typeDef, value.build());
                value.add("." + JavaSpecUtil.methodCall(typeDef.getName()) + (typeDef.getRequired() != false ? "" : ".get()"), new Object[0]);
            }
        }
        return FlowInvocationVisitor.wrap(typeDef, value.build());
    }

    @Override
    public ExpressionFactory.ExpCode visitPlaceholder(InvocationNode.Placeholder node, HdesTree ctx) {
        if (node instanceof InvocationNode.EmptyPlaceholder) {
            return this.visitEmptyPlaceholder((InvocationNode.EmptyPlaceholder)node, ctx);
        }
        if (node instanceof InvocationNode.NamedPlaceholder) {
            return this.visitNamedPlaceholder((InvocationNode.NamedPlaceholder)node, ctx);
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }

    @Override
    public ExpressionFactory.ExpCode visitEmptyPlaceholder(InvocationNode.EmptyPlaceholder node, HdesTree ctx) {
        Optional iteratorTree = ctx.find().ctx(FlowNode.IterateAction.class);
        if (iteratorTree.isPresent()) {
            FlowNode.Step iteratorStep = (FlowNode.Step)((HdesTree)iteratorTree.get()).get().node(FlowNode.Step.class);
            FlowNode.IterateAction action = (FlowNode.IterateAction)iteratorStep.getAction();
            BodyNode.TypeDef iteratorType = ctx.next((HdesNode)iteratorStep).next((HdesNode)action).returns().build((HdesNode)action.getOver()).getReturns();
            CodeBlock value = CodeBlock.builder().add("$T.from(parent).step($S).body($T.class)", new Object[]{ClassName.get(GetTrace.class), iteratorStep.getId().getValue(), this.toCompilerType(iteratorType, ctx)}).build();
            return FlowInvocationVisitor.wrap(iteratorType, value);
        }
        Optional step = ctx.find().node(FlowNode.Step.class);
        if (step.isPresent()) {
            HdesTree.TypeDefReturns returns = ctx.returns().build((HdesNode)node);
            FlowNode.StepAction action = ((FlowNode.Step)step.get()).getAction();
            if (action instanceof FlowNode.CallAction) {
                CodeBlock value = CodeBlock.builder().add("call.getBody()", new Object[0]).build();
                return FlowInvocationVisitor.wrap(returns.getReturns(), value);
            }
            if (action instanceof FlowNode.IterateAction) {
                FlowNode.IterateAction iterate = (FlowNode.IterateAction)action;
                if (iterate.getNested().booleanValue()) {
                    CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
                    CodeBlock value = CodeBlock.builder().add("mappedTo.stream().map(trace -> $T.from(trace).body($T.class))", new Object[]{GetTrace.class, unit.getEndAs((FlowNode.Step)step.get()).getName()}).build();
                    return FlowInvocationVisitor.wrap(returns.getReturns(), value);
                }
                FlowNode.CallAction iterateOverAction = (FlowNode.CallAction)((FlowNode.Step)iterate.getStep().get()).getAction();
                if (iterateOverAction.getCalls().size() == 1) {
                    Object unit;
                    FlowNode.CallDef call = (FlowNode.CallDef)iterateOverAction.getCalls().get(0);
                    String dependencyId = call.getId().getValue();
                    BodyNode dependencyNode = ctx.getRoot().getBody(dependencyId);
                    CompilerNode compilerNode = (CompilerNode)ctx.get().node(CompilerNode.class);
                    CompilerNode.CompilerType type = null;
                    if (dependencyNode instanceof DecisionTableNode.DecisionTableBody) {
                        unit = compilerNode.dt((DecisionTableNode.DecisionTableBody)dependencyNode);
                        type = unit.getType();
                    } else if (dependencyNode instanceof FlowNode.FlowBody) {
                        unit = compilerNode.fl((FlowNode.FlowBody)dependencyNode);
                        type = unit.getType();
                    } else if (dependencyNode instanceof ServiceNode.ServiceBody) {
                        unit = compilerNode.st((ServiceNode.ServiceBody)dependencyNode);
                        type = unit.getType();
                    } else {
                        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
                    }
                    CodeBlock value = CodeBlock.builder().add("mappedTo.stream().map(trace -> $T.from(trace).body($T.class))", new Object[]{GetTrace.class, type.getReturns().getName()}).build();
                    return FlowInvocationVisitor.wrap(returns.getReturns(), value);
                }
            }
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }

    @Override
    public ExpressionFactory.ExpCode visitNamedPlaceholder(InvocationNode.NamedPlaceholder node, HdesTree ctx) {
        Optional step = ctx.find().node(FlowNode.Step.class);
        if (step.isEmpty()) {
            throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
        }
        HdesTree.TypeDefReturns returns = ctx.returns().build((HdesNode)node);
        FlowNode.StepAction action = ((FlowNode.Step)step.get()).getAction();
        if (!(action instanceof FlowNode.CallAction)) {
            throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
        }
        FlowNode.CallAction calls = (FlowNode.CallAction)action;
        if (calls.getCalls().size() == 1) {
            CodeBlock value = CodeBlock.builder().add("call.getBody().$L()", new Object[]{JavaSpecUtil.getMethodName(node.getValue())}).build();
            return FlowInvocationVisitor.wrap(returns.getReturns(), value);
        }
        try {
            int index = Integer.parseInt(node.getValue());
            Optional<FlowNode.CallDef> call = calls.getCalls().stream().filter(c -> ((Integer)c.getIndex().get()).equals(index)).findFirst();
            if (call.isPresent()) {
                CodeBlock value = CodeBlock.builder().add("call$L.getBody()", new Object[]{index}).build();
                return FlowInvocationVisitor.wrap(returns.getReturns(), value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }

    private ClassName toCompilerType(BodyNode.TypeDef node, HdesTree ctx) {
        if (node instanceof BodyNode.ScalarDef) {
            BodyNode.ScalarDef scalar = (BodyNode.ScalarDef)node;
            return ClassName.get(JavaSpecUtil.type(scalar.getType()));
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }
}

