/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.expressions.visitors;

import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.ExpressionNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.ImmutableEqualityOperation;
import io.resys.hdes.ast.api.nodes.ImmutableObjectDef;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.visitors.ExpressionVisitor;
import io.resys.hdes.compiler.api.HdesCompilerException;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.expressions.ImmutableExpObjectCode;
import io.resys.hdes.compiler.spi.expressions.ImmutableExpScalarCode;
import io.resys.hdes.compiler.spi.expressions.visitors.ScalarConverter;
import io.resys.hdes.compiler.spi.spec.JavaSpecUtil;
import io.resys.hdes.executor.spi.operations.HdesOperationsGen;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GenericExpressionVisitor
implements ExpressionVisitor<ExpressionFactory.ExpCode, ExpressionFactory.ExpCode>,
ExpressionFactory.ExpressionCallback {
    public static final String ACCESS_SRC_VALUE = "src";
    public static final List<String> GLOBAL_METHODS = Arrays.asList("min", "max", "sum", "avg");
    public static final List<String> LAMBDA_METHODS = Arrays.asList("map");
    private final ExpressionVisitor.InvocationVisitor<ExpressionFactory.ExpCode, ExpressionFactory.ExpCode> resolver;

    public GenericExpressionVisitor(ExpressionVisitor.InvocationVisitor<ExpressionFactory.ExpCode, ExpressionFactory.ExpCode> resolver) {
        this.resolver = resolver;
    }

    public ExpressionFactory.ExpScalarCode visitBody(ExpressionNode.ExpressionBody node, HdesTree ctx) {
        return this.visitScalar(node.getValue(), ctx);
    }

    public ExpressionFactory.ExpScalarCode visitLiteral(BodyNode.Literal node, HdesTree ctx) {
        CodeBlock.Builder builder = CodeBlock.builder();
        switch (node.getType()) {
            case BOOLEAN: {
                builder.add(node.getValue(), new Object[0]);
                break;
            }
            case DATE: {
                builder.add("$T.parse($S)", new Object[]{LocalDate.class, node.getValue()});
                break;
            }
            case DATETIME: {
                builder.add("$T.parse($S)", new Object[]{LocalDateTime.class, node.getValue()});
                break;
            }
            case TIME: {
                builder.add("$T.parse($S)", new Object[]{LocalTime.class, node.getValue()});
                break;
            }
            case DECIMAL: {
                builder.add("new $T($S)", new Object[]{BigDecimal.class, node.getValue()});
                break;
            }
            case INTEGER: {
                builder.add("$L", new Object[]{node.getValue()});
                break;
            }
            case STRING: {
                builder.add("$S", new Object[]{node.getValue()});
                break;
            }
            default: {
                throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
            }
        }
        return ImmutableExpScalarCode.builder().value(builder.build()).array(false).type(node.getType()).build();
    }

    public ExpressionFactory.ExpScalarCode visitNot(ExpressionNode.NotUnary node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode children = this.visitScalar(node.getValue(), ctx);
        return ImmutableExpScalarCode.builder().type(BodyNode.ScalarType.BOOLEAN).array(false).value(CodeBlock.builder().add("!", new Object[0]).add(children.getValue()).build()).build();
    }

    public ExpressionFactory.ExpScalarCode visitNegate(ExpressionNode.NegateUnary node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode spec = this.visitScalar(node.getValue(), ctx);
        CodeBlock.Builder value = CodeBlock.builder();
        if (spec.getType() == BodyNode.ScalarType.DECIMAL) {
            value.add("$L.negate()", new Object[]{spec.getValue()});
        } else if (spec.getType() == BodyNode.ScalarType.INTEGER) {
            value.add("-$L", new Object[]{spec.getValue()});
        } else {
            throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
        }
        return ImmutableExpScalarCode.builder().value(value.build()).type(spec.getType()).build();
    }

    public ExpressionFactory.ExpScalarCode visitPositive(ExpressionNode.PositiveUnary node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode spec = this.visitScalar(node.getValue(), ctx);
        CodeBlock.Builder value = CodeBlock.builder();
        if (spec.getType() == BodyNode.ScalarType.DECIMAL) {
            value.add("$L.plus()", new Object[]{spec.getValue()});
        } else if (spec.getType() == BodyNode.ScalarType.INTEGER) {
            value.add("+$L", new Object[]{spec.getValue()});
        } else {
            throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
        }
        return ImmutableExpScalarCode.builder().value(value.build()).type(spec.getType()).build();
    }

    public ExpressionFactory.ExpCode visitInvocation(InvocationNode node, HdesTree ctx) {
        return (ExpressionFactory.ExpCode)this.resolver.visitBody(node, ctx);
    }

    public ExpressionFactory.ExpCode visitMethod(ExpressionNode.CallMethodExpression node, HdesTree ctx) {
        if (node instanceof ExpressionNode.LambdaExpression) {
            return this.visitLambda((ExpressionNode.LambdaExpression)node, ctx);
        }
        if (node instanceof ExpressionNode.StaticMethodExpression) {
            return this.visitMathMethod((ExpressionNode.StaticMethodExpression)node, ctx);
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
    }

    public ExpressionFactory.ExpCode visitLambda(ExpressionNode.LambdaExpression node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        ExpressionFactory.ExpCode type = this.visitAny((HdesNode)node.getType(), next);
        BodyNode.TypeDef mapOrigin = ctx.any().build(node.getType());
        ImmutableObjectDef mapSource = ImmutableObjectDef.builder().from(mapOrigin).addAllValues(mapOrigin instanceof FlowNode.StepCallDef ? ((FlowNode.StepCallDef)mapOrigin).getValues() : Collections.emptyList()).name(node.getParam().getValue()).array(Boolean.valueOf(false)).build();
        next = next.next((HdesNode)mapSource);
        ExpressionFactory.ExpCode body = this.visitAny(node.getBody(), next);
        CodeBlock value = CodeBlock.builder().add("$L.map($L -> $L).collect($T.toList())", new Object[]{type.getValue(), this.visitAny((HdesNode)node.getParam(), next).getValue(), body.getValue(), Collectors.class}).build();
        if (body instanceof ExpressionFactory.ExpScalarCode) {
            ExpressionFactory.ExpScalarCode spec = (ExpressionFactory.ExpScalarCode)body;
            return ImmutableExpScalarCode.builder().from(spec).value(value).build();
        }
        ExpressionFactory.ExpObjectCode spec = (ExpressionFactory.ExpObjectCode)body;
        return ImmutableExpObjectCode.builder().from(spec).value(value).build();
    }

    public ExpressionFactory.ExpCode visitMathMethod(ExpressionNode.StaticMethodExpression node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder params = CodeBlock.builder().add("$T.get().math()", new Object[]{HdesOperationsGen.class});
        boolean isDecimal = false;
        block6: for (HdesNode ast : node.getValues()) {
            ExpressionFactory.ExpCode runningValue;
            ExpressionFactory.ExpCode spec = this.visitAny(ast, next);
            if (spec instanceof ExpressionFactory.ExpScalarCode) {
                runningValue = (ExpressionFactory.ExpScalarCode)spec;
                if (runningValue.getType() == BodyNode.ScalarType.INTEGER) {
                    params.add(".integer($L)", new Object[]{runningValue.getValue()});
                    continue;
                }
                if (runningValue.getType() != BodyNode.ScalarType.DECIMAL) continue;
                params.add(".decimal($L)", new Object[]{runningValue.getValue()});
                isDecimal = true;
                continue;
            }
            runningValue = (ExpressionFactory.ExpObjectCode)spec;
            for (BodyNode.TypeDef typeDefNode : runningValue.getType().getValues()) {
                if (!(typeDefNode instanceof BodyNode.ScalarDef)) continue;
                BodyNode.ScalarType scalar = ((BodyNode.ScalarDef)typeDefNode).getType();
                if (typeDefNode.getName().isEmpty()) {
                    if (scalar == BodyNode.ScalarType.INTEGER) {
                        params.add(".integer($L)", new Object[]{runningValue.getValue()});
                        continue block6;
                    }
                    if (scalar != BodyNode.ScalarType.DECIMAL) continue block6;
                    params.add(".decimal($L)", new Object[]{runningValue.getValue()});
                    isDecimal = true;
                    continue block6;
                }
                String name = JavaSpecUtil.methodCall(typeDefNode.getName());
                if (scalar == BodyNode.ScalarType.INTEGER) {
                    params.add(".integer($L.$L)", new Object[]{runningValue.getValue(), name});
                    continue;
                }
                if (scalar != BodyNode.ScalarType.DECIMAL) continue;
                params.add(".decimal($L.$L)", new Object[]{runningValue.getValue(), name});
                isDecimal = true;
            }
        }
        if (isDecimal) {
            params.add(".toDecimal()", new Object[0]);
        } else {
            params.add(".toInteger()", new Object[0]);
        }
        BodyNode.ScalarType returnType = isDecimal || node.getType() == InvocationNode.StaticMethodType.AVG ? BodyNode.ScalarType.DECIMAL : BodyNode.ScalarType.INTEGER;
        String method = "";
        switch (node.getType()) {
            case AVG: {
                method = "avg";
                break;
            }
            case MIN: {
                method = "min";
                break;
            }
            case MAX: {
                method = "max";
                break;
            }
            case SUM: {
                method = "sum";
                break;
            }
            default: {
                throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
            }
        }
        return ImmutableExpScalarCode.builder().value(params.add(".$L()", new Object[]{method}).build()).array(false).type(returnType).build();
    }

    public ExpressionFactory.ExpCode visitIn(ExpressionNode.InExpression node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        CodeBlock.Builder body = CodeBlock.builder().add("(", new Object[0]);
        int index = 0;
        for (HdesNode right : node.getRight()) {
            ImmutableEqualityOperation equality = ImmutableEqualityOperation.builder().token(node.getToken()).left(node.getLeft()).right(right).type(ExpressionNode.EqualityType.EQUAL).build();
            if (index > 0) {
                body.add(" || ", new Object[0]);
            }
            body.add(this.visitEquality((ExpressionNode.EqualityOperation)equality, next).getValue());
            ++index;
        }
        return ImmutableExpScalarCode.builder().value(body.add(")", new Object[0]).build()).array(false).type(BodyNode.ScalarType.BOOLEAN).build();
    }

    public ExpressionFactory.ExpScalarCode visitEquality(ExpressionNode.EqualityOperation node, HdesTree ctx) {
        ScalarConverter.ScalarConverterCode betweenSpec = ScalarConverter.builder().src((HdesNode)node).value1(this.visitScalar(node.getLeft(), ctx)).value2(this.visitScalar(node.getRight(), ctx)).build();
        BodyNode.ScalarType commonType = betweenSpec.getType();
        CodeBlock left = betweenSpec.getValue1();
        CodeBlock right = betweenSpec.getValue2();
        CodeBlock.Builder body = CodeBlock.builder();
        switch (commonType) {
            case DECIMAL: {
                if (node.getType() == ExpressionNode.EqualityType.EQUAL) {
                    body.add("$L.compareTo($L) == 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.NOTEQUAL) {
                    body.add("$L.compareTo($L) != 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.LESS) {
                    body.add("$L.compareTo($L) < 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.LESS_THEN) {
                    body.add("$L.compareTo($L) <= 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.GREATER) {
                    body.add("$L.compareTo($L) > 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() != ExpressionNode.EqualityType.GREATER_THEN) break;
                body.add("$L.compareTo($L) >= 0", new Object[]{left, right});
                break;
            }
            case INTEGER: {
                if (node.getType() == ExpressionNode.EqualityType.EQUAL) {
                    body.add("Integer.compare($L, $L) == 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.NOTEQUAL) {
                    body.add("Integer.compare($L, $L) != 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.LESS) {
                    body.add("Integer.compare($L, $L) < 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.LESS_THEN) {
                    body.add("Integer.compare($L, $L) <= 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.GREATER) {
                    body.add("Integer.compare($L, $L) > 0", new Object[]{left, right});
                    break;
                }
                if (node.getType() != ExpressionNode.EqualityType.GREATER_THEN) break;
                body.add("Integer.compare($L, $L) >= 0", new Object[]{left, right});
                break;
            }
            case DATE: 
            case DATETIME: 
            case TIME: {
                if (node.getType() == ExpressionNode.EqualityType.EQUAL) {
                    body.add("$L.isEqual($L)", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.NOTEQUAL) {
                    body.add("!$L.isEqual($L)", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.LESS) {
                    body.add("$L.isBefore($L)", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.LESS_THEN) {
                    body.add("($L.isBefore($L) || $L.isEqual($L))", new Object[]{left, right, left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.GREATER) {
                    body.add("$L.isAfter($L)", new Object[]{left, right});
                    break;
                }
                if (node.getType() != ExpressionNode.EqualityType.GREATER_THEN) break;
                body.add("($L.isAfter($L) || $L.isEqual($L))", new Object[]{left, right, left, right});
                break;
            }
            case STRING: {
                if (node.getType() == ExpressionNode.EqualityType.EQUAL) {
                    body.add("$L.equals($L)", new Object[]{left, right});
                    break;
                }
                if (node.getType() == ExpressionNode.EqualityType.NOTEQUAL) {
                    body.add("!$L.equals($L)", new Object[]{left, right});
                    break;
                }
            }
            default: {
                throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
            }
        }
        return ImmutableExpScalarCode.builder().value(body.build()).array(false).type(commonType).build();
    }

    public ExpressionFactory.ExpScalarCode visitMultiplicative(ExpressionNode.MultiplicativeExpression node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode left = this.visitScalar(node.getLeft(), ctx);
        ExpressionFactory.ExpScalarCode right = this.visitScalar(node.getRight(), ctx);
        ScalarConverter.ScalarConverterCode spec = ScalarConverter.builder().src((HdesNode)node).value1(left).value2(right).build();
        CodeBlock.Builder value = CodeBlock.builder();
        if (spec.getType() == BodyNode.ScalarType.DECIMAL) {
            value.add("$L.$L($L)", new Object[]{spec.getValue1(), node.getType() == ExpressionNode.MultiplicativeType.MULTIPLY ? "multiply" : "divide", spec.getValue2()});
        } else if (node.getType() == ExpressionNode.MultiplicativeType.MULTIPLY) {
            value.add("$L * $L", new Object[]{spec.getValue1(), spec.getValue2()});
        } else {
            value.add("new $T($L).divide(new $T($L)))", new Object[]{BigDecimal.class, spec.getValue1(), BigDecimal.class, spec.getValue2()});
        }
        return ImmutableExpScalarCode.builder().value(value.build()).type(spec.getType()).build();
    }

    public ExpressionFactory.ExpScalarCode visitAdditive(ExpressionNode.AdditiveExpression node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode left = this.visitScalar(node.getLeft(), ctx);
        ExpressionFactory.ExpScalarCode right = this.visitScalar(node.getRight(), ctx);
        ScalarConverter.ScalarConverterCode spec = ScalarConverter.builder().src((HdesNode)node).value1(left).value2(right).build();
        CodeBlock.Builder value = CodeBlock.builder();
        if (spec.getType() == BodyNode.ScalarType.DECIMAL) {
            value.add("$L.$L($L)", new Object[]{spec.getValue1(), node.getType() == ExpressionNode.AdditiveType.ADD ? "add" : "subtract", spec.getValue2()});
        } else {
            value.add("$L $L $L", new Object[]{spec.getValue1(), node.getType() == ExpressionNode.AdditiveType.ADD ? "+" : "-", spec.getValue2()});
        }
        return ImmutableExpScalarCode.builder().value(value.build()).array(false).type(spec.getType()).build();
    }

    public ExpressionFactory.ExpScalarCode visitAnd(ExpressionNode.AndExpression node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode left = this.visitScalar(node.getLeft(), ctx);
        ExpressionFactory.ExpScalarCode right = this.visitScalar(node.getRight(), ctx);
        return ImmutableExpScalarCode.builder().array(false).type(BodyNode.ScalarType.BOOLEAN).value(CodeBlock.builder().add(left.getValue()).add(" && ", new Object[0]).add(right.getValue()).build()).build();
    }

    public ExpressionFactory.ExpScalarCode visitOr(ExpressionNode.OrExpression node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode left = this.visitScalar(node.getLeft(), ctx);
        ExpressionFactory.ExpScalarCode right = this.visitScalar(node.getRight(), ctx);
        return ImmutableExpScalarCode.builder().array(false).type(BodyNode.ScalarType.BOOLEAN).value(CodeBlock.builder().add(left.getValue()).add(" || ", new Object[0]).add(right.getValue()).build()).build();
    }

    public ExpressionFactory.ExpScalarCode visitConditional(ExpressionNode.ConditionalExpression node, HdesTree ctx) {
        ExpressionFactory.ExpScalarCode condition = this.visitScalar((HdesNode)node.getOperation(), ctx);
        ScalarConverter.ScalarConverterCode conversion = ScalarConverter.builder().src((HdesNode)node).value1(this.visitScalar(node.getLeft(), ctx)).value2(this.visitScalar(node.getRight(), ctx)).build();
        return ImmutableExpScalarCode.builder().type(conversion.getType()).array(false).value(CodeBlock.builder().add(condition.getValue()).add("?", new Object[0]).add(conversion.getValue1()).add(":", new Object[0]).add(conversion.getValue2()).build()).type(conversion.getType()).build();
    }

    public ExpressionFactory.ExpScalarCode visitBetween(ExpressionNode.BetweenExpression node, HdesTree ctx) {
        ScalarConverter.ScalarConverterCode betweenSpec = ScalarConverter.builder().src((HdesNode)node).value1(this.visitScalar(node.getLeft(), ctx)).value2(this.visitScalar(node.getRight(), ctx)).build();
        ExpressionFactory.ExpScalarCode valueSpec = this.visitScalar(node.getValue(), ctx);
        BodyNode.ScalarType commonType = betweenSpec.getType();
        CodeBlock left = betweenSpec.getValue1();
        CodeBlock right = betweenSpec.getValue2();
        CodeBlock value = valueSpec.getValue();
        if (valueSpec.getType() != betweenSpec.getType()) {
            ScalarConverter.ScalarConverterCode conversion1 = ScalarConverter.builder().src((HdesNode)node).value1(valueSpec).value2(ImmutableExpScalarCode.builder().type(betweenSpec.getType()).value(left).build()).build();
            value = conversion1.getValue1();
            left = conversion1.getValue2();
            ScalarConverter.ScalarConverterCode conversion2 = ScalarConverter.builder().src((HdesNode)node).value1(ImmutableExpScalarCode.builder().type(conversion1.getType()).value(value).build()).value2(ImmutableExpScalarCode.builder().type(betweenSpec.getType()).value(right).build()).build();
            commonType = conversion2.getType();
            right = conversion2.getValue2();
        }
        CodeBlock.Builder leftBuilder = CodeBlock.builder();
        CodeBlock.Builder rightBuilder = CodeBlock.builder();
        switch (commonType) {
            case DECIMAL: {
                leftBuilder.add("$L.compareTo($L) <= 0", new Object[]{left, value});
                rightBuilder.add("$L.compareTo($L) >= 0", new Object[]{right, value});
                break;
            }
            case INTEGER: {
                leftBuilder.add("Integer.compare($L, $L) <= 0", new Object[]{left, value});
                rightBuilder.add("Integer.compare($L, $L) >= 0", new Object[]{right, value});
                break;
            }
            case DATE: 
            case DATETIME: 
            case TIME: {
                leftBuilder.add("($L.isBefore($L) || $L.isEqual($L))", new Object[]{left, value, left, value});
                rightBuilder.add("($L.isAfter($L) || $L.isEqual($L))", new Object[]{right, value, right, value});
                break;
            }
            default: {
                throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression((HdesNode)node));
            }
        }
        return ImmutableExpScalarCode.builder().value(CodeBlock.builder().add(leftBuilder.build()).add(" && ", new Object[0]).add(rightBuilder.build()).build()).array(false).type(commonType).build();
    }

    private ExpressionFactory.ExpScalarCode visitScalar(HdesNode node, HdesTree ctx) {
        ExpressionFactory.ExpCode result = this.visitAny(node, ctx);
        if (result instanceof ExpressionFactory.ExpScalarCode) {
            return (ExpressionFactory.ExpScalarCode)result;
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression(node));
    }

    @Override
    public ExpressionFactory.ExpCode visitAny(HdesNode node, HdesTree ctx) {
        if (node instanceof InvocationNode) {
            return this.visitInvocation((InvocationNode)node, ctx);
        }
        if (node instanceof ExpressionNode.CallMethodExpression) {
            return this.visitMethod((ExpressionNode.CallMethodExpression)node, ctx);
        }
        if (node instanceof BodyNode.Literal) {
            return this.visitLiteral((BodyNode.Literal)node, ctx);
        }
        if (node instanceof ExpressionNode.NotUnary) {
            return this.visitNot((ExpressionNode.NotUnary)node, ctx);
        }
        if (node instanceof ExpressionNode.NegateUnary) {
            return this.visitNegate((ExpressionNode.NegateUnary)node, ctx);
        }
        if (node instanceof ExpressionNode.PositiveUnary) {
            return this.visitPositive((ExpressionNode.PositiveUnary)node, ctx);
        }
        if (node instanceof ExpressionNode.EqualityOperation) {
            return this.visitEquality((ExpressionNode.EqualityOperation)node, ctx);
        }
        if (node instanceof ExpressionNode.AndExpression) {
            return this.visitAnd((ExpressionNode.AndExpression)node, ctx);
        }
        if (node instanceof ExpressionNode.OrExpression) {
            return this.visitOr((ExpressionNode.OrExpression)node, ctx);
        }
        if (node instanceof ExpressionNode.InExpression) {
            return this.visitIn((ExpressionNode.InExpression)node, ctx);
        }
        if (node instanceof ExpressionNode.ConditionalExpression) {
            return this.visitConditional((ExpressionNode.ConditionalExpression)node, ctx);
        }
        if (node instanceof ExpressionNode.BetweenExpression) {
            return this.visitBetween((ExpressionNode.BetweenExpression)node, ctx);
        }
        if (node instanceof ExpressionNode.AdditiveExpression) {
            return this.visitAdditive((ExpressionNode.AdditiveExpression)node, ctx);
        }
        if (node instanceof ExpressionNode.MultiplicativeExpression) {
            return this.visitMultiplicative((ExpressionNode.MultiplicativeExpression)node, ctx);
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression(node));
    }
}

