/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.expressions.visitors;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.compiler.spi.expressions.visitors.ScalarConverter;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ScalarConverter.ScalarConverterCode", generator="Immutables")
@Immutable
public final class ImmutableScalarConverterCode
implements ScalarConverter.ScalarConverterCode {
    private final CodeBlock value1;
    private final CodeBlock value2;
    private final BodyNode.ScalarType type;

    private ImmutableScalarConverterCode(CodeBlock value1, CodeBlock value2, BodyNode.ScalarType type) {
        this.value1 = value1;
        this.value2 = value2;
        this.type = type;
    }

    @Override
    public CodeBlock getValue1() {
        return this.value1;
    }

    @Override
    public CodeBlock getValue2() {
        return this.value2;
    }

    @Override
    public BodyNode.ScalarType getType() {
        return this.type;
    }

    public final ImmutableScalarConverterCode withValue1(CodeBlock value) {
        if (this.value1 == value) {
            return this;
        }
        CodeBlock newValue = Objects.requireNonNull(value, "value1");
        return new ImmutableScalarConverterCode(newValue, this.value2, this.type);
    }

    public final ImmutableScalarConverterCode withValue2(CodeBlock value) {
        if (this.value2 == value) {
            return this;
        }
        CodeBlock newValue = Objects.requireNonNull(value, "value2");
        return new ImmutableScalarConverterCode(this.value1, newValue, this.type);
    }

    public final ImmutableScalarConverterCode withType(BodyNode.ScalarType value) {
        if (this.type == value) {
            return this;
        }
        BodyNode.ScalarType newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableScalarConverterCode(this.value1, this.value2, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScalarConverterCode && this.equalTo((ImmutableScalarConverterCode)another);
    }

    private boolean equalTo(ImmutableScalarConverterCode another) {
        return this.value1.equals((Object)another.value1) && this.value2.equals((Object)another.value2) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value1.hashCode();
        h += (h << 5) + this.value2.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ScalarConverterCode").omitNullValues().add("value1", (Object)this.value1).add("value2", (Object)this.value2).add("type", (Object)this.type).toString();
    }

    public static ImmutableScalarConverterCode copyOf(ScalarConverter.ScalarConverterCode instance) {
        if (instance instanceof ImmutableScalarConverterCode) {
            return (ImmutableScalarConverterCode)instance;
        }
        return ImmutableScalarConverterCode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ScalarConverter.ScalarConverterCode", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE1 = 1L;
        private static final long INIT_BIT_VALUE2 = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private CodeBlock value1;
        @Nullable
        private CodeBlock value2;
        @Nullable
        private BodyNode.ScalarType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScalarConverter.ScalarConverterCode instance) {
            Objects.requireNonNull(instance, "instance");
            this.value1(instance.getValue1());
            this.value2(instance.getValue2());
            this.type(instance.getType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value1(CodeBlock value1) {
            this.value1 = Objects.requireNonNull(value1, "value1");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value2(CodeBlock value2) {
            this.value2 = Objects.requireNonNull(value2, "value2");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(BodyNode.ScalarType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableScalarConverterCode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScalarConverterCode(this.value1, this.value2, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value1");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value2");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ScalarConverterCode, some of required attributes are not set " + attributes;
        }
    }
}

