/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.expressions.visitors;

import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.spi.util.Assertions;
import io.resys.hdes.compiler.api.HdesCompilerException;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.expressions.ImmutableExpScalarCode;
import io.resys.hdes.compiler.spi.expressions.visitors.ImmutableScalarConverterCode;
import io.resys.hdes.compiler.spi.spec.JavaSpecUtil;
import java.math.BigDecimal;
import java.util.function.Function;
import org.immutables.value.Value;

public class ScalarConverter {
    private HdesNode src;
    private ExpressionFactory.ExpScalarCode value1;
    private ExpressionFactory.ExpScalarCode value2;

    private static boolean stringType(BodyNode.ScalarType t) {
        return t == BodyNode.ScalarType.STRING;
    }

    private static boolean temporalType(BodyNode.ScalarType t) {
        return t == BodyNode.ScalarType.DATE || t == BodyNode.ScalarType.DATETIME || t == BodyNode.ScalarType.TIME;
    }

    private static boolean isDecimalConvert(BodyNode.ScalarType type1, BodyNode.ScalarType type2) {
        Function<BodyNode.ScalarType, Boolean> intOrDecimal = t -> t == BodyNode.ScalarType.INTEGER || t == BodyNode.ScalarType.DECIMAL;
        return intOrDecimal.apply(type1) != false && intOrDecimal.apply(type2) != false;
    }

    private static boolean isTemporalConvert(BodyNode.ScalarType type1, BodyNode.ScalarType type2) {
        return ScalarConverter.stringType(type1) && ScalarConverter.temporalType(type2) || ScalarConverter.stringType(type2) && ScalarConverter.temporalType(type1);
    }

    public static ScalarConverter builder() {
        return new ScalarConverter();
    }

    public ScalarConverter src(HdesNode src) {
        this.src = src;
        return this;
    }

    public ScalarConverter value1(ExpressionFactory.ExpScalarCode value1) {
        this.value1 = value1;
        return this;
    }

    public ScalarConverter value1(CodeBlock value1, BodyNode.ScalarType type) {
        this.value1 = ImmutableExpScalarCode.builder().value(value1).array(false).type(type).build();
        return this;
    }

    public ScalarConverter value2(ExpressionFactory.ExpScalarCode value2) {
        this.value2 = value2;
        return this;
    }

    public ScalarConverter value2(CodeBlock value2, BodyNode.ScalarType type) {
        this.value2 = ImmutableExpScalarCode.builder().value(value2).array(false).type(type).build();
        return this;
    }

    public ScalarConverterCode build() {
        Assertions.notNull((Object)this.src, () -> "src side can't be null!");
        Assertions.notNull((Object)this.value1, () -> "left side can't be null!");
        Assertions.notNull((Object)this.value2, () -> "right side can't be null!");
        if (this.value1.getType() == this.value2.getType()) {
            return ImmutableScalarConverterCode.builder().type(this.value1.getType()).value1(this.value1.getValue()).value2(this.value2.getValue()).build();
        }
        if (ScalarConverter.isDecimalConvert(this.value1.getType(), this.value2.getType())) {
            CodeBlock value2;
            CodeBlock value1;
            if (this.value1.getType() == BodyNode.ScalarType.INTEGER) {
                value1 = CodeBlock.builder().add("new $T(", new Object[]{BigDecimal.class}).add(this.value1.getValue()).add(")", new Object[0]).build();
                value2 = this.value2.getValue();
            } else {
                value1 = this.value1.getValue();
                value2 = CodeBlock.builder().add("new $T(", new Object[]{BigDecimal.class}).add(this.value2.getValue()).add(")", new Object[0]).build();
            }
            return ImmutableScalarConverterCode.builder().type(BodyNode.ScalarType.DECIMAL).value1(value1).value2(value2).build();
        }
        if (ScalarConverter.isTemporalConvert(this.value1.getType(), this.value2.getType())) {
            BodyNode.ScalarType type;
            CodeBlock value2;
            CodeBlock value1;
            if (this.value1.getType() == BodyNode.ScalarType.STRING) {
                Class<?> temporalType = JavaSpecUtil.type(this.value2.getType());
                value1 = CodeBlock.builder().add("$T.parse($L)", new Object[]{temporalType, this.value1.getValue()}).build();
                value2 = this.value2.getValue();
                type = this.value2.getType();
            } else {
                Class<?> temporalType = JavaSpecUtil.type(this.value1.getType());
                value1 = this.value1.getValue();
                value2 = CodeBlock.builder().add("$T.parse($L)", new Object[]{temporalType, this.value2.getValue()}).build();
                type = this.value1.getType();
            }
            return ImmutableScalarConverterCode.builder().type(type).value1(value1).value2(value2).build();
        }
        throw new HdesCompilerException(HdesCompilerException.builder().unknownExpression(this.src));
    }

    @Value.Immutable
    public static interface ScalarConverterCode {
        public CodeBlock getValue1();

        public CodeBlock getValue2();

        public BodyNode.ScalarType getType();
    }
}

