/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.fl.visitors;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.visitors.FlowBodyVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.FlSpec;
import io.resys.hdes.compiler.spi.fl.visitors.ImmutableFlHeaderSpec;
import io.resys.hdes.compiler.spi.fl.visitors.ImmutableFlHeadersSpec;
import io.resys.hdes.compiler.spi.spec.HdesDefSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.TraceBody;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public class FlApiVisitor
implements FlowBodyVisitor<FlSpec, TypeSpec>,
FlowBodyVisitor.FlowStepVisitor<FlSpec, FlSpec> {
    public TypeSpec visitBody(HdesTree.FlowTree ctx) {
        CompilerNode.FlowUnit type = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        CompilerNode.CompilerType compilerType = type.getType();
        HdesDefSpec.ApiBuilder api = HdesDefSpec.api(compilerType);
        this.visitHeaders(ctx.getValue().getHeaders(), (HdesTree)ctx).getValue().accept(api);
        ctx.getValue().getStep().map(t -> this.visitStep((FlowNode.Step)t, (HdesTree)ctx)).ifPresent(spec -> spec.getNested().accept(api));
        return api.build().build();
    }

    public FlHeadersSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        Consumer<HdesDefSpec.ApiBuilder> consumer = api -> {
            FlHeaderSpec header;
            ImmutableSpec.ImmutableBuilder input = api.inputValue();
            ImmutableSpec.ImmutableBuilder output = api.outputValue();
            for (BodyNode.TypeDef typeDef : node.getAcceptDefs()) {
                header = this.visitHeader(typeDef, next);
                header.getValue().accept(input);
                header.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            for (BodyNode.TypeDef typeDef : node.getReturnDefs()) {
                header = this.visitHeader(typeDef, next);
                header.getValue().accept(output);
                header.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            input.build();
            output.build();
        };
        return ImmutableFlHeadersSpec.builder().value(consumer).build();
    }

    public FlHeaderSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        if (node instanceof BodyNode.ScalarDef) {
            return this.visitHeader((BodyNode.ScalarDef)node, ctx);
        }
        return this.visitHeader((BodyNode.ObjectDef)node, ctx);
    }

    public FlHeaderSpec visitHeader(BodyNode.ScalarDef node, HdesTree ctx) {
        return ImmutableFlHeaderSpec.builder().value(immutable -> immutable.method(node).build()).nested(api -> {}).build();
    }

    public FlHeaderSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        Consumer<HdesDefSpec.ApiBuilder> nested = api -> {
            ImmutableSpec.ImmutableBuilder immutable = node.getContext() == BodyNode.ContextTypeDef.ACCEPTS ? api.inputValue(unit.getAccepts(node).getName()) : api.outputValue(unit.getReturns(node).getName());
            for (BodyNode.TypeDef type : node.getValues()) {
                FlHeaderSpec spec = this.visitHeader(type, ctx.next((HdesNode)type));
                spec.getValue().accept(immutable);
                spec.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            immutable.build();
        };
        ClassName typeName = node.getContext() == BodyNode.ContextTypeDef.ACCEPTS ? unit.getAccepts(node).getName() : unit.getReturns(node).getName();
        return ImmutableFlHeaderSpec.builder().value(arg_0 -> FlApiVisitor.lambda$visitHeader$6(node, (TypeName)typeName, arg_0)).nested(nested).build();
    }

    public FlHeaderSpec visitStep(FlowNode.Step step, HdesTree ctx) {
        return this.visitBody(step, ctx);
    }

    public FlHeaderSpec visitBody(FlowNode.Step step, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)step);
        FlHeaderSpec action = this.visitAction(step.getAction(), next);
        FlHeaderSpec pointer = this.visitPointer(step.getPointer(), next);
        Optional<FlHeaderSpec> as = step.getAs().map(v -> this.visitStepAs((FlowNode.StepAs)v, next));
        return ImmutableFlHeaderSpec.builder().nested(api -> {
            action.getNested().accept((HdesDefSpec.ApiBuilder)api);
            pointer.getNested().accept((HdesDefSpec.ApiBuilder)api);
            as.ifPresent(v -> v.getNested().accept((HdesDefSpec.ApiBuilder)api));
        }).value(code -> {}).build();
    }

    public FlHeaderSpec visitAction(FlowNode.StepAction action, HdesTree ctx) {
        if (action instanceof FlowNode.CallAction) {
            return this.visitCallAction((FlowNode.CallAction)action, ctx);
        }
        if (action instanceof FlowNode.IterateAction) {
            return this.visitIterateAction((FlowNode.IterateAction)action, ctx);
        }
        if (action instanceof FlowNode.EmptyAction) {
            return ImmutableFlHeaderSpec.builder().nested(api -> {}).value(code -> {}).build();
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlHeaderSpec visitIterateAction(FlowNode.IterateAction action, HdesTree ctx) {
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        FlowNode.Step step = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
        Optional endDef = ctx.step().findEnd(action.getStep());
        if (endDef.isEmpty()) {
            return ImmutableFlHeaderSpec.builder().nested(api -> {}).value(code -> {}).build();
        }
        Consumer<HdesDefSpec.ApiBuilder> nested = api -> {
            ImmutableSpec.ImmutableBuilder immutable = api.outputValue(unit.getEndAs(step).getName()).superinterface(TraceBody.class);
            for (BodyNode.TypeDef type : ((BodyNode.ObjectDef)endDef.get()).getValues()) {
                FlHeaderSpec spec = this.visitHeader(type, ctx.next((HdesNode)type));
                spec.getValue().accept(immutable);
                spec.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            immutable.build();
        };
        return ImmutableFlHeaderSpec.builder().nested(nested).value(code -> {}).build();
    }

    public FlHeaderSpec visitPointer(FlowNode.StepPointer pointer, HdesTree ctx) {
        if (pointer instanceof FlowNode.EndPointer) {
            return this.visitEndPointer((FlowNode.EndPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.SplitPointer) {
            return this.visitSplitPointer((FlowNode.SplitPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.WhenPointer) {
            return this.visitWhenPointer((FlowNode.WhenPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.ThenPointer) {
            return this.visitThenPointer((FlowNode.ThenPointer)pointer, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlHeaderSpec visitSplitPointer(FlowNode.SplitPointer pointer, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)pointer);
        List nested = pointer.getValues().stream().map(p -> this.visitPointer((FlowNode.StepPointer)p, next)).collect(Collectors.toList());
        return ImmutableFlHeaderSpec.builder().nested(api -> nested.forEach(v -> v.getNested().accept((HdesDefSpec.ApiBuilder)api))).value(code -> {}).build();
    }

    public FlHeaderSpec visitStepAs(FlowNode.StepAs stepAs, HdesTree ctx) {
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        FlowNode.Step step = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
        BodyNode.ObjectDef endDef = (BodyNode.ObjectDef)ctx.step().getDefAs(step).get();
        Consumer<HdesDefSpec.ApiBuilder> nested = api -> {
            ImmutableSpec.ImmutableBuilder immutable = api.outputValue(unit.getEndAs(step).getName()).superinterface(TraceBody.class);
            for (BodyNode.TypeDef type : endDef.getValues()) {
                FlHeaderSpec spec = this.visitHeader(type, ctx.next((HdesNode)type));
                spec.getValue().accept(immutable);
                spec.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            immutable.build();
        };
        return ImmutableFlHeaderSpec.builder().nested(nested).value(code -> {}).build();
    }

    public FlHeaderSpec visitWhenPointer(FlowNode.WhenPointer pointer, HdesTree ctx) {
        return this.visitPointer(pointer.getThen(), ctx.next((HdesNode)pointer));
    }

    public FlHeaderSpec visitThenPointer(FlowNode.ThenPointer pointer, HdesTree ctx) {
        return this.visitStep(pointer.getStep(), ctx.next((HdesNode)pointer));
    }

    public FlHeaderSpec visitEndPointer(FlowNode.EndPointer pointer, HdesTree ctx) {
        return ImmutableFlHeaderSpec.builder().nested(api -> {}).value(code -> {}).build();
    }

    public FlHeaderSpec visitCallAction(FlowNode.CallAction action, HdesTree ctx) {
        return ImmutableFlHeaderSpec.builder().nested(api -> {}).value(code -> {}).build();
    }

    public FlHeaderSpec visitCallDef(FlowNode.CallDef def, HdesTree ctx) {
        return ImmutableFlHeaderSpec.builder().nested(api -> {}).value(code -> {}).build();
    }

    public FlSpec visitIterationEndPointer(FlowNode.IterationEndPointer pointer, HdesTree ctx) {
        return ImmutableFlHeaderSpec.builder().nested(api -> {}).value(code -> {}).build();
    }

    private static /* synthetic */ void lambda$visitHeader$6(BodyNode.ObjectDef node, TypeName typeName, ImmutableSpec.ImmutableBuilder immutable) {
        immutable.method(node, typeName).build();
    }

    @Value.Immutable
    public static interface FlHeadersSpec
    extends FlSpec {
        public Consumer<HdesDefSpec.ApiBuilder> getValue();
    }

    @Value.Immutable
    public static interface FlHeaderSpec
    extends FlSpec {
        public Consumer<ImmutableSpec.ImmutableBuilder> getValue();

        public Consumer<HdesDefSpec.ApiBuilder> getNested();
    }
}

