/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.fl.visitors;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.visitors.FlowBodyVisitor;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.fl.visitors.FlPointerVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.FlSpec;
import io.resys.hdes.compiler.spi.fl.visitors.FlWakeUpVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.ImmutableFlExecSpec;
import io.resys.hdes.compiler.spi.fl.visitors.mapping.FlowMappingFactory;
import io.resys.hdes.compiler.spi.spec.HdesDefSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.ImmutableAwait;
import io.resys.hdes.executor.api.ImmutableMaped;
import io.resys.hdes.executor.api.ImmutableMapedIterator;
import io.resys.hdes.executor.api.ImmutableNested;
import io.resys.hdes.executor.api.ImmutableStepId;
import io.resys.hdes.executor.api.Trace;
import io.resys.hdes.executor.spi.beans.ImmutableTrace;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.immutables.value.Value;

public class FlImplVisitor
implements FlowBodyVisitor<FlSpec, TypeSpec>,
FlowBodyVisitor.FlowStepVisitor<FlSpec, FlSpec> {
    private final List<HdesNode.Token> visited = new ArrayList<HdesNode.Token>();
    private static final String ACCESS_IT = "_it";
    private static final FlPointerVisitor POINTER_VISITOR = new FlPointerVisitor();

    public TypeSpec visitBody(HdesTree.FlowTree tree) {
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)tree.get().node(CompilerNode.FlowUnit.class);
        HdesDefSpec.ImplBuilder impl = HdesDefSpec.impl(unit.getType());
        this.addSteps(impl, tree, unit);
        FlImplVisitor.addContinue(impl, tree);
        return impl.build().build();
    }

    public FlExecSpec visitPointer(FlowNode.StepPointer pointer, HdesTree ctx) {
        if (pointer instanceof FlowNode.EndPointer) {
            return this.visitEndPointer((FlowNode.EndPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.SplitPointer) {
            return this.visitSplitPointer((FlowNode.SplitPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.WhenPointer) {
            return this.visitWhenPointer((FlowNode.WhenPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.ThenPointer) {
            return this.visitThenPointer((FlowNode.ThenPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.IterationEndPointer) {
            return this.visitIterationEndPointer((FlowNode.IterationEndPointer)pointer, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlExecSpec visitAction(FlowNode.StepAction action, HdesTree ctx) {
        if (action instanceof FlowNode.CallAction) {
            if (((FlowNode.Step)ctx.get().node(FlowNode.Step.class)).getAwait().booleanValue()) {
                return FlImplVisitor.visitWaitForAction((FlowNode.CallAction)action, ctx);
            }
            return this.visitCallAction((FlowNode.CallAction)action, ctx);
        }
        if (action instanceof FlowNode.IterateAction) {
            return this.visitIterateAction((FlowNode.IterateAction)action, ctx);
        }
        if (action instanceof FlowNode.EmptyAction) {
            return ImmutableFlExecSpec.builder().execution(api -> {}).value(code -> {}).build();
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlExecSpec visitStep(FlowNode.Step step, HdesTree ctx) {
        FlExecSpec body = this.visitBody(step, ctx);
        return ImmutableFlExecSpec.builder().execution(body.getExecution()).value(b -> b.addStatement("return $L(parent)", new Object[]{FlImplVisitor.visitMethodName(step, ctx)})).build();
    }

    public FlExecSpec visitBody(FlowNode.Step step, HdesTree ctx) {
        if (this.visited.contains(step.getToken())) {
            return ImmutableFlExecSpec.builder().execution(impl -> {}).value(code -> {}).build();
        }
        this.visited.add(step.getToken());
        HdesTree next = ctx.next((HdesNode)step);
        FlExecSpec children = this.visitPointer(step.getPointer(), next);
        FlExecSpec action = this.visitAction(step.getAction(), next);
        Optional insideIteration = ctx.find().ctx(FlowNode.IterateAction.class);
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        ClassName returnType = insideIteration.isPresent() ? ClassName.get(Trace.TraceEnd.class) : unit.getType().getReturnType().getName();
        CodeBlock.Builder body = CodeBlock.builder();
        action.getValue().accept(body);
        if (step.getAs().isPresent()) {
            this.visitStepAs((FlowNode.StepAs)step.getAs().get(), next).getValue().accept(body);
        }
        children.getValue().accept(body);
        MethodSpec method = MethodSpec.methodBuilder((String)FlImplVisitor.visitMethodName(step, ctx)).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(Trace.class), (String)"parent", (Modifier[])new Modifier[0]).build()).addCode(body.build()).returns((TypeName)returnType).build();
        return ImmutableFlExecSpec.builder().execution(impl -> {
            impl.method(method);
            action.getExecution().accept((HdesDefSpec.ImplBuilder)impl);
            children.getExecution().accept((HdesDefSpec.ImplBuilder)impl);
        }).value(code -> {}).build();
    }

    public FlExecSpec visitSplitPointer(FlowNode.SplitPointer pointer, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)pointer);
        List nested = pointer.getValues().stream().map(p -> this.visitPointer((FlowNode.StepPointer)p, next)).collect(Collectors.toList());
        return ImmutableFlExecSpec.builder().execution(api -> nested.forEach(e -> e.getExecution().accept((HdesDefSpec.ImplBuilder)api))).value(POINTER_VISITOR.visitSplitPointer(pointer, ctx).getValue()).build();
    }

    public FlExecSpec visitWhenPointer(FlowNode.WhenPointer pointer, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)pointer);
        FlExecSpec conclusion = this.visitPointer(pointer.getThen(), next);
        return ImmutableFlExecSpec.builder().execution(api -> conclusion.getExecution().accept((HdesDefSpec.ImplBuilder)api)).value(POINTER_VISITOR.visitWhenPointer(pointer, ctx).getValue()).build();
    }

    public FlExecSpec visitThenPointer(FlowNode.ThenPointer pointer, HdesTree ctx) {
        FlExecSpec next = this.visitBody(pointer.getStep(), ctx.next((HdesNode)pointer));
        CodeBlock.Builder body = CodeBlock.builder();
        if (!((FlowNode.Step)ctx.get().node(FlowNode.Step.class)).getAwait().booleanValue()) {
            POINTER_VISITOR.visitThenPointer(pointer, ctx).getValue().accept(body);
        }
        return ImmutableFlExecSpec.builder().execution(next.getExecution()).value(code -> code.add(body.build())).build();
    }

    public FlExecSpec visitEndPointer(FlowNode.EndPointer pointer, HdesTree ctx) {
        return ImmutableFlExecSpec.builder().execution(e -> {}).value(POINTER_VISITOR.visitEndPointer(pointer, ctx).getValue()).build();
    }

    public FlExecSpec visitCallAction(FlowNode.CallAction action, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)action);
        FlowNode.Step step = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
        CodeBlock.Builder callBody = CodeBlock.builder();
        CodeBlock.Builder traceBody = CodeBlock.builder().add("$T.builder()", new Object[]{ImmutableNested.class});
        if (action.getCalls().size() == 1) {
            this.visitCallDef((FlowNode.CallDef)action.getCalls().get(0), next).getValue().accept(callBody);
            traceBody.add(".addValues($L)", new Object[]{"call"});
        } else if (action.getCalls().size() > 1) {
            action.getCalls().forEach(c -> {
                this.visitCallDef((FlowNode.CallDef)c, next).getValue().accept(callBody);
                traceBody.add(".addValues($L)", new Object[]{"call" + c.getIndex().get()});
            });
        }
        return ImmutableFlExecSpec.builder().execution(api -> {}).value(code -> {
            code.add(callBody.build());
            String stepOrEnd = step.getPointer() instanceof FlowNode.IterationEndPointer ? "end" : "step";
            code.addStatement("parent = $T.builder().id($S).parent(parent).body($L.build()).$L()", new Object[]{ImmutableTrace.class, step.getId().getValue(), traceBody.build(), stepOrEnd});
        }).build();
    }

    public FlExecSpec visitIterateAction(FlowNode.IterateAction action, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)action);
        FlowNode.Step step = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
        CodeBlock mappedTo = action.getStep().map(childStep -> {
            CodeBlock traceBody = CodeBlock.builder().add("$T.builder().value($L).build()", new Object[]{ImmutableMapedIterator.class, ACCESS_IT}).build();
            CodeBlock parent = CodeBlock.builder().add("$T.builder().id($S).parent(mappedToParent).body($L).build()", new Object[]{ImmutableTrace.class, step.getId().getValue(), traceBody}).build();
            return CodeBlock.builder().add("$L($L)", new Object[]{FlImplVisitor.visitMethodName(childStep, next), parent}).build();
        }).orElseGet(() -> CodeBlock.builder().add("/* no mapping provided */ null", new Object[0]).build());
        CodeBlock iteration = CodeBlock.builder().add("$T.builder().values(mappedTo).build()", new Object[]{ImmutableMaped.class}).build();
        return ImmutableFlExecSpec.builder().execution(impl -> action.getStep().ifPresent(childStep -> this.visitStep((FlowNode.Step)childStep, next).getExecution().accept((HdesDefSpec.ImplBuilder)impl))).value(code -> {
            CodeBlock condition = ExpressionFactory.builder().body(action.getOver()).tree(next).build().getValue();
            code.addStatement("final var mappedToParent = parent", new Object[0]).addStatement("final var mappedTo = $L.stream().map($L -> $L).collect($T.toList())", new Object[]{condition, ACCESS_IT, mappedTo, Collectors.class}).addStatement("parent = $T.builder().id($S).body($L).step()", new Object[]{ImmutableTrace.class, step.getId().getValue(), iteration});
        }).build();
    }

    public FlExecSpec visitIterationEndPointer(FlowNode.IterationEndPointer pointer, HdesTree ctx) {
        return ImmutableFlExecSpec.builder().execution(e -> {}).value(POINTER_VISITOR.visitIterationEndPointer(pointer, ctx).getValue()).build();
    }

    public FlExecSpec visitStepAs(FlowNode.StepAs stepAs, HdesTree ctx) {
        FlowNode.Step step = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
        CodeBlock as = FlowMappingFactory.from(stepAs, ctx);
        CodeBlock body = CodeBlock.builder().addStatement("parent = $T.builder().id($S).body($L).parent(parent).step()", new Object[]{ImmutableTrace.class, step.getId().getValue(), as}).build();
        return ImmutableFlExecSpec.builder().execution(e -> {}).value(b -> b.add(body)).build();
    }

    public FlExecSpec visitCallDef(FlowNode.CallDef def, HdesTree ctx) {
        return ImmutableFlExecSpec.builder().execution(api -> {}).value(code -> code.add(FlowMappingFactory.from(def, ctx))).build();
    }

    private void addSteps(HdesDefSpec.ImplBuilder impl, HdesTree.FlowTree tree, CompilerNode.FlowUnit unit) {
        CodeBlock.Builder code = CodeBlock.builder().addStatement("final var parent = $T.builder().id($S).body($L).build()", new Object[]{ImmutableTrace.class, "input", "input"});
        FlExecSpec step = tree.getValue().getStep().map(s -> this.visitStep((FlowNode.Step)s, (HdesTree)tree)).orElseGet(() -> ImmutableFlExecSpec.builder().execution(e -> {}).value(b -> b.addStatement("final var returns = $T.builder().build()", new Object[]{ImmutableSpec.from(unit.getType().getReturns().getName())}).addStatement("return $T.builder().id($S).time(System.currentTimeMillis()).parent(parent).body(returns).build()", new Object[]{ImmutableSpec.from(unit.getType().getReturnType().getName()), tree.getValue().getId().getValue()})).build());
        step.getExecution().accept(impl);
        step.getValue().accept(code);
        impl.execution(code.build());
    }

    private static FlExecSpec visitWaitForAction(FlowNode.CallAction action, HdesTree ctx) {
        return ImmutableFlExecSpec.builder().execution(api -> {}).value(code -> {
            CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
            HdesTree next = ctx.next((HdesNode)action);
            FlowNode.Step step = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
            FlowNode.FlowBody flow = (FlowNode.FlowBody)ctx.get().node(FlowNode.FlowBody.class);
            FlowNode.CallDef event = (FlowNode.CallDef)action.getCalls().stream().findFirst().get();
            Optional insideIteration = ctx.find().ctx(FlowNode.IterateAction.class);
            ClassName returnType = insideIteration.isPresent() ? ClassName.get(Trace.TraceEnd.class) : unit.getType().getReturnType().getName();
            code.add(FlowMappingFactory.from(event, FlowBodyVisitor.MappingEvent.ON_ENTER, next)).addStatement("final var stepId = $T.builder().flow($S).flowStep($S).build()", new Object[]{ImmutableStepId.class, flow.getId().getValue(), step.getId().getValue()}).addStatement("final var suspend = $T.builder().trace(call).stepId(stepId).dataId(call.getBody().getDataId()).build()", new Object[]{ImmutableAwait.class}).addStatement("final var end = $T.builder().parent(parent).suspend(suspend).id($S).suspend()", new Object[]{ImmutableTrace.class, flow.getId().getValue()}).addStatement("return $T.builder().from(end).build()", new Object[]{ImmutableSpec.from(returnType)});
        }).build();
    }

    public static String visitMethodName(FlowNode.Step step, HdesTree ctx) {
        Optional iterate;
        Object name = step.getId().getValue();
        if (((String)name).isEmpty() && (iterate = ctx.find().ctx(FlowNode.IterateAction.class)).isPresent()) {
            FlowNode.Step origin = (FlowNode.Step)((HdesTree)iterate.get()).get().node(FlowNode.Step.class);
            name = origin.getId().getValue() + "_It";
        }
        return "visit" + ((String)name).substring(0, 1).toUpperCase() + (((String)name).length() == 1 ? "" : ((String)name).substring(1));
    }

    private static void addContinue(HdesDefSpec.ImplBuilder impl, HdesTree.FlowTree tree) {
        FlExecSpec continueSpec = new FlWakeUpVisitor().visitBody(tree);
        CodeBlock.Builder wakeup = CodeBlock.builder();
        continueSpec.getValue().accept(wakeup);
        continueSpec.getExecution().accept(impl);
        impl.wakeup(wakeup.build());
    }

    public FlSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitHeader(BodyNode.ScalarDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    @Value.Immutable
    public static interface FlExecSpec
    extends FlSpec {
        public Consumer<HdesDefSpec.ImplBuilder> getExecution();

        public Consumer<CodeBlock.Builder> getValue();
    }
}

