/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.fl.visitors;

import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.visitors.FlowBodyVisitor;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.fl.visitors.FlSpec;
import io.resys.hdes.compiler.spi.fl.visitors.ImmutableFlPointerSpec;
import io.resys.hdes.compiler.spi.fl.visitors.mapping.FlowMappingFactory;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.Trace;
import io.resys.hdes.executor.spi.beans.ImmutableMatchedCondition;
import io.resys.hdes.executor.spi.beans.ImmutableTrace;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public class FlPointerVisitor
implements FlowBodyVisitor.FlowPointerVisitor<FlSpec, FlSpec> {
    public FlPointerSpec visitPointer(FlowNode.StepPointer pointer, HdesTree ctx) {
        if (pointer instanceof FlowNode.EndPointer) {
            return this.visitEndPointer((FlowNode.EndPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.SplitPointer) {
            return this.visitSplitPointer((FlowNode.SplitPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.WhenPointer) {
            return this.visitWhenPointer((FlowNode.WhenPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.ThenPointer) {
            return this.visitThenPointer((FlowNode.ThenPointer)pointer, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlPointerSpec visitSplitPointer(FlowNode.SplitPointer pointer, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)pointer);
        List nested = pointer.getValues().stream().map(p -> this.visitPointer((FlowNode.StepPointer)p, next)).collect(Collectors.toList());
        CodeBlock.Builder code = CodeBlock.builder();
        int index = -1;
        for (FlowNode.StepPointer step : pointer.getValues()) {
            CodeBlock.Builder builder = CodeBlock.builder();
            ((FlPointerSpec)nested.get(++index)).getValue().accept(builder);
            CodeBlock controlCode = builder.build();
            if (controlCode.isEmpty()) continue;
            if (index > 0) {
                code.add("else ", new Object[0]);
            }
            if (step instanceof FlowNode.WhenPointer) {
                code.add(controlCode);
                continue;
            }
            code.add("{", new Object[0]).add(controlCode).add("}", new Object[0]);
        }
        return ImmutableFlPointerSpec.builder().value(c -> c.add(code.build())).build();
    }

    public FlPointerSpec visitWhenPointer(FlowNode.WhenPointer pointer, HdesTree ctx) {
        FlowNode.Step parentStep = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
        HdesTree next = ctx.next((HdesNode)pointer);
        CodeBlock condition = ExpressionFactory.builder().body(pointer.getWhen()).tree(next).build().getValue();
        FlPointerSpec conclusion = this.visitPointer(pointer.getThen(), next);
        return ImmutableFlPointerSpec.builder().value(code -> {
            FlowNode.ThenPointer then = (FlowNode.ThenPointer)pointer.getThen();
            CodeBlock traceBody = CodeBlock.builder().add("$T.builder().id($S).src($S).build()", new Object[]{ImmutableMatchedCondition.class, then.getId().getValue(), pointer.getWhen().getSrc()}).build();
            CodeBlock parent = CodeBlock.builder().add("$T.builder().id($S).parent(parent).body($L).step()", new Object[]{ImmutableTrace.class, parentStep.getId().getValue(), traceBody}).build();
            code.beginControlFlow("if($L)", new Object[]{condition});
            code.addStatement("parent = $L", new Object[]{parent});
            conclusion.getValue().accept((CodeBlock.Builder)code);
            code.endControlFlow();
        }).build();
    }

    public FlPointerSpec visitThenPointer(FlowNode.ThenPointer pointer, HdesTree ctx) {
        return ImmutableFlPointerSpec.builder().value(code -> code.addStatement("return $L(parent)", new Object[]{FlPointerVisitor.visitMethodName(pointer.getStep())})).build();
    }

    public FlPointerSpec visitEndPointer(FlowNode.EndPointer pointer, HdesTree ctx) {
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        CodeBlock returnType = FlowMappingFactory.from(pointer, ctx);
        CodeBlock.Builder trace = CodeBlock.builder();
        Optional insideIteration = ctx.find().ctx(FlowNode.IterateAction.class);
        if (insideIteration.isPresent()) {
            String stepId = ((FlowNode.Step)ctx.get().node(FlowNode.Step.class)).getId().getValue();
            trace.addStatement("return $T.builder().id($S).parent(parent).body($L).end()", new Object[]{ImmutableTrace.class, stepId, returnType});
        } else {
            String flowId = ((FlowNode.FlowBody)ctx.get().node(FlowNode.FlowBody.class)).getId().getValue();
            trace.addStatement("return $T.builder().id($S).time(System.currentTimeMillis()).parent(parent).body($L).build()", new Object[]{ImmutableSpec.from(unit.getType().getReturnType().getName()), flowId, returnType});
        }
        return ImmutableFlPointerSpec.builder().value(code -> code.add(trace.build())).build();
    }

    public static String visitMethodName(FlowNode.Step step) {
        String name = step.getId().getValue();
        return "visit" + name.substring(0, 1).toUpperCase() + (name.length() == 1 ? "" : name.substring(1));
    }

    public FlPointerSpec visitIterationEndPointer(FlowNode.IterationEndPointer pointer, HdesTree ctx) {
        return ImmutableFlPointerSpec.builder().value(code -> code.addStatement("return ($T) parent", new Object[]{Trace.TraceEnd.class})).build();
    }

    @Value.Immutable
    public static interface FlPointerSpec
    extends FlSpec {
        public Consumer<CodeBlock.Builder> getValue();
    }
}

