/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.fl.visitors;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.visitors.FlowBodyVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.FlImplVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.FlPointerVisitor;
import io.resys.hdes.compiler.spi.fl.visitors.FlSpec;
import io.resys.hdes.compiler.spi.fl.visitors.ImmutableFlExecSpec;
import io.resys.hdes.compiler.spi.fl.visitors.mapping.FlowMappingFactory;
import io.resys.hdes.compiler.spi.spec.HdesDefSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.ImmutableNested;
import io.resys.hdes.executor.api.Trace;
import io.resys.hdes.executor.spi.beans.ImmutableTrace;
import io.resys.hdes.executor.spi.exceptions.FlowContinueException;
import io.resys.hdes.executor.spi.fl.ContinueNode;
import io.resys.hdes.executor.spi.fl.GetContinue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class FlWakeUpVisitor
implements FlowBodyVisitor<FlSpec, FlSpec>,
FlowBodyVisitor.FlowStepVisitor<FlSpec, FlSpec> {
    private final List<HdesNode.Token> visited = new ArrayList<HdesNode.Token>();

    public FlImplVisitor.FlExecSpec visitBody(HdesTree.FlowTree ctx) {
        if (ctx.getValue().getStep().isEmpty()) {
            return ImmutableFlExecSpec.builder().execution(api -> {}).value(body -> {}).build();
        }
        FlImplVisitor.FlExecSpec step = this.visitStep((FlowNode.Step)ctx.getValue().getStep().get(), (HdesTree)ctx);
        return ImmutableFlExecSpec.builder().execution(step.getExecution()).value(body -> {
            CodeBlock.Builder cases = CodeBlock.builder();
            step.getValue().accept(cases);
            body.addStatement("final var continueNode = $T.from(trace).body(wakeup)", new Object[]{GetContinue.class}).beginControlFlow("switch(continueNode.getStep())", new Object[0]).add(cases.build()).addStatement("default: throw new $T(continueNode)", new Object[]{FlowContinueException.class}).endControlFlow();
        }).build();
    }

    public FlImplVisitor.FlExecSpec visitStep(FlowNode.Step step, HdesTree ctx) {
        return this.visitBody(step, ctx);
    }

    public FlImplVisitor.FlExecSpec visitBody(FlowNode.Step step, HdesTree ctx) {
        if (this.visited.contains(step.getToken())) {
            return ImmutableFlExecSpec.builder().execution(impl -> {}).value(code -> {}).build();
        }
        this.visited.add(step.getToken());
        HdesTree next = ctx.next((HdesNode)step);
        FlImplVisitor.FlExecSpec children = this.visitPointer(step.getPointer(), next);
        FlImplVisitor.FlExecSpec action = this.visitAction(step.getAction(), next);
        return ImmutableFlExecSpec.builder().execution(impl -> {
            action.getExecution().accept((HdesDefSpec.ImplBuilder)impl);
            children.getExecution().accept((HdesDefSpec.ImplBuilder)impl);
        }).value(code -> {
            action.getValue().accept((CodeBlock.Builder)code);
            children.getValue().accept((CodeBlock.Builder)code);
        }).build();
    }

    public FlImplVisitor.FlExecSpec visitPointer(FlowNode.StepPointer pointer, HdesTree ctx) {
        if (pointer instanceof FlowNode.EndPointer) {
            return this.visitEndPointer((FlowNode.EndPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.SplitPointer) {
            return this.visitSplitPointer((FlowNode.SplitPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.WhenPointer) {
            return this.visitWhenPointer((FlowNode.WhenPointer)pointer, ctx);
        }
        if (pointer instanceof FlowNode.ThenPointer) {
            return this.visitThenPointer((FlowNode.ThenPointer)pointer, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlImplVisitor.FlExecSpec visitSplitPointer(FlowNode.SplitPointer pointer, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)pointer);
        List nested = pointer.getValues().stream().map(p -> this.visitPointer((FlowNode.StepPointer)p, next)).collect(Collectors.toList());
        return ImmutableFlExecSpec.builder().execution(api -> nested.forEach(e -> e.getExecution().accept((HdesDefSpec.ImplBuilder)api))).value(c -> nested.forEach(e -> e.getValue().accept((CodeBlock.Builder)c))).build();
    }

    public FlImplVisitor.FlExecSpec visitWhenPointer(FlowNode.WhenPointer pointer, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)pointer);
        return this.visitPointer(pointer.getThen(), next);
    }

    public FlImplVisitor.FlExecSpec visitThenPointer(FlowNode.ThenPointer pointer, HdesTree ctx) {
        FlImplVisitor.FlExecSpec next = this.visitBody(pointer.getStep(), ctx.next((HdesNode)pointer));
        return next;
    }

    public FlImplVisitor.FlExecSpec visitEndPointer(FlowNode.EndPointer pointer, HdesTree ctx) {
        return ImmutableFlExecSpec.builder().execution(e -> {}).value(code -> {}).build();
    }

    public FlImplVisitor.FlExecSpec visitAction(FlowNode.StepAction action, HdesTree ctx) {
        if (action instanceof FlowNode.CallAction) {
            return this.visitCallAction((FlowNode.CallAction)action, ctx);
        }
        if (action instanceof FlowNode.IterateAction) {
            return this.visitIterateAction((FlowNode.IterateAction)action, ctx);
        }
        if (action instanceof FlowNode.EmptyAction) {
            return ImmutableFlExecSpec.builder().execution(api -> {}).value(code -> {}).build();
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlImplVisitor.FlExecSpec visitCallAction(FlowNode.CallAction action, HdesTree ctx) {
        FlowNode.Step step = (FlowNode.Step)ctx.get().node(FlowNode.Step.class);
        if (!step.getAwait().booleanValue()) {
            return ImmutableFlExecSpec.builder().execution(api -> {}).value(code -> {}).build();
        }
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        HdesTree next = ctx.next((HdesNode)action);
        FlowNode.CallDef event = (FlowNode.CallDef)action.getCalls().stream().findFirst().get();
        Optional insideIteration = ctx.find().ctx(FlowNode.IterateAction.class);
        ClassName returnType = insideIteration.isPresent() ? ClassName.get(Trace.TraceEnd.class) : unit.getType().getReturnType().getName();
        CodeBlock.Builder traceBody = CodeBlock.builder().add("$T.builder()", new Object[]{ImmutableNested.class});
        if (action.getCalls().size() == 1) {
            traceBody.add(".addValues($L)", new Object[]{"call"});
        } else if (action.getCalls().size() > 1) {
            action.getCalls().forEach(c -> traceBody.add(".addValues($L)", new Object[]{"call" + c.getIndex().get()}));
        }
        CodeBlock.Builder body = CodeBlock.builder().addStatement("var parent = continueNode.getParent()", new Object[0]).addStatement("final var continueCall = ($T) continueNode.getBody().get()", new Object[]{ContinueNode.ContinueCall.class}).addStatement("final var dataId = continueCall.getDataId()", new Object[0]).addStatement("final var data = continueCall.getData()", new Object[0]).add(FlowMappingFactory.from(event, FlowBodyVisitor.MappingEvent.ON_COMPLETE, next)).addStatement("parent = $T.builder().id($S).parent(parent).body($L.build()).step()", new Object[]{ImmutableTrace.class, step.getId().getValue(), traceBody.build()});
        new FlPointerVisitor().visitPointer(step.getPointer(), next).getValue().accept(body);
        MethodSpec method = MethodSpec.methodBuilder((String)this.wakeupMethodName(step)).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(ContinueNode.class), (String)"continueNode", (Modifier[])new Modifier[0]).build()).addCode(body.build()).returns((TypeName)returnType).build();
        return ImmutableFlExecSpec.builder().execution(api -> api.method(method)).value(code -> code.beginControlFlow("case $S: ", new Object[]{step.getId().getValue()}).addStatement("return $L(continueNode)", new Object[]{this.wakeupMethodName(step)}).endControlFlow()).build();
    }

    public FlImplVisitor.FlExecSpec visitIterateAction(FlowNode.IterateAction action, HdesTree ctx) {
        return ImmutableFlExecSpec.builder().execution(impl -> {}).value(code -> {}).build();
    }

    public FlImplVisitor.FlExecSpec visitCallDef(FlowNode.CallDef def, HdesTree ctx) {
        return ImmutableFlExecSpec.builder().execution(api -> {}).value(code -> code.add(FlowMappingFactory.from(def, ctx))).build();
    }

    public FlSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitHeader(BodyNode.ScalarDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitIterationEndPointer(FlowNode.IterationEndPointer pointer, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public FlSpec visitStepAs(FlowNode.StepAs stepAs, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    private String wakeupMethodName(FlowNode.Step step) {
        String name = step.getId().getValue();
        return "onComplete" + name.substring(0, 1).toUpperCase() + (name.length() == 1 ? "" : name.substring(1));
    }
}

