/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.fl.visitors.mapping;

import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.MappingNode;
import io.resys.hdes.ast.api.visitors.FlowBodyVisitor;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.fl.visitors.FlSpec;
import io.resys.hdes.compiler.spi.fl.visitors.mapping.ImmutableFlEndMappingSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import java.util.Optional;
import java.util.function.Consumer;
import org.immutables.value.Value;

public class EndMappingDefVisitor
implements FlowBodyVisitor.FlowMappingDefVisitor<FlEndMappingSpec, CodeBlock> {
    public CodeBlock visitBody(FlowNode.EndPointer node, HdesTree ctx) {
        CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
        HdesTree next = ctx.next((HdesNode)node).next((HdesNode)node.getMapping());
        Optional insideIteration = ctx.find().ctx(FlowNode.IterateAction.class);
        CompilerNode.CompilerEntry returnType = insideIteration.isPresent() ? unit.getEndAs((FlowNode.Step)((HdesTree)insideIteration.get()).get().node(FlowNode.Step.class)) : unit.getType().getReturns();
        CodeBlock.Builder body = CodeBlock.builder().add("\r\n  ", new Object[0]).add("$T.builder()", new Object[]{ImmutableSpec.from(returnType.getName())});
        node.getMapping().getValues().forEach(def -> this.visitMappingDef((MappingNode.MappingDef)def, next).getValue().accept(body));
        return body.add(".build()", new Object[0]).build();
    }

    public FlEndMappingSpec visitFieldMappingDef(MappingNode.FieldMappingDef node, HdesTree ctx) {
        CodeBlock.Builder body = CodeBlock.builder();
        this.visitMappingDef(node.getRight(), ctx).getValue().accept(body);
        return ImmutableFlEndMappingSpec.builder().value(code -> code.add(".$L($L)", new Object[]{node.getLeft().getValue(), body.build()})).build();
    }

    public FlEndMappingSpec visitFastMappingDef(MappingNode.FastMappingDef node, HdesTree ctx) {
        BodyNode.TypeDef def = ctx.returns().build((HdesNode)node.getValue()).getReturns();
        CodeBlock exp = ExpressionFactory.builder().body(node.getValue()).tree(ctx.next((HdesNode)node)).build().getValue();
        return ImmutableFlEndMappingSpec.builder().value(code -> code.add(".$L($L)", new Object[]{def.getName(), exp})).build();
    }

    public FlEndMappingSpec visitExpressionMappingDef(MappingNode.ExpressionMappingDef node, HdesTree ctx) {
        return ImmutableFlEndMappingSpec.builder().value(code -> code.add(ExpressionFactory.builder().body(node.getValue()).tree(ctx.next((HdesNode)node)).build().getValue())).build();
    }

    public FlEndMappingSpec visitObjectMappingDef(MappingNode.ObjectMappingDef node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        return ImmutableFlEndMappingSpec.builder().value(code -> {
            node.getValues().forEach(d -> this.visitMappingDef((MappingNode.MappingDef)d, next).getValue().accept((CodeBlock.Builder)code));
            code.add(".build()", new Object[0]);
        }).build();
    }

    public FlEndMappingSpec visitMappingDef(MappingNode.MappingDef node, HdesTree ctx) {
        if (node instanceof MappingNode.ExpressionMappingDef) {
            return this.visitExpressionMappingDef((MappingNode.ExpressionMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.FastMappingDef) {
            return this.visitFastMappingDef((MappingNode.FastMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.FieldMappingDef) {
            return this.visitFieldMappingDef((MappingNode.FieldMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.ObjectMappingDef) {
            return this.visitObjectMappingDef((MappingNode.ObjectMappingDef)node, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public CodeBlock visitBody(FlowNode.CallDef node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public CodeBlock visitBody(FlowNode.CallDef def, FlowBodyVisitor.MappingEvent event, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public CodeBlock visitBody(FlowNode.StepAs def, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    @Value.Immutable
    public static interface FlEndMappingSpec
    extends FlSpec {
        public Consumer<CodeBlock.Builder> getValue();
    }
}

