/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.fl.visitors.mapping;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.MappingNode;
import io.resys.hdes.ast.api.visitors.FlowBodyVisitor;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.fl.visitors.FlSpec;
import io.resys.hdes.compiler.spi.fl.visitors.mapping.ImmutableFlowMappingSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import java.util.function.Consumer;
import org.immutables.value.Value;

public class FlowCallDefMappingDefVisitor
implements FlowBodyVisitor.FlowMappingDefVisitor<FlowMappingSpec, CodeBlock> {
    public CodeBlock visitBody(FlowNode.CallDef def, HdesTree ctx) {
        CompilerNode compilerNode = (CompilerNode)ctx.get().node(CompilerNode.class);
        String dependencyId = def.getId().getValue();
        FlowNode.FlowBody body = (FlowNode.FlowBody)ctx.getRoot().getBody(dependencyId);
        CompilerNode.FlowUnit unit = compilerNode.fl(body);
        CodeBlock.Builder mapping = CodeBlock.builder();
        this.visitObjectMappingDef(def.getMapping(), ctx.next((HdesNode)def).next((HdesNode)unit)).getValue().accept(mapping);
        String call = def.getIndex().map(index -> "call" + index).orElse("call");
        ClassName impl = unit.getType().getImpl().getName();
        CodeBlock.Builder result = CodeBlock.builder().addStatement("final var $L = new $T().apply($L)", new Object[]{call, impl, mapping.build()});
        return result.build();
    }

    public FlowMappingSpec visitMappingDef(MappingNode.MappingDef node, HdesTree ctx) {
        if (node instanceof MappingNode.ExpressionMappingDef) {
            return this.visitExpressionMappingDef((MappingNode.ExpressionMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.FastMappingDef) {
            return this.visitFastMappingDef((MappingNode.FastMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.FieldMappingDef) {
            return this.visitFieldMappingDef((MappingNode.FieldMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.ObjectMappingDef) {
            return this.visitObjectMappingDef((MappingNode.ObjectMappingDef)node, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public FlowMappingSpec visitObjectMappingDef(MappingNode.ObjectMappingDef node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        return ImmutableFlowMappingSpec.builder().value(c -> {
            CompilerNode.FlowUnit unit = (CompilerNode.FlowUnit)ctx.get().node(CompilerNode.FlowUnit.class);
            c.add("$T.builder()", new Object[]{ImmutableSpec.from(unit.getType().getAccepts().getName())});
            node.getValues().forEach(v -> this.visitMappingDef((MappingNode.MappingDef)v, next).getValue().accept((CodeBlock.Builder)c));
            c.add(".build()", new Object[0]);
        }).build();
    }

    public FlowMappingSpec visitFieldMappingDef(MappingNode.FieldMappingDef node, HdesTree ctx) {
        return ImmutableFlowMappingSpec.builder().value(code -> {
            CodeBlock.Builder body = CodeBlock.builder();
            this.visitMappingDef(node.getRight(), ctx).getValue().accept(body);
            code.add(".$L($L)", new Object[]{node.getLeft().getValue(), body.build()});
        }).build();
    }

    public FlowMappingSpec visitFastMappingDef(MappingNode.FastMappingDef node, HdesTree ctx) {
        BodyNode.TypeDef def = ctx.returns().build((HdesNode)node.getValue()).getReturns();
        CodeBlock exp = ExpressionFactory.builder().body(node.getValue()).tree(ctx.next((HdesNode)node)).build().getValue();
        return ImmutableFlowMappingSpec.builder().value(code -> code.add(".$L($L)", new Object[]{def.getName(), exp})).build();
    }

    public FlowMappingSpec visitExpressionMappingDef(MappingNode.ExpressionMappingDef node, HdesTree ctx) {
        return ImmutableFlowMappingSpec.builder().value(code -> code.add(ExpressionFactory.builder().body(node.getValue()).tree(ctx.next((HdesNode)node)).build().getValue())).build();
    }

    public CodeBlock visitBody(FlowNode.EndPointer node, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public CodeBlock visitBody(FlowNode.CallDef def, FlowBodyVisitor.MappingEvent event, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    public CodeBlock visitBody(FlowNode.StepAs def, HdesTree ctx) {
        throw new IllegalArgumentException("not implemented");
    }

    @Value.Immutable
    public static interface FlowMappingSpec
    extends FlSpec {
        public Consumer<CodeBlock.Builder> getValue();
    }
}

