/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.spec;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.spi.util.Assertions;
import io.resys.hdes.compiler.api.HdesCompiler;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.processing.Generated;
import javax.lang.model.element.Modifier;

public class HdesDefPromiseSpec {
    public static final String ACCESS_DATA_ID = "dataId";
    public static final String ACCESS_DATA = "data";
    public static final String ACCESS_TIMEOUT = "timeout";

    public static ApiBuilder api(CompilerNode.CompilerType compilerType) {
        return new ApiBuilder(compilerType);
    }

    public static ImplBuilder impl(CompilerNode.CompilerType compilerType) {
        Assertions.notNull((Object)compilerType, () -> "compilerType must be defined!");
        return new ImplBuilder(compilerType);
    }

    public static class ApiBuilder {
        private final CompilerNode.CompilerType compilerType;
        private final List<TypeSpec> types = new ArrayList<TypeSpec>();

        private ApiBuilder(CompilerNode.CompilerType compilerType) {
            this.compilerType = compilerType;
            this.immutable(compilerType.getReturnType().getName()).superinterface(compilerType.getReturnType().getSuperinterface()).method("body").isNullable(compilerType.getSourceType() == HdesCompiler.ResourceType.FL).returns((TypeName)compilerType.getReturns().getName()).build().build();
        }

        public ApiBuilder apply(Consumer<ApiBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        public ImmutableSpec.ImmutableBuilder immutable(ClassName name) {
            return ImmutableSpec.builder(name).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder inputValue() {
            return ImmutableSpec.inputValue(this.compilerType).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder inputValue(ClassName name) {
            return ImmutableSpec.inputValue(name).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder outputValue() {
            return ImmutableSpec.outputValue(this.compilerType).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder outputValue(ClassName name) {
            return ImmutableSpec.outputValue(name).callback(t -> this.types.add((TypeSpec)t));
        }

        public TypeSpec.Builder build() {
            AnnotationSpec annotation = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{HdesDefPromiseSpec.class.getCanonicalName()}).build();
            MethodSpec onEnter = MethodSpec.methodBuilder((String)"onEnter").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).returns(Trace.TracePromise.class).build();
            MethodSpec onComplete = MethodSpec.methodBuilder((String)"onComplete").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)HdesDefPromiseSpec.ACCESS_DATA_ID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Serializable.class, (String)HdesDefPromiseSpec.ACCESS_DATA, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            MethodSpec onError = MethodSpec.methodBuilder((String)"onError").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)HdesDefPromiseSpec.ACCESS_DATA_ID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            MethodSpec onTimeout = MethodSpec.methodBuilder((String)"onTimeout").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)HdesDefPromiseSpec.ACCESS_DATA_ID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Long.TYPE, (String)HdesDefPromiseSpec.ACCESS_TIMEOUT, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            return TypeSpec.interfaceBuilder((ClassName)this.compilerType.getApi().getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(annotation).addSuperinterface(this.compilerType.getApi().getSuperinterface()).addMethod(onEnter).addMethod(onComplete).addMethod(onError).addMethod(onTimeout).addTypes(this.types);
        }
    }

    public static class ImplBuilder {
        private final CompilerNode.CompilerType compilerType;
        private final List<MethodSpec> methods = new ArrayList<MethodSpec>();
        private final List<FieldSpec> fields = new ArrayList<FieldSpec>();
        private CodeBlock onEnter;
        private CodeBlock onComplete;
        private CodeBlock onTimeout;
        private CodeBlock onError;

        private ImplBuilder(CompilerNode.CompilerType compilerType) {
            this.compilerType = compilerType;
        }

        public ImplBuilder onEnter(CodeBlock onEnter) {
            this.onEnter = onEnter;
            return this;
        }

        public ImplBuilder onComplete(CodeBlock onComplete) {
            this.onComplete = onComplete;
            return this;
        }

        public ImplBuilder onTimeout(CodeBlock onTimeout) {
            this.onTimeout = onTimeout;
            return this;
        }

        public ImplBuilder onError(CodeBlock onError) {
            this.onError = onError;
            return this;
        }

        public ImplBuilder method(MethodSpec method) {
            this.methods.add(method);
            return this;
        }

        public ImplBuilder field(FieldSpec field) {
            this.fields.add(field);
            return this;
        }

        public ImplBuilder apply(Consumer<ImplBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        public TypeSpec.Builder build() {
            List<AnnotationSpec> annotations = Arrays.asList(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unused"}).build(), AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{HdesDefPromiseSpec.class.getCanonicalName()}).build());
            MethodSpec onEnter = MethodSpec.methodBuilder((String)"onEnter").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).addCode(Optional.ofNullable(this.onEnter).orElseGet(() -> CodeBlock.builder().addStatement("return null", new Object[0]).build())).returns(Trace.TracePromise.class).build();
            MethodSpec onComplete = MethodSpec.methodBuilder((String)"onComplete").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(String.class, (String)HdesDefPromiseSpec.ACCESS_DATA_ID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Serializable.class, (String)HdesDefPromiseSpec.ACCESS_DATA, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).addCode(Optional.ofNullable(this.onComplete).orElseGet(() -> CodeBlock.builder().addStatement("return null", new Object[0]).build())).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            MethodSpec onError = MethodSpec.methodBuilder((String)"onError").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(String.class, (String)HdesDefPromiseSpec.ACCESS_DATA_ID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).addCode(Optional.ofNullable(this.onError).orElseGet(() -> CodeBlock.builder().addStatement("return null", new Object[0]).build())).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            MethodSpec onTimeout = MethodSpec.methodBuilder((String)"onTimeout").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(String.class, (String)HdesDefPromiseSpec.ACCESS_DATA_ID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Long.TYPE, (String)HdesDefPromiseSpec.ACCESS_TIMEOUT, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)"input", (Modifier[])new Modifier[0]).build()).addCode(Optional.ofNullable(this.onTimeout).orElseGet(() -> CodeBlock.builder().addStatement("return null", new Object[0]).build())).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            return TypeSpec.classBuilder((ClassName)this.compilerType.getImpl().getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotations(annotations).addSuperinterface(this.compilerType.getImpl().getSuperinterface()).addFields(this.fields).addMethod(onEnter).addMethod(onComplete).addMethod(onError).addMethod(onTimeout).addMethods(this.methods);
        }
    }
}

