/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.spec;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.spi.util.Assertions;
import io.resys.hdes.compiler.api.HdesCompiler;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.HdesDefContinue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.processing.Generated;
import javax.lang.model.element.Modifier;

public class HdesDefSpec {
    public static final String METHOD_APPLY = "apply";
    public static final String ACCESS_INPUT_VALUE = "input";
    public static final String ACCESS_WAKEUP_VALUE = "wakeup";
    public static final String ACCESS_WAKEUP_TRACE = "trace";

    public static ApiBuilder api(CompilerNode.CompilerType compilerType) {
        return new ApiBuilder(compilerType);
    }

    public static ImplBuilder impl(CompilerNode.CompilerType compilerType) {
        Assertions.notNull((Object)compilerType, () -> "compilerType must be defined!");
        return new ImplBuilder(compilerType);
    }

    public static class ApiBuilder {
        private final CompilerNode.CompilerType compilerType;
        private final List<TypeSpec> types = new ArrayList<TypeSpec>();

        private ApiBuilder(CompilerNode.CompilerType compilerType) {
            this.compilerType = compilerType;
            this.immutable(compilerType.getReturnType().getName()).superinterface(compilerType.getReturnType().getSuperinterface()).method("body").isNullable(compilerType.getSourceType() == HdesCompiler.ResourceType.FL).returns((TypeName)compilerType.getReturns().getName()).build().build();
        }

        public ApiBuilder apply(Consumer<ApiBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        public ImmutableSpec.ImmutableBuilder immutable(ClassName name) {
            return ImmutableSpec.builder(name).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder inputValue() {
            return ImmutableSpec.inputValue(this.compilerType).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder inputValue(ClassName name) {
            return ImmutableSpec.inputValue(name).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder outputValue() {
            return ImmutableSpec.outputValue(this.compilerType).callback(t -> this.types.add((TypeSpec)t));
        }

        public ImmutableSpec.ImmutableBuilder outputValue(ClassName name) {
            return ImmutableSpec.outputValue(name).callback(t -> this.types.add((TypeSpec)t));
        }

        public TypeSpec.Builder build() {
            AnnotationSpec annotation = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{HdesDefSpec.class.getCanonicalName()}).build();
            MethodSpec apply = MethodSpec.methodBuilder((String)HdesDefSpec.METHOD_APPLY).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)HdesDefSpec.ACCESS_INPUT_VALUE, (Modifier[])new Modifier[0]).build()).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            return TypeSpec.interfaceBuilder((ClassName)this.compilerType.getApi().getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(annotation).addSuperinterface(this.compilerType.getApi().getSuperinterface()).addMethod(apply).addTypes(this.types);
        }
    }

    public static class ImplBuilder {
        private final CompilerNode.CompilerType compilerType;
        private final List<MethodSpec> methods = new ArrayList<MethodSpec>();
        private final List<FieldSpec> fields = new ArrayList<FieldSpec>();
        private CodeBlock execution;
        private CodeBlock wakeup;

        private ImplBuilder(CompilerNode.CompilerType compilerType) {
            this.compilerType = compilerType;
        }

        public ImplBuilder execution(CodeBlock execution) {
            this.execution = execution;
            return this;
        }

        public ImplBuilder wakeup(CodeBlock wakeup) {
            if (!wakeup.isEmpty()) {
                this.wakeup = wakeup;
            }
            return this;
        }

        public ImplBuilder method(MethodSpec method) {
            this.methods.add(method);
            return this;
        }

        public ImplBuilder field(FieldSpec field) {
            this.fields.add(field);
            return this;
        }

        public ImplBuilder apply(Consumer<ImplBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        public TypeSpec.Builder build() {
            Assertions.notNull((Object)this.execution, () -> "execution must be defined!");
            List<AnnotationSpec> annotations = Arrays.asList(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unused"}).build(), AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{HdesDefSpec.class.getCanonicalName()}).build());
            MethodSpec apply = MethodSpec.methodBuilder((String)HdesDefSpec.METHOD_APPLY).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getAccepts().getName(), (String)HdesDefSpec.ACCESS_INPUT_VALUE, (Modifier[])new Modifier[0]).build()).addCode(this.execution).returns((TypeName)this.compilerType.getReturnType().getName()).build();
            TypeSpec.Builder result = TypeSpec.classBuilder((ClassName)this.compilerType.getImpl().getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotations(annotations).addSuperinterface(this.compilerType.getImpl().getSuperinterface()).addFields(this.fields).addMethod(apply).addMethods(this.methods);
            if (this.wakeup != null) {
                result.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(HdesDefContinue.class), (TypeName[])new TypeName[]{this.compilerType.getAccepts().getName(), this.compilerType.getReturnType().getName()}));
                MethodSpec wakeup = MethodSpec.methodBuilder((String)HdesDefSpec.METHOD_APPLY).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)this.compilerType.getReturnType().getName(), (String)HdesDefSpec.ACCESS_WAKEUP_TRACE, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(HdesDefContinue.HdesWakeup.class, (String)HdesDefSpec.ACCESS_WAKEUP_VALUE, (Modifier[])new Modifier[0]).build()).addCode(this.wakeup).returns((TypeName)this.compilerType.getReturnType().getName()).build();
                result.addMethod(wakeup);
            }
            return result;
        }
    }
}

