/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.spec;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.spi.util.Assertions;
import io.resys.hdes.compiler.spi.spec.JavaSpecUtil;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.TraceBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import org.immutables.value.Value;

public class ImmutableSpec {
    public static ImmutableBuilder builder() {
        return new ImmutableBuilder();
    }

    public static ClassName from(ClassName src) {
        String pkg = src.packageName();
        int index = pkg.lastIndexOf(".");
        String top = index > -1 && Character.isUpperCase(pkg.charAt(index + 1)) ? pkg.substring(0, index) : pkg;
        return ClassName.get((String)top, (String)("Immutable" + src.simpleName()), (String[])new String[0]);
    }

    public static ClassName immutableBuilder(ClassName src) {
        ClassName type = ImmutableSpec.from(src);
        return ClassName.get((String)type.packageName(), (String)(type.simpleName() + ".Builder"), (String[])new String[0]);
    }

    public static ImmutableBuilder builder(ClassName name) {
        return new ImmutableBuilder().name(name);
    }

    public static ImmutableBuilder inputValue(CompilerNode.CompilerType type) {
        return ImmutableSpec.inputValue(type.getAccepts().getName());
    }

    public static ImmutableBuilder inputValue(ClassName type) {
        return new ImmutableBuilder().name(type).superinterface(TraceBody.Accepts.class);
    }

    public static ImmutableBuilder outputValue(ClassName type) {
        return new ImmutableBuilder().superinterface(TraceBody.Returns.class).name(type);
    }

    public static ImmutableBuilder outputValue(CompilerNode.CompilerType type) {
        return ImmutableSpec.outputValue(type.getReturns().getName());
    }

    public static class ImmutableBuilder {
        private final List<MethodSpec> methods = new ArrayList<MethodSpec>();
        private final List<TypeName> superinterfaces = new ArrayList<TypeName>();
        private ClassName name;
        private Consumer<TypeSpec> callback = t -> {};

        private ImmutableBuilder() {
        }

        public ImmutableBuilder callback(Consumer<TypeSpec> callback) {
            this.callback = callback;
            return this;
        }

        public MethodBuilder method() {
            final ImmutableBuilder that = this;
            return new MethodBuilder(){

                @Override
                public ImmutableBuilder build() {
                    methods.add(super.buildInnerType());
                    return that;
                }
            };
        }

        public MethodBuilder method(BodyNode.ScalarDef scalar) {
            return this.method().name(scalar.getName()).isOptional(scalar.getRequired() == false).isList(scalar.getArray()).returns(scalar.getType());
        }

        public MethodBuilder method(BodyNode.ObjectDef object, TypeName returns) {
            return this.method().name(object.getName()).isOptional(object.getRequired() == false).isList(object.getArray()).returns(returns);
        }

        public MethodBuilder method(String name) {
            return this.method().name(name);
        }

        public MethodBuilder method(InvocationNode.SimpleInvocation from) {
            return this.method().name(from);
        }

        public ImmutableBuilder superinterface(TypeName typeName) {
            this.superinterfaces.add(typeName);
            return this;
        }

        public ImmutableBuilder superinterface(Class<?> typeName) {
            this.superinterfaces.add((TypeName)ClassName.get(typeName));
            return this;
        }

        public ImmutableBuilder name(ClassName name) {
            this.name = name;
            return this;
        }

        public TypeSpec build() {
            Assertions.notNull((Object)this.name, () -> "name must be defined!");
            ClassName immutable = ImmutableSpec.from(this.name);
            TypeSpec result = TypeSpec.interfaceBuilder((ClassName)this.name).addSuperinterfaces(this.superinterfaces).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addMethods(this.methods).addAnnotation(Value.Immutable.class).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get(Value.Style.class)).addMember("jdkOnly", "true", new Object[0]).build()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"com.fasterxml.jackson.databind.annotation", (String)"JsonSerialize", (String[])new String[0])).addMember("as", "$T.class", new Object[]{immutable}).build()).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"com.fasterxml.jackson.databind.annotation", (String)"JsonDeserialize", (String[])new String[0])).addMember("as", "$T.class", new Object[]{immutable}).build()).build();
            this.callback.accept(result);
            return result;
        }
    }

    public static abstract class MethodBuilder {
        private String name;
        private TypeName returns;
        private boolean isList;
        private boolean isOptional;
        private boolean isNullable;

        public MethodBuilder name(InvocationNode.SimpleInvocation from) {
            this.name = JavaSpecUtil.getMethodName(from.getValue());
            return this;
        }

        public MethodBuilder name(String from) {
            this.name = JavaSpecUtil.getMethodName(from);
            return this;
        }

        public MethodBuilder returns(BodyNode.ScalarType type) {
            Class<?> javaType = JavaSpecUtil.type(type);
            this.returns = ClassName.get(javaType);
            return this;
        }

        public MethodBuilder returns(TypeName type) {
            this.returns = type;
            return this;
        }

        public MethodBuilder isList() {
            this.isList = true;
            return this;
        }

        public MethodBuilder isList(boolean isList) {
            this.isList = isList;
            return this;
        }

        public MethodBuilder isOptional() {
            this.isOptional = true;
            return this;
        }

        public MethodBuilder isOptional(boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        public MethodBuilder isNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        private MethodSpec buildInnerType() {
            Assertions.notNull((Object)this.name, () -> "name must be defined!");
            Assertions.notNull((Object)this.returns, () -> "returns must be defined!");
            Object returnType = this.isList ? ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.returns}) : (this.isOptional ? ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{(ClassName)this.returns}) : this.returns);
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)this.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(returnType);
            if (this.isNullable) {
                method.addAnnotation(AnnotationSpec.builder(Nullable.class).build());
            }
            return method.build();
        }

        public abstract ImmutableBuilder build();
    }
}

