/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.spec;

import io.resys.hdes.ast.api.nodes.BodyNode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class JavaSpecUtil {
    public static String methodCall(String name) {
        String[] src = name.split("\\.");
        StringBuilder result = new StringBuilder();
        for (String target : src) {
            if (result.length() > 0) {
                result.append(".");
            }
            result.append("get").append(JavaSpecUtil.capitalize(target)).append("()");
        }
        return result.toString();
    }

    public static String getMethodName(String name) {
        return "get" + JavaSpecUtil.capitalize(name);
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + (name.length() == 1 ? "" : name.substring(1));
    }

    public static String decapitalize(String name) {
        return name.substring(0, 1).toLowerCase() + (name.length() == 1 ? "" : name.substring(1));
    }

    public static Class<?> type(BodyNode.ScalarType entry) {
        switch (entry) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case DATE: {
                return LocalDate.class;
            }
            case DATETIME: {
                return LocalDateTime.class;
            }
            case TIME: {
                return LocalTime.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("Unimplemented type: " + entry + "!");
    }
}

