/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.st.mapping;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.nodes.MappingNode;
import io.resys.hdes.ast.api.visitors.ServiceBodyVisitor;
import io.resys.hdes.compiler.spi.expressions.ExpressionFactory;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.st.mapping.ImmutableStMappingSpec;
import io.resys.hdes.compiler.spi.st.mapping.ServiceMappingFactory;
import io.resys.hdes.compiler.spi.st.visitors.StSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;

public class ServiceAcceptsMapping
implements ServiceBodyVisitor.ServiceMappingDefVisitor<StSpec, CodeBlock> {
    public CodeBlock visitBody(MappingNode.ObjectMappingDef node, HdesTree ctx) {
        CodeBlock.Builder builder = CodeBlock.builder();
        this.visitObjectMappingDef(node, ctx).getValue().accept(builder);
        return builder.build();
    }

    public ServiceMappingFactory.StMappingSpec visitMappingDef(MappingNode.MappingDef node, HdesTree ctx) {
        if (node instanceof MappingNode.ExpressionMappingDef) {
            return this.visitExpressionMappingDef((MappingNode.ExpressionMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.FastMappingDef) {
            return this.visitFastMappingDef((MappingNode.FastMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.FieldMappingDef) {
            return this.visitFieldMappingDef((MappingNode.FieldMappingDef)node, ctx);
        }
        if (node instanceof MappingNode.ObjectMappingDef) {
            return this.visitObjectMappingDef((MappingNode.ObjectMappingDef)node, ctx);
        }
        throw new IllegalArgumentException("not implemented");
    }

    public ServiceMappingFactory.StMappingSpec visitObjectMappingDef(MappingNode.ObjectMappingDef node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        return ImmutableStMappingSpec.builder().value(c -> {
            CompilerNode.ServiceUnit unit = (CompilerNode.ServiceUnit)ctx.get().node(CompilerNode.ServiceUnit.class);
            String canonicalName = this.visitInvocation(unit.getBody().getCommand().getClassName());
            c.add("$T.builder()", new Object[]{ImmutableSpec.from(ClassName.bestGuess((String)(canonicalName + "Mapping")))});
            node.getValues().forEach(v -> this.visitMappingDef((MappingNode.MappingDef)v, next).getValue().accept((CodeBlock.Builder)c));
            c.add(".build()", new Object[0]);
        }).build();
    }

    public ServiceMappingFactory.StMappingSpec visitFieldMappingDef(MappingNode.FieldMappingDef node, HdesTree ctx) {
        return ImmutableStMappingSpec.builder().value(code -> {
            CodeBlock.Builder body = CodeBlock.builder();
            this.visitMappingDef(node.getRight(), ctx).getValue().accept(body);
            code.add(".$L($L)", new Object[]{node.getLeft().getValue(), body.build()});
        }).build();
    }

    public ServiceMappingFactory.StMappingSpec visitFastMappingDef(MappingNode.FastMappingDef node, HdesTree ctx) {
        BodyNode.TypeDef def = ctx.returns().build((HdesNode)node.getValue()).getReturns();
        CodeBlock exp = ExpressionFactory.builder().body(node.getValue()).tree(ctx.next((HdesNode)node)).build().getValue();
        return ImmutableStMappingSpec.builder().value(code -> code.add(".$L($L)", new Object[]{def.getName(), exp})).build();
    }

    public ServiceMappingFactory.StMappingSpec visitExpressionMappingDef(MappingNode.ExpressionMappingDef node, HdesTree ctx) {
        return ImmutableStMappingSpec.builder().value(code -> code.add(ExpressionFactory.builder().body(node.getValue()).tree(ctx.next((HdesNode)node)).build().getValue())).build();
    }

    private String visitInvocation(InvocationNode invocation) {
        if (invocation instanceof InvocationNode.SimpleInvocation) {
            InvocationNode.SimpleInvocation simple = (InvocationNode.SimpleInvocation)invocation;
            return simple.getValue();
        }
        if (invocation instanceof InvocationNode.NestedInvocation) {
            InvocationNode.NestedInvocation nested = (InvocationNode.NestedInvocation)invocation;
            String path = this.visitInvocation(nested.getPath());
            String value = this.visitInvocation(nested.getValue());
            return path + "." + value;
        }
        throw new IllegalArgumentException("Not supported invocation: " + invocation + "!");
    }
}

